/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.entity.effect;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.network.IPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;
import org.cyclops.cyclopscore.client.particle.ParticleBlurData;
import org.cyclops.evilcraft.EvilCraftSoundEvents;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.entity.monster.EntityVengeanceSpirit;

public class EntityAntiVengeanceBeam
extends ThrowableEntity {
    private static final int MAX_AGE = 200;
    private int age = 0;
    private int soundTick = 0;

    public EntityAntiVengeanceBeam(EntityType<? extends EntityAntiVengeanceBeam> type, World world) {
        super(type, world);
        this.func_213317_d(this.func_213322_ci().func_216372_d(0.25, 0.25, 0.25));
    }

    public EntityAntiVengeanceBeam(EntityType<? extends EntityAntiVengeanceBeam> type, World world, LivingEntity entity) {
        super(type, entity, world);
        this.func_213317_d(this.func_213322_ci().func_216372_d(0.25, 0.25, 0.25));
    }

    public EntityAntiVengeanceBeam(World world, LivingEntity entity) {
        super(RegistryEntries.ENTITY_ANTI_VENGEANCE_BEAM, entity, world);
    }

    @Nonnull
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected float func_70185_h() {
        return 0.0f;
    }

    @Nullable
    protected EntityRayTraceResult rayTraceEntities(Vector3d startVec, Vector3d endVec) {
        return ProjectileHelper.func_221269_a((World)this.field_70170_p, (Entity)this, (Vector3d)startVec, (Vector3d)endVec, (AxisAlignedBB)this.func_174813_aQ().func_216361_a(this.func_213322_ci()).func_186662_g(1.0), entity -> !entity.func_175149_v() && entity.func_70089_S() && entity.func_70067_L() && entity != this.func_234616_v_());
    }

    public void func_70071_h_() {
        Vector3d motion = this.func_213322_ci();
        Vector3d vec3 = new Vector3d(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        Vector3d vec31 = new Vector3d(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_()).func_178787_e(motion);
        EntityRayTraceResult entityRayTraceResult = this.rayTraceEntities(vec3, vec31);
        vec3 = new Vector3d(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        vec31 = new Vector3d(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_()).func_178787_e(motion);
        ++this.soundTick;
        if (this.soundTick > 3 && this.func_145782_y() % 10 == 0) {
            this.soundTick = 0;
        }
        if (!this.field_70170_p.func_201670_d()) {
            Entity entity = null;
            List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_191194_a(motion).func_186662_g(1.0));
            double d0 = 0.0;
            for (Entity entity1 : list) {
                double d1;
                if (!(entity1 instanceof EntityVengeanceSpirit) || ((EntityVengeanceSpirit)entity1).isSwarm()) continue;
                float f = 0.3f;
                AxisAlignedBB axisalignedbb = entity1.func_174813_aQ().func_186662_g((double)f);
                EntityRayTraceResult movingobjectposition1 = ProjectileHelper.func_221269_a((World)this.field_70170_p, (Entity)this, (Vector3d)vec3, (Vector3d)vec31, (AxisAlignedBB)axisalignedbb, e -> true);
                if (movingobjectposition1 == null || !((d1 = vec3.func_72438_d(movingobjectposition1.func_216347_e())) < d0) && d0 != 0.0) continue;
                entity = entity1;
                d0 = d1;
            }
            if (entity != null) {
                entityRayTraceResult = new EntityRayTraceResult(entity);
            }
        } else {
            for (int i = 0; i < this.field_70170_p.field_73012_v.nextInt(5) + 5; ++i) {
                this.showNewBlurParticle();
            }
            if (this.soundTick == 1) {
                this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), EvilCraftSoundEvents.effect_vengeancebeam_base, SoundCategory.NEUTRAL, 0.5f + this.field_70170_p.field_73012_v.nextFloat() * 0.2f, 1.0f, false);
            }
        }
        if (entityRayTraceResult != null) {
            this.func_70227_a((RayTraceResult)entityRayTraceResult);
        }
        if (this.age++ > 200) {
            this.func_70106_y();
        }
        super.func_70071_h_();
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void showNewBlurParticle() {
        float scale = 0.6f - this.field_70146_Z.nextFloat() * 0.3f;
        float red = this.field_70146_Z.nextFloat() * 0.03f + 0.01f;
        float green = this.field_70146_Z.nextFloat() * 0.03f;
        float blue = this.field_70146_Z.nextFloat() * 0.05f + 0.05f;
        float ageMultiplier = (float)(this.field_70146_Z.nextDouble() * 6.5 + 4.0);
        Vector3d motion = this.func_213322_ci();
        Minecraft.func_71410_x().field_71438_f.func_195461_a((IParticleData)new ParticleBlurData(red, green, blue, scale, ageMultiplier), false, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.deriveMotion(motion.field_72450_a), this.deriveMotion(motion.field_72448_b), this.deriveMotion(motion.field_72449_c));
    }

    private double deriveMotion(double motion) {
        return motion * 0.5 + (0.02 - this.field_70146_Z.nextDouble() * 0.04);
    }

    protected void applyHitEffect(Entity entity) {
        if (entity instanceof EntityVengeanceSpirit) {
            Vector3d motion = this.func_213322_ci();
            ((EntityVengeanceSpirit)entity).onHit(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), motion.field_72450_a, motion.field_72448_b, motion.field_72449_c);
            if (this.func_234616_v_() instanceof ServerPlayerEntity) {
                ((EntityVengeanceSpirit)entity).addEntanglingPlayer((ServerPlayerEntity)this.func_234616_v_());
            }
        }
    }

    protected void func_70227_a(RayTraceResult position) {
        if (!this.field_70170_p.func_201670_d() && position.func_216346_c() == RayTraceResult.Type.ENTITY && this.func_234616_v_() != null && this.func_234616_v_() instanceof ServerPlayerEntity) {
            this.applyHitEffect(((EntityRayTraceResult)position).func_216348_a());
        }
        this.func_70106_y();
    }

    protected void func_70088_a() {
    }
}

