/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.entity.effect;

import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRendersAsItem;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.network.IPacket;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;
import org.cyclops.cyclopscore.helper.EntityHelpers;
import org.cyclops.cyclopscore.helper.WorldHelpers;
import org.cyclops.evilcraft.Advancements;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.entity.monster.EntityControlledZombie;

@OnlyIn(value=Dist.CLIENT, _interface=IRendersAsItem.class)
public class EntityNecromancersHead
extends ThrowableEntity
implements IRendersAsItem {
    private static final int DURATION = 200;
    private static final ItemStack RENDER_ITEM = new ItemStack((IItemProvider)Items.field_196182_dv);
    protected boolean observing = false;
    protected LivingEntity target = null;
    protected List<EntityControlledZombie> observables = Lists.newLinkedList();
    protected Class<? extends MobEntity> mobType = EntityControlledZombie.class;

    public EntityNecromancersHead(EntityType<? extends EntityNecromancersHead> type, World world) {
        super(type, world);
    }

    public EntityNecromancersHead(World world, LivingEntity entity) {
        super(RegistryEntries.ENTITY_NECROMANCER_HEAD, entity, world);
    }

    @Nonnull
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void setMobType(Class<? extends MobEntity> mobType) {
        this.mobType = mobType;
    }

    protected void spawnSwarm(LivingEntity necromancer, LivingEntity target) {
        World world = target.field_70170_p;
        int amount = world.field_73012_v.nextInt(2) + 3;
        for (int i = 0; i < amount; ++i) {
            EntityControlledZombie mob = new EntityControlledZombie(world);
            if (!mob.func_213358_a(target.func_200600_R())) continue;
            mob.func_82149_j((Entity)necromancer);
            mob.func_213315_a(MoverType.SELF, new Vector3d((double)(world.field_73012_v.nextInt(20) - 10), 0.0, (double)(world.field_73012_v.nextInt(20) - 10)));
            if (EntityHelpers.spawnEntity((World)world, (MobEntity)mob, (SpawnReason)SpawnReason.MOB_SUMMONED)) {
                this.observables.add(mob);
            }
            mob.func_70624_b(target);
            mob.setTtl(200);
        }
        this.target = target;
        this.setObserverMode();
        if (necromancer instanceof ServerPlayerEntity) {
            Advancements.NECROMANCE.test((ServerPlayerEntity)necromancer, (Entity)target);
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.observing && !this.field_70170_p.func_201670_d() && WorldHelpers.efficientTick((World)this.field_70170_p, (int)10, (int[])new int[0])) {
            if (!this.observables.isEmpty()) {
                Iterator<EntityControlledZombie> it = this.observables.iterator();
                while (it.hasNext()) {
                    EntityControlledZombie mob = it.next();
                    if (mob.func_70089_S() && this.target.func_70089_S()) continue;
                    if (mob.func_70089_S()) {
                        mob.func_70106_y();
                    }
                    it.remove();
                }
            }
            if (this.observables.isEmpty()) {
                this.observing = false;
                this.func_70106_y();
            }
        }
    }

    protected void func_70088_a() {
    }

    public void func_70106_y() {
        if (!this.observing) {
            super.func_70106_y();
        }
    }

    protected void setObserverMode() {
        this.observing = true;
        this.func_213293_j(0.0, 0.0, 0.0);
        this.func_82142_c(true);
    }

    protected void func_70227_a(RayTraceResult position) {
        if (position.func_216346_c() == RayTraceResult.Type.ENTITY && !this.observing && !this.func_130014_f_().func_201670_d()) {
            ((EntityRayTraceResult)position).func_216348_a().func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)this.func_234616_v_()), 0.0f);
            if (this.func_234616_v_() instanceof ServerPlayerEntity && this.func_234616_v_() != ((EntityRayTraceResult)position).func_216348_a() && ((EntityRayTraceResult)position).func_216348_a() instanceof LivingEntity) {
                this.spawnSwarm((LivingEntity)this.func_234616_v_(), (LivingEntity)((EntityRayTraceResult)position).func_216348_a());
            } else {
                this.func_70106_y();
            }
        }
    }

    public ItemStack func_184543_l() {
        return RENDER_ITEM;
    }
}

