/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.entity.item;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.network.play.server.SChunkDataPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.registry.MutableRegistry;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeContainer;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimerWrapper;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.server.ServerChunkProvider;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkHooks;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.CyclopsCore;
import org.cyclops.cyclopscore.client.particle.ParticleBlurData;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.evilcraft.EvilCraft;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.core.algorithm.OrganicSpread;
import org.cyclops.evilcraft.core.algorithm.Wrapper;
import org.cyclops.evilcraft.core.entity.item.EntityThrowable;
import org.cyclops.evilcraft.item.ItemBiomeExtract;
import org.cyclops.evilcraft.network.packet.ResetChunkColorsPacket;

public class EntityBiomeExtract
extends EntityThrowable {
    private static final DataParameter<ItemStack> ITEMSTACK_INDEX = EntityDataManager.func_187226_a(EntityBiomeExtract.class, (IDataSerializer)DataSerializers.field_187196_f);

    public EntityBiomeExtract(EntityType<? extends EntityThrowable> type, World world) {
        super(type, world);
    }

    public EntityBiomeExtract(World world) {
        this(RegistryEntries.ENTITY_BIOME_EXTRACT, world);
    }

    public EntityBiomeExtract(World world, LivingEntity entity) {
        this(world, entity, new ItemStack((IItemProvider)RegistryEntries.ITEM_BIOME_EXTRACT));
    }

    public EntityBiomeExtract(World world, LivingEntity entity, ItemStack stack) {
        super(RegistryEntries.ENTITY_BIOME_EXTRACT, world, entity);
        this.setItemStack(stack);
    }

    @Nonnull
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void func_70227_a(final RayTraceResult movingobjectposition) {
        if (!this.field_70170_p.func_201670_d() && movingobjectposition.func_216346_c() == RayTraceResult.Type.BLOCK) {
            ItemStack itemStack = this.func_184543_l();
            final Biome biome = ItemBiomeExtract.getBiome(itemStack);
            if (biome != null) {
                final HashSet updatedChunks = Sets.newHashSet();
                OrganicSpread spread = new OrganicSpread(this.field_70170_p, 2, 5, new OrganicSpread.IOrganicSpreadable(){

                    @Override
                    public boolean isDone(World world, BlockPos location) {
                        return world.func_226691_t_(location) == biome;
                    }

                    @Override
                    public void spreadTo(World world, BlockPos location) {
                        EntityBiomeExtract.setBiome((ServerWorld)world, location, biome);
                        updatedChunks.add(new ChunkPos(location));
                        int color = biome.field_235052_p_.func_242528_e().orElseGet(() -> {
                            double d0 = MathHelper.func_76131_a((float)biome2.field_242423_j.field_242461_c, (float)0.0f, (float)1.0f);
                            double d1 = MathHelper.func_76131_a((float)biome2.field_242423_j.field_242463_e, (float)0.0f, (float)1.0f);
                            return Helpers.RGBToInt((int)20, (int)200, (int)20);
                        });
                        EntityBiomeExtract.this.showChangedBiome((ServerWorld)world, new BlockPos(location.func_177958_n(), ((BlockRayTraceResult)movingobjectposition).func_216350_a().func_177956_o(), location.func_177952_p()), color);
                    }
                });
                BlockPos pos = new BlockPos(movingobjectposition.func_216347_e());
                for (int i = 0; i < 50; ++i) {
                    spread.spreadTick(pos);
                }
                if (!this.field_70170_p.func_201670_d()) {
                    for (ChunkPos chunkPos : updatedChunks) {
                        EntityBiomeExtract.updateChunkAfterBiomeChange(this.field_70170_p, chunkPos);
                    }
                }
            }
            this.field_70170_p.func_175669_a(2002, this.func_233580_cy_(), 16428);
            this.func_70106_y();
        }
    }

    public static void setBiome(ServerWorld world, BlockPos posIn, Biome biome) {
        final Wrapper posWrapper = new Wrapper();
        world.func_230315_m_().func_227176_e_().func_225532_a_(world.func_72905_C(), posIn.func_177958_n(), posIn.func_177956_o(), posIn.func_177952_p(), new BiomeManager.IBiomeReader(){

            public Biome func_225526_b_(int x, int y, int z) {
                posWrapper.set(new BlockPos(x, y, z));
                return null;
            }
        });
        BlockPos noisePos = (BlockPos)posWrapper.get();
        IChunk chunk = world.func_217353_a(noisePos.func_177958_n() >> 2, noisePos.func_177952_p() >> 2, ChunkStatus.field_222608_d, false);
        if (chunk instanceof ChunkPrimerWrapper) {
            // empty if block
        }
        if (chunk != null) {
            Biome biomeHack;
            Biome[] biomeArray = chunk.func_225549_i_().field_227054_f_;
            int i = noisePos.func_177958_n() & BiomeContainer.field_227050_b_;
            int j = MathHelper.func_76125_a((int)noisePos.func_177956_o(), (int)0, (int)BiomeContainer.field_227051_c_);
            int k = noisePos.func_177952_p() & BiomeContainer.field_227050_b_;
            MutableRegistry biomeRegistry = world.func_241828_r().func_243612_b(Registry.field_239720_u_);
            biomeArray[j << BiomeContainer.field_227052_d_ + BiomeContainer.field_227052_d_ | k << BiomeContainer.field_227052_d_ | i] = biomeHack = (Biome)biomeRegistry.func_230516_a_(RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)biome.getRegistryName()));
            chunk.func_177427_f(true);
        } else {
            CyclopsCore.clog((Level)Level.WARN, (String)("Tried changing biome at non-existing chunk for position " + noisePos));
        }
    }

    public static void updateChunkAfterBiomeChange(World world, ChunkPos chunkPos) {
        Chunk chunkSafe = world.func_72863_F().func_217205_a(chunkPos.field_77276_a, chunkPos.field_77275_b, false);
        ((ServerChunkProvider)world.func_72863_F()).field_217237_a.func_219097_a(chunkPos, false).forEach(player -> {
            player.field_71135_a.func_147359_a((IPacket)new SChunkDataPacket(chunkSafe, 65535));
            EvilCraft._instance.getPacketHandler().sendToPlayer((PacketBase)new ResetChunkColorsPacket(chunkPos.field_77276_a, chunkPos.field_77275_b), player);
        });
    }

    private void showChangedBiome(ServerWorld world, BlockPos pos, int color) {
        Triple c = Helpers.intToRGB((int)color);
        Random rand = world.field_73012_v;
        for (int j = 0; j < 2 + rand.nextInt(5); ++j) {
            float x = (float)pos.func_177958_n() + -0.5f + rand.nextFloat();
            float y = (float)pos.func_177956_o() + -0.5f + rand.nextFloat();
            float z = (float)pos.func_177952_p() + -0.5f + rand.nextFloat();
            float scale = 0.2f - rand.nextFloat() * 0.2f;
            float red = ((Float)c.getLeft()).floatValue() + rand.nextFloat() * 0.1f;
            float green = ((Float)c.getMiddle()).floatValue() + rand.nextFloat() * 0.1f;
            float blue = ((Float)c.getRight()).floatValue() + rand.nextFloat() * 0.1f;
            float ageMultiplier = 10 + rand.nextInt(15);
            double motionX = -0.1f + rand.nextFloat() * 0.2f;
            double motionY = 0.1f + rand.nextFloat() * 0.2f;
            double motionZ = -0.1f + rand.nextFloat() * 0.2f;
            world.func_195598_a((IParticleData)new ParticleBlurData(red, green, blue, scale, ageMultiplier), (double)x, (double)y, (double)z, 1, motionX, motionY, motionZ, 0.1);
        }
    }

    protected float func_70185_h() {
        return 0.1f;
    }

    public ItemStack func_184543_l() {
        return (ItemStack)this.field_70180_af.func_187225_a(ITEMSTACK_INDEX);
    }

    private void setItemStack(ItemStack stack) {
        this.field_70180_af.func_187227_b(ITEMSTACK_INDEX, (Object)stack);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(ITEMSTACK_INDEX, (Object)new ItemStack((IItemProvider)RegistryEntries.ITEM_BIOME_EXTRACT));
    }
}

