/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.entity.item;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.api.broom.BroomModifier;
import org.cyclops.evilcraft.api.broom.BroomModifiers;
import org.cyclops.evilcraft.api.broom.IBroom;
import org.cyclops.evilcraft.client.particle.ParticleColoredSmokeData;
import org.cyclops.evilcraft.core.broom.BroomParts;
import org.cyclops.evilcraft.core.helper.MathHelpers;
import org.cyclops.evilcraft.item.ItemBroomConfig;

public class EntityBroom
extends Entity {
    private static final DataParameter<ItemStack> ITEMSTACK_INDEX = EntityDataManager.func_187226_a(EntityBroom.class, (IDataSerializer)DataSerializers.field_187196_f);
    public static final double SPEED = 0.4;
    public static final float MAX_ANGLE = 60.0f;
    public static final float MIN_ANGLE = -60.0f;
    private static final float MAX_COS_AMPLITUDE = 0.2f;
    public LivingEntity lastMounted = null;
    private boolean setLast = false;
    private double lastPlayerSpeed = 0.0;
    private float lastRotationPitch = -1.0f;
    private float lastRotationYaw = -1.0f;
    private double newPosX;
    private double newPosY;
    private double newPosZ;
    private double newRotationYaw;
    private double newRotationPitch;
    private int newPosRotationIncrements;
    private int broomHoverTickOffset;
    @OnlyIn(value=Dist.CLIENT)
    private double oldHoverOffset;
    private Map<BroomModifier, Float> cachedModifiers = null;

    public EntityBroom(EntityType<? extends EntityBroom> type, World world) {
        this(type, world, 0.0, 0.0, 0.0);
        this.initBroomHoverTickOffset();
    }

    public EntityBroom(EntityType<? extends EntityBroom> type, World world, double x, double y, double z) {
        super(type, world);
        this.func_70107_b(x, y, z);
        this.func_213293_j(0.0, 0.0, 0.0);
        this.func_213323_x_();
        this.field_70169_q = x;
        this.field_70167_r = y;
        this.field_70166_s = z;
        this.initBroomHoverTickOffset();
    }

    public EntityBroom(World world, double x, double y, double z) {
        this(RegistryEntries.ENTITY_BROOM, world, x, y, z);
    }

    @Nonnull
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return EntitySize.func_220314_b((float)1.5f, (float)0.6f);
    }

    protected void initBroomHoverTickOffset() {
        this.broomHoverTickOffset = this.field_70146_Z.nextInt(3);
    }

    public double func_70042_X() {
        return 0.0;
    }

    protected boolean func_225502_at_() {
        return false;
    }

    public boolean func_70067_L() {
        return this.func_70089_S();
    }

    public ActionResultType func_184230_a(PlayerEntity player, Hand hand) {
        if (!(this.field_70170_p.func_201670_d() || this.func_184207_aI() || player.func_213453_ef())) {
            player.func_184220_m((Entity)this);
            this.lastMounted = player;
        }
        return ActionResultType.SUCCESS;
    }

    public void func_70108_f(Entity entityIn) {
        Entity controlling;
        if (!(this.field_70170_p.func_201670_d() || entityIn.field_70145_X || this.field_70145_X || entityIn == (controlling = this.func_184179_bs()) || !(entityIn instanceof LivingEntity) || entityIn instanceof PlayerEntity || controlling != null || entityIn.func_184218_aH())) {
            entityIn.func_184220_m((Entity)this);
        }
    }

    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean isTeleport) {
        posRotationIncrements += 6;
        this.newPosX = x;
        this.newPosY = y;
        this.newPosZ = z;
        this.newRotationYaw = yaw;
        this.newRotationPitch = pitch;
        this.newPosRotationIncrements = posRotationIncrements;
    }

    public Entity func_184179_bs() {
        List list = this.func_184188_bt();
        return list.isEmpty() ? null : (Entity)list.get(0);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (!this.field_70170_p.func_201670_d() && this.func_70089_S()) {
            if (this.func_180431_b(source)) {
                return false;
            }
            if (source.func_76346_g() instanceof PlayerEntity && source.func_76346_g() != this.lastMounted) {
                if (this.func_184207_aI()) {
                    this.func_184210_p();
                }
                this.func_70106_y();
                PlayerEntity player = (PlayerEntity)source.func_76346_g();
                if (!player.func_184812_l_()) {
                    ItemStack itemStack = this.getBroomStack().func_77946_l();
                    this.func_70099_a(itemStack, 0.0f);
                }
            }
        }
        return true;
    }

    public void startAllowFlying(LivingEntity entity) {
        if (entity instanceof PlayerEntity) {
            ((PlayerEntity)entity).field_71075_bZ.field_75101_c = true;
        }
    }

    public void stopAllowFlying(LivingEntity entity) {
        if (entity instanceof PlayerEntity) {
            ((PlayerEntity)entity).field_71075_bZ.field_75101_c = false;
        }
    }

    protected void func_184200_o(Entity passenger) {
        super.func_184200_o(passenger);
        if (!this.field_70170_p.func_201670_d() && passenger instanceof LivingEntity) {
            this.startAllowFlying((LivingEntity)passenger);
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        Entity rider = this.func_184179_bs();
        if (!this.field_70170_p.func_201670_d() && !this.func_184207_aI() && this.lastMounted != null) {
            this.onDismount();
        } else if (rider instanceof LivingEntity) {
            List list;
            this.lastMounted = (LivingEntity)rider;
            this.field_70169_q = this.func_226277_ct_();
            this.field_70167_r = this.func_226278_cu_();
            this.field_70166_s = this.func_226281_cx_();
            this.field_70127_C = this.field_70125_A;
            this.field_70126_B = this.field_70177_z;
            if (!this.field_70170_p.func_201670_d() || Minecraft.func_71410_x().field_71439_g == this.lastMounted) {
                this.updateMountedServer();
            } else {
                this.updateMountedClient();
            }
            if (MinecraftHelpers.isClientSide() && this.getModifier(BroomModifiers.PARTICLES) > 0.0f) {
                this.showParticles(this);
            }
            if ((list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b(0.2, 0.0, 0.2))) != null && !list.isEmpty()) {
                for (int l = 0; l < list.size(); ++l) {
                    Entity entity = (Entity)list.get(l);
                    if (entity == rider || !entity.func_70104_M() || entity instanceof EntityBroom) continue;
                    for (Map.Entry<BroomModifier, Float> entry : this.getModifiers().entrySet()) {
                        for (BroomModifier.ICollisionListener listener : entry.getKey().getCollisionListeners()) {
                            listener.onCollide(this, entity, entry.getValue().floatValue());
                        }
                    }
                    entity.func_70108_f((Entity)this);
                    float toughnessModifier = 0.5f + this.getModifier(BroomModifiers.STURDYNESS) / BroomModifiers.STURDYNESS.getMaxTierValue() / 2.0f;
                    this.setLastPlayerSpeed(this.getLastPlayerSpeed() * (double)toughnessModifier);
                }
            }
            for (Map.Entry<BroomModifier, Float> entry : this.getModifiers().entrySet()) {
                for (BroomModifier.ITickListener listener : entry.getKey().getTickListeners()) {
                    listener.onTick(this, entry.getValue().floatValue());
                }
            }
        } else {
            if (!this.field_70170_p.func_201670_d() && rider == null) {
                this.collideWithNearbyEntities();
            }
            this.updateUnmounted();
        }
    }

    private void onDismount() {
        if (this.lastMounted instanceof PlayerEntity) {
            this.stopAllowFlying(this.lastMounted);
            PlayerEntity player = (PlayerEntity)this.lastMounted;
            if (player.func_70089_S() && (!MinecraftHelpers.isPlayerInventoryFull((PlayerEntity)player) || player.func_184812_l_())) {
                if (!player.func_184812_l_()) {
                    player.field_71071_by.func_70441_a(this.getBroomStack());
                }
                this.func_70106_y();
            }
        }
        this.lastMounted = null;
    }

    protected boolean func_184219_q(Entity passenger) {
        return (float)this.func_184188_bt().size() < 1.0f + this.getModifier(BroomModifiers.STICKY) / BroomModifiers.STICKY.getMaxTierValue() * 3.0f;
    }

    protected void func_184225_p(Entity passenger) {
        if (!this.func_130014_f_().func_201670_d() && this.func_184179_bs() == passenger) {
            this.onDismount();
        }
        super.func_184225_p(passenger);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void showParticles(EntityBroom broom) {
        World world = broom.field_70170_p;
        if (world.func_201670_d() && broom.lastMounted.field_191988_bg != 0.0f) {
            int particles = (int)(broom.getModifier(BroomModifiers.PARTICLES) * (float)broom.getLastPlayerSpeed());
            Triple<Float, Float, Float> color = BroomModifier.getAverageColor(broom.getModifiers());
            for (int i = 0; i < particles; ++i) {
                float r = ((Float)color.getLeft()).floatValue();
                float g = ((Float)color.getMiddle()).floatValue();
                float b = ((Float)color.getRight()).floatValue();
                Vector3d motion = broom.func_213322_ci();
                Minecraft.func_71410_x().field_71438_f.func_195461_a((IParticleData)new ParticleColoredSmokeData(r, g, b), false, broom.func_226277_ct_() - motion.field_72450_a * 1.5 + Math.random() * 0.4 - 0.2, broom.func_226278_cu_() - motion.field_72448_b * 1.5 + Math.random() * 0.4 - 0.2, broom.func_226281_cx_() - motion.field_72449_c * 1.5 + Math.random() * 0.4 - 0.2, motion.field_72450_a / 10.0, motion.field_72448_b / 10.0, motion.field_72449_c / 10.0);
            }
        }
    }

    protected void collideWithNearbyEntities() {
        List list = this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ().func_72314_b((double)0.2f, 0.0, (double)0.2f), EntityPredicates.field_180132_d.and(Entity::func_70104_M));
        if (!list.isEmpty()) {
            for (Entity entity : list) {
                this.func_70108_f(entity);
            }
        }
    }

    protected void updateMountedClient() {
        if (this.newPosRotationIncrements > 0) {
            double x = this.func_226277_ct_() + (this.newPosX - this.func_226277_ct_()) / (double)this.newPosRotationIncrements;
            double y = this.func_226278_cu_() + (this.newPosY - this.func_226278_cu_()) / (double)this.newPosRotationIncrements;
            double z = this.func_226281_cx_() + (this.newPosZ - this.func_226281_cx_()) / (double)this.newPosRotationIncrements;
            float yaw = MathHelpers.normalizeAngle_180((float)(this.newRotationYaw - (double)this.field_70177_z));
            this.field_70177_z += yaw / (float)this.newPosRotationIncrements;
            this.field_70125_A = (float)((double)this.field_70125_A + (this.newRotationPitch - (double)this.field_70125_A) / (double)this.newPosRotationIncrements);
            --this.newPosRotationIncrements;
            this.func_70107_b(x, y, z);
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
        }
        this.func_213315_a(MoverType.SELF, new Vector3d(0.0, this.getHoverOffset(), 0.0));
    }

    public boolean canConsume(int amount, LivingEntity entityLiving) {
        ItemStack broomStack = this.getBroomStack();
        return broomStack != null && broomStack.func_77973_b() instanceof IBroom && ((IBroom)broomStack.func_77973_b()).canConsumeBroomEnergy(amount, broomStack, entityLiving);
    }

    public void consume(int amount, LivingEntity entityLiving) {
        float efficiencyFactor = Math.min(0.9f, Math.max(0.0f, this.getModifier(BroomModifiers.EFFICIENCY) / BroomModifiers.EFFICIENCY.getMaxTierValue()));
        if (this.field_70170_p.field_73012_v.nextFloat() > efficiencyFactor) {
            ItemStack broomStack = this.getBroomStack();
            ((IBroom)broomStack.func_77973_b()).consumeBroom(amount, broomStack, entityLiving);
            this.setBroomStack(broomStack);
        }
    }

    protected void updateMountedServer() {
        if (!this.setLast) {
            this.setLast = true;
            this.lastRotationYaw = this.field_70177_z;
            this.lastRotationPitch = this.field_70125_A;
        }
        if (this.lastMounted instanceof PlayerEntity) {
            if (this.lastMounted instanceof ServerPlayerEntity) {
                ((ServerPlayerEntity)this.lastMounted).field_71135_a.field_184346_E = 0;
            }
        } else {
            this.lastMounted.field_70177_z = this.lastMounted.field_70759_as;
            this.lastMounted.field_191988_bg = 0.5f;
        }
        this.field_70125_A = MathHelpers.normalizeAngle_180(this.lastMounted.field_70125_A);
        this.field_70177_z = MathHelpers.normalizeAngle_180(this.lastMounted.field_70177_z);
        float maneuverabilityFactor = 1.0f - this.getModifier(BroomModifiers.MANEUVERABILITY) / 2000.0f;
        this.field_70125_A = this.field_70125_A * (1.0f - maneuverabilityFactor) + this.lastRotationPitch * maneuverabilityFactor;
        if (this.lastRotationYaw - this.field_70177_z > 180.0f) {
            this.lastRotationYaw -= 360.0f;
        }
        if (this.lastRotationYaw - this.field_70177_z < -180.0f) {
            this.lastRotationYaw += 360.0f;
        }
        this.field_70177_z = this.field_70177_z * (1.0f - maneuverabilityFactor) + this.lastRotationYaw * maneuverabilityFactor;
        this.lastRotationPitch = this.field_70125_A;
        this.lastRotationYaw = this.field_70177_z;
        if (this.field_70125_A > 60.0f) {
            this.field_70125_A = 60.0f;
        } else if (this.field_70125_A < -60.0f) {
            this.field_70125_A = -60.0f;
        }
        this.func_70101_b(this.field_70177_z, this.field_70125_A);
        double pitch = (double)(this.field_70125_A + 90.0f) * Math.PI / 180.0;
        double yaw = (double)(this.field_70177_z + 90.0f) * Math.PI / 180.0;
        double x = Math.sin(pitch) * Math.cos(yaw);
        double z = Math.sin(pitch) * Math.sin(yaw);
        double y = Math.cos(pitch);
        double playerSpeed = this.lastMounted.func_110148_a(Attributes.field_233821_d_).func_111126_e();
        playerSpeed += (double)(this.getModifier(BroomModifiers.SPEED) / 100.0f);
        int amount = ItemBroomConfig.bloodUsage;
        LivingEntity currentRidingEntity = this.func_184179_bs() instanceof LivingEntity ? (LivingEntity)this.func_184179_bs() : null;
        float moveForward = this.canConsume(amount, currentRidingEntity) ? this.lastMounted.field_191988_bg : this.lastMounted.field_191988_bg / 10.0f;
        playerSpeed *= (double)moveForward;
        if (moveForward != 0.0f) {
            this.consume(amount, currentRidingEntity);
        }
        float slowingFactor = 1.0f - (this.getModifier(BroomModifiers.ACCELERATION) + 1.0f) / 2500.0f;
        playerSpeed = playerSpeed * (1.0 - (double)slowingFactor) + this.lastPlayerSpeed * (double)slowingFactor;
        float levitation = this.getModifier(BroomModifiers.LEVITATION);
        float levitationModifier = levitation / BroomModifiers.LEVITATION.getMaxTierValue() * 1.5f;
        levitationModifier = Math.max(0.2f, levitationModifier);
        if (y < 0.0) {
            levitationModifier = Math.max(1.0f, levitationModifier);
        }
        this.lastPlayerSpeed = playerSpeed;
        if (this.field_70171_ac) {
            float waterMovementFactor = MathHelper.func_76131_a((float)(this.getModifier(BroomModifiers.SWIMMING) / BroomModifiers.SWIMMING.getMaxTierValue()), (float)0.0f, (float)1.0f);
            waterMovementFactor = (float)Math.log10(1.0f + waterMovementFactor * 9.0f);
            playerSpeed *= (double)waterMovementFactor;
        }
        this.func_213317_d(this.func_213322_ci().func_216372_d(0.1, 0.1, 0.1).func_72441_c(x * 0.4 * playerSpeed, y * 0.4 * playerSpeed * (double)levitationModifier, z * 0.4 * playerSpeed));
        if (this.field_70170_p.func_201670_d()) {
            this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, this.getHoverOffset(), 0.0));
        }
        this.func_213315_a(MoverType.SELF, this.func_213322_ci());
    }

    public double getLastPlayerSpeed() {
        return this.lastPlayerSpeed;
    }

    public void setLastPlayerSpeed(double lastPlayerSpeed) {
        this.lastPlayerSpeed = lastPlayerSpeed;
    }

    protected void updateUnmounted() {
        if (this.field_70170_p.func_201670_d()) {
            this.func_213315_a(MoverType.SELF, new Vector3d(0.0, this.getHoverOffset(), 0.0));
        }
    }

    protected double getHoverOffset() {
        float x = this.field_70170_p.func_82737_E();
        float t = this.broomHoverTickOffset;
        double newHoverOffset = Math.cos(x / 10.0f + t) * Math.cos(x / 12.0f + t) * Math.cos(x / 15.0f + t) * (double)0.2f;
        double newHoverDifference = newHoverOffset - this.oldHoverOffset;
        this.oldHoverOffset += newHoverDifference;
        return newHoverDifference;
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    public boolean canBeRiddenInWater(Entity rider) {
        return this.getModifier(BroomModifiers.SWIMMING) > 0.0f;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(ITEMSTACK_INDEX, (Object)new ItemStack((IItemProvider)RegistryEntries.ITEM_BROOM));
    }

    protected void func_70037_a(CompoundNBT nbttagcompound) {
    }

    protected void func_213281_b(CompoundNBT nbttagcompound) {
    }

    public void setBroomStack(ItemStack itemStack) {
        this.field_70180_af.func_187227_b(ITEMSTACK_INDEX, (Object)itemStack.func_77946_l());
    }

    public ItemStack getBroomStack() {
        ItemStack itemStack = (ItemStack)this.field_70180_af.func_187225_a(ITEMSTACK_INDEX);
        if (itemStack.func_190926_b()) {
            itemStack = new ItemStack((IItemProvider)RegistryEntries.ITEM_BROOM);
        }
        itemStack.func_190920_e(1);
        return itemStack;
    }

    public Map<BroomModifier, Float> getModifiers() {
        if (this.cachedModifiers == null) {
            this.cachedModifiers = Maps.newHashMap();
            ItemStack broomStack = this.getBroomStack();
            Map<BroomModifier, Float> modifiers = BroomModifiers.REGISTRY.getModifiers(broomStack);
            Map<BroomModifier, Float> baseModifiers = BroomParts.REGISTRY.getBaseModifiersFromBroom(broomStack);
            HashSet modifierTypes = Sets.newHashSet();
            modifierTypes.addAll(modifiers.keySet());
            modifierTypes.addAll(baseModifiers.keySet());
            for (BroomModifier modifier : modifierTypes) {
                float value = modifier.getDefaultValue();
                if (baseModifiers.containsKey(modifier)) {
                    value = baseModifiers.get(modifier).floatValue();
                }
                if (modifiers.containsKey(modifier)) {
                    value = modifier.apply(value, Lists.newArrayList((Object[])new Float[]{modifiers.get(modifier)}));
                }
                this.cachedModifiers.put(modifier, Float.valueOf(value));
            }
        }
        return this.cachedModifiers;
    }

    public float getModifier(BroomModifier modifier) {
        Float value = this.getModifiers().get(modifier);
        if (value == null) {
            return modifier.getDefaultValue();
        }
        return value.floatValue();
    }

    public CompoundNBT func_189511_e(CompoundNBT tag) {
        tag = super.func_189511_e(tag);
        CompoundNBT broomItemTag = new CompoundNBT();
        this.getBroomStack().func_77955_b(broomItemTag);
        tag.func_218657_a("broomItem", (INBT)broomItemTag);
        return tag;
    }

    public void func_70020_e(CompoundNBT tagCompound) {
        super.func_70020_e(tagCompound);
        ItemStack broomStack = ItemStack.func_199557_a((CompoundNBT)tagCompound.func_74775_l("broomItem"));
        if (!broomStack.func_190926_b()) {
            this.setBroomStack(broomStack);
        }
    }
}

