/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.entity.item;

import javax.annotation.Nullable;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.entity.item.EntityItemDefinedRotation;

public class EntityItemDarkStick
extends EntityItemDefinedRotation {
    private static final DataParameter<Integer> WATCHERID_VALID = EntityDataManager.func_187226_a(EntityItemDarkStick.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> WATCHERID_ANGLE = EntityDataManager.func_187226_a(EntityItemDarkStick.class, (IDataSerializer)DataSerializers.field_187193_c);
    private double lastPosX = -1.0;
    private double lastPosY = -1.0;
    private double lastPosZ = -1.0;

    public EntityItemDarkStick(EntityType<? extends EntityItemDarkStick> type, World world) {
        super((EntityType<? extends EntityItemDefinedRotation>)type, world);
    }

    public EntityItemDarkStick(World world, ItemEntity original) {
        super((EntityType<? extends EntityItemDefinedRotation>)RegistryEntries.ENTITY_ITEM_DARK_STICK, world, original);
    }

    public void func_70088_a() {
        super.func_70088_a();
        Float angle = MinecraftHelpers.isClientSide() ? null : this.loadRotation();
        this.field_70180_af.func_187214_a(WATCHERID_VALID, (Object)(angle != null ? 1 : 0));
        this.field_70180_af.func_187214_a(WATCHERID_ANGLE, (Object)Float.valueOf(angle == null ? 0.0f : angle.floatValue()));
    }

    protected boolean hasMoved() {
        boolean moved = Math.abs(this.lastPosX - this.func_226277_ct_()) > (double)0.1f || Math.abs(this.lastPosZ - this.func_226281_cx_()) > (double)0.1f;
        this.lastPosX = this.func_226277_ct_();
        this.lastPosY = this.func_226278_cu_();
        this.lastPosZ = this.func_226281_cx_();
        return moved;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.func_130014_f_().func_201670_d() && this.hasMoved()) {
            Float angle = this.loadRotation();
            this.setValid(angle != null);
            this.setAngle(angle == null ? 0.0f : angle.floatValue());
        }
    }

    @Nullable
    private Float loadRotation() {
        BlockPos closest = ((ServerWorld)this.field_70170_p).func_72863_F().func_201711_g().func_235956_a_((ServerWorld)this.field_70170_p, RegistryEntries.STRUCTURE_DARK_TEMPLE, new BlockPos(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_()), 100, false);
        if (closest != null) {
            double d = (closest = new BlockPos(closest.func_177958_n(), 0, closest.func_177952_p())).func_177951_i((Vector3i)new BlockPos((int)this.func_226277_ct_(), 0, (int)this.func_226281_cx_()));
            if (d <= 256.0) {
                return null;
            }
            BlockPos normalized = new BlockPos(closest.func_177958_n() - (int)this.func_226277_ct_(), 0, closest.func_177952_p() - (int)this.func_226281_cx_());
            return Float.valueOf((float)(Math.atan2(normalized.func_177958_n(), normalized.func_177952_p()) * 180.0 / Math.PI));
        }
        return null;
    }

    @Override
    protected boolean hasCustomRotation() {
        return this.isValid();
    }

    public float getAngle() {
        return ((Float)this.field_70180_af.func_187225_a(WATCHERID_ANGLE)).floatValue();
    }

    protected void setAngle(float angle) {
        this.field_70180_af.func_187227_b(WATCHERID_ANGLE, (Object)Float.valueOf(angle));
    }

    public boolean isValid() {
        return (Integer)this.field_70180_af.func_187225_a(WATCHERID_VALID) == 1;
    }

    protected void setValid(boolean valid) {
        this.field_70180_af.func_187227_b(WATCHERID_VALID, (Object)(valid ? 1 : 0));
    }
}

