/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.entity.item;

import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkHooks;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.core.entity.item.EntityThrowable;
import org.cyclops.evilcraft.item.ItemWeatherContainer;

public class EntityWeatherContainer
extends EntityThrowable {
    private static final DataParameter<ItemStack> ITEMSTACK_INDEX = EntityDataManager.func_187226_a(EntityWeatherContainer.class, (IDataSerializer)DataSerializers.field_187196_f);

    public EntityWeatherContainer(EntityType<? extends EntityWeatherContainer> type, World world) {
        super(type, world);
    }

    public EntityWeatherContainer(World world, LivingEntity entity) {
        super(RegistryEntries.ENTITY_WEATHER_CONTAINER, world, entity);
    }

    public EntityWeatherContainer(World world, LivingEntity entity, ItemStack stack) {
        this(world, entity);
        this.setItem(stack);
    }

    @Nonnull
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public static void playImpactSounds(World world) {
        if (!world.func_201670_d()) {
            for (Object o : world.func_217369_A()) {
                PlayerEntity entityPlayer = (PlayerEntity)o;
                world.func_184148_a(entityPlayer, entityPlayer.func_226277_ct_(), entityPlayer.func_226278_cu_(), entityPlayer.func_226281_cx_(), SoundEvents.field_187812_eh, SoundCategory.WEATHER, 0.5f, 0.4f / (world.field_73012_v.nextFloat() * 0.4f + 0.8f));
                world.func_184148_a(entityPlayer, entityPlayer.func_226277_ct_(), entityPlayer.func_226278_cu_(), entityPlayer.func_226281_cx_(), SoundEvents.field_187551_bH, SoundCategory.WEATHER, 0.5f, 0.4f / (world.field_73012_v.nextFloat() * 0.4f + 0.8f));
                world.func_184148_a(entityPlayer, entityPlayer.func_226277_ct_(), entityPlayer.func_226278_cu_(), entityPlayer.func_226281_cx_(), SoundEvents.field_187849_gA, SoundCategory.WEATHER, 0.5f, 0.4f / (world.field_73012_v.nextFloat() * 0.4f + 0.8f));
            }
        }
    }

    protected void func_70227_a(RayTraceResult movingobjectposition) {
        if (movingobjectposition.func_216346_c() == RayTraceResult.Type.BLOCK) {
            ItemStack stack = this.func_184543_l();
            ItemWeatherContainer.WeatherContainerType containerType = ItemWeatherContainer.getWeatherType(stack);
            if (this.field_70170_p instanceof ServerWorld) {
                containerType.onUse((ServerWorld)this.field_70170_p, stack);
            }
            EntityWeatherContainer.playImpactSounds(this.field_70170_p);
            this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187825_fO, SoundCategory.AMBIENT, 0.5f, 0.4f, false);
            for (int i = 0; i < 3; ++i) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197620_m, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 0.0, 0.0, 0.0);
            }
            this.func_70106_y();
        }
    }

    protected float func_70185_h() {
        return 0.1f;
    }

    private void setItem(ItemStack stack) {
        this.field_70180_af.func_187227_b(ITEMSTACK_INDEX, (Object)stack);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(ITEMSTACK_INDEX, (Object)new ItemStack((IItemProvider)RegistryEntries.ITEM_WEATHER_CONTAINER));
    }

    public ItemStack func_184543_l() {
        return (ItemStack)this.field_70180_af.func_187225_a(ITEMSTACK_INDEX);
    }
}

