/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.entity.monster;

import java.util.List;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.FlyingEntity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Difficulty;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.entity.monster.EntityPoisonousLibelleConfig;

public class EntityPoisonousLibelle
extends FlyingEntity
implements IMob {
    private static final int POISON_DURATION = 2;
    public double targetX;
    public double targetY;
    public double targetZ;
    public float prevAnimTime;
    public float animTime;
    public boolean forceNewTarget;
    private Entity target;
    private static int WINGLENGTH;
    private int wingProgress = 0;
    private boolean wingGoUp = true;
    private static final int MAXHEIGHT = 80;
    private float randomYawVelocity;

    public EntityPoisonousLibelle(EntityType<? extends EntityPoisonousLibelle> typeIn, World worldIn) {
        super(typeIn, worldIn);
        this.field_70728_aV = 10;
    }

    public EntityPoisonousLibelle(World world) {
        this(RegistryEntries.ENTITY_POISONOUS_LIBELLE, world);
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void checkLibelleSpawn(LivingSpawnEvent.CheckSpawn event) {
        if (event.getEntityLiving() instanceof EntityPoisonousLibelle && ((EntityPoisonousLibelle)event.getEntityLiving()).func_226278_cu_() < (double)EntityPoisonousLibelleConfig.minY) {
            event.setResult(Event.Result.DENY);
        }
    }

    public SoundEvent func_184639_G() {
        return null;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return SoundEvents.field_187743_y;
    }

    public SoundEvent func_184615_bR() {
        return SoundEvents.field_187742_x;
    }

    protected float func_70599_aP() {
        return 0.2f;
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223224_c_;
    }

    public boolean func_70104_M() {
        return false;
    }

    public void func_70636_d() {
        float f;
        super.func_70636_d();
        if (this.field_70170_p.func_201670_d()) {
            f = MathHelper.func_76134_b((float)(this.animTime * (float)Math.PI * 2.0f));
            float f1 = MathHelper.func_76134_b((float)(this.prevAnimTime * (float)Math.PI * 2.0f));
            if (f1 <= -0.3f && f >= -0.3f && this.field_70146_Z.nextInt(45) == 0) {
                this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187740_w, SoundCategory.AMBIENT, 0.1f, 0.8f + this.field_70146_Z.nextFloat() * 0.3f);
            }
        }
        this.prevAnimTime = this.animTime;
        Vector3d m = this.func_213322_ci();
        f = 0.2f / (MathHelper.func_76133_a((double)(m.field_72450_a * m.field_72450_a + m.field_72449_c * m.field_72449_c)) * 10.0f + 1.0f);
        this.animTime += (f *= (float)Math.pow(2.0, m.field_72448_b));
        if (this.field_70170_p.func_201670_d()) {
            if (this.field_70716_bi > 0) {
                double distanceX = this.func_226277_ct_() + (this.field_184623_bh - this.func_226277_ct_()) / (double)this.field_70716_bi;
                double distanceY = this.func_226278_cu_() + (this.field_184624_bi - this.func_226278_cu_()) / (double)this.field_70716_bi;
                double distanceZ = this.func_226281_cx_() + (this.field_184625_bj - this.func_226281_cx_()) / (double)this.field_70716_bi;
                double distance = MathHelper.func_76138_g((double)(this.field_184626_bk - (double)this.field_70177_z));
                this.field_70177_z = (float)((double)this.field_70177_z + distance / (double)this.field_70716_bi);
                this.field_70125_A = (float)((double)this.field_70125_A + (this.targetX - (double)this.field_70125_A) / (double)this.field_70716_bi);
                --this.field_70716_bi;
                this.func_70107_b(distanceX, distanceY, distanceZ);
                this.func_70101_b(this.field_70177_z, this.field_70125_A);
            }
        } else {
            float limitDistanceY;
            double distanceX = this.targetX - this.func_226277_ct_();
            double distanceY = this.targetY - this.func_226278_cu_();
            double distanceZ = this.targetZ - this.func_226281_cx_();
            double distance = distanceX * distanceX + distanceY * distanceY + distanceZ * distanceZ;
            if (this.target != null) {
                double distancedZ;
                this.targetX = this.target.func_226277_ct_();
                this.targetZ = this.target.func_226281_cx_();
                double distancedX = this.targetX - this.func_226277_ct_();
                double distancedHeightPlane = Math.sqrt(distancedX * distancedX + (distancedZ = this.targetZ - this.func_226281_cx_()) * distancedZ);
                double Yplus = 0.4 + distancedHeightPlane / 80.0 - 1.0;
                if (Yplus > 10.0) {
                    Yplus = 10.0;
                }
                this.targetY = Math.min(this.target.func_174813_aQ().field_72338_b + Yplus, 80.0);
            } else {
                this.targetX += (this.field_70146_Z.nextDouble() * 2.0 - 1.0) * 2.0;
                this.targetZ += (this.field_70146_Z.nextDouble() * 2.0 - 1.0) * 2.0;
            }
            if (this.forceNewTarget || distance < 3.0 || distance > 250.0 || this.field_70123_F || this.field_70124_G || this.targetY > 80.0) {
                this.setNewTarget();
            }
            if ((distanceY /= (double)MathHelper.func_76133_a((double)(distanceX * distanceX + distanceZ * distanceZ))) < (double)(-(limitDistanceY = 0.6f))) {
                distanceY = -limitDistanceY;
            }
            if (distanceY > (double)limitDistanceY) {
                distanceY = limitDistanceY;
            }
            this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, distanceY * 0.1, 0.0));
            this.field_70177_z = MathHelper.func_76142_g((float)this.field_70177_z);
            double newYaw = 180.0 - Math.atan2(distanceX, distanceZ) * 180.0 / Math.PI;
            double differenceYaw = MathHelper.func_76138_g((double)(newYaw - (double)this.field_70177_z));
            double limitDifferenceYaw = 50.0;
            if (differenceYaw > limitDifferenceYaw) {
                differenceYaw = limitDifferenceYaw;
            }
            if (differenceYaw < -limitDifferenceYaw) {
                differenceYaw = -limitDifferenceYaw;
            }
            Vector3d distanceVector = new Vector3d(this.targetX - this.func_226277_ct_(), this.targetY - this.func_226278_cu_(), this.targetZ - this.func_226281_cx_()).func_72432_b();
            Vector3d rotationVector = new Vector3d((double)MathHelper.func_76126_a((float)(this.field_70177_z * (float)Math.PI / 180.0f)), m.field_72448_b, (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * (float)Math.PI / 180.0f)))).func_72432_b();
            float dynamicMotionMultiplier = (float)(rotationVector.func_72430_b(distanceVector) + 0.5) / 1.5f;
            if (dynamicMotionMultiplier < 0.0f) {
                dynamicMotionMultiplier = 0.0f;
            }
            this.randomYawVelocity *= 0.8f;
            float motionDistanceHeightPlaneFloat = MathHelper.func_76133_a((double)(m.field_72450_a * m.field_72450_a + m.field_72449_c * m.field_72449_c)) * 1.0f + 1.0f;
            double motionDistanceHeightPlane = Math.sqrt(m.field_72450_a * m.field_72450_a + m.field_72449_c * m.field_72449_c) * 1.0 + 1.0;
            if (motionDistanceHeightPlane > 40.0) {
                motionDistanceHeightPlane = 40.0;
            }
            this.randomYawVelocity = (float)((double)this.randomYawVelocity + differenceYaw * (0.7 / motionDistanceHeightPlane / (double)motionDistanceHeightPlaneFloat));
            this.field_70177_z += this.randomYawVelocity * 0.1f;
            float scaledMotionDistanceHeightPlane = (float)(2.0 / (motionDistanceHeightPlane + 1.0));
            float staticMotionMultiplier = 0.03f;
            this.func_213309_a(staticMotionMultiplier * (dynamicMotionMultiplier * scaledMotionDistanceHeightPlane + (1.0f - scaledMotionDistanceHeightPlane)), new Vector3d(0.0, 0.0, -1.0));
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            Vector3d vec3d3 = this.func_213322_ci().func_72432_b();
            double d6 = 0.8 + 0.15 * (vec3d3.func_72430_b(rotationVector) + 1.0) / 2.0;
            this.func_213317_d(this.func_213322_ci().func_216372_d(d6, (double)0.91f, d6));
        }
        this.field_70761_aq = this.field_70177_z;
        if (!this.field_70170_p.func_201670_d() && this.field_70737_aN == 0 && this.func_70089_S()) {
            this.attackEntitiesInList(this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b(1.0, 0.0, 1.0)));
        }
        if (this.wingGoUp) {
            ++this.wingProgress;
            if (this.wingProgress > WINGLENGTH) {
                this.wingGoUp = false;
            }
        } else {
            --this.wingProgress;
            if (this.wingProgress < -WINGLENGTH) {
                this.wingGoUp = true;
            }
        }
        if (!this.field_70170_p.func_201670_d() && this.field_70170_p.func_175659_aa() == Difficulty.PEACEFUL) {
            this.func_70106_y();
        }
    }

    private void attackEntitiesInList(List<Entity> entities) {
        int chance = EntityPoisonousLibelleConfig.poisonChance;
        for (Entity entity : entities) {
            if (chance <= 0 || this.field_70170_p.field_73012_v.nextInt(chance) != 0 || !(entity instanceof LivingEntity)) continue;
            boolean shouldAttack = true;
            if (entity instanceof PlayerEntity && ((PlayerEntity)entity).func_184812_l_()) {
                shouldAttack = false;
                this.setNewTarget();
            }
            if (!shouldAttack) continue;
            if (EntityPoisonousLibelleConfig.hasAttackDamage) {
                entity.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), 0.5f);
            }
            ((LivingEntity)entity).func_195064_c(new EffectInstance(Effects.field_76436_u, 40, 1));
        }
    }

    private void setNewTarget() {
        this.forceNewTarget = false;
        boolean targetSet = false;
        if (this.field_70146_Z.nextInt(2) == 0 && !this.field_70170_p.func_217369_A().isEmpty() && !this.field_70170_p.func_72935_r()) {
            this.target = (Entity)this.field_70170_p.func_217369_A().get(this.field_70146_Z.nextInt(this.field_70170_p.func_217369_A().size()));
            targetSet = true;
            if (this.target instanceof PlayerEntity && ((PlayerEntity)this.target).func_184812_l_()) {
                targetSet = false;
            }
        }
        if (!targetSet) {
            double d2;
            double d1;
            double d0;
            boolean flag;
            do {
                this.targetX = this.func_226277_ct_();
                this.targetY = 80.0f - this.field_70146_Z.nextFloat() * 30.0f;
                this.targetZ = this.func_226281_cx_();
                this.targetX += (double)(this.field_70146_Z.nextFloat() * 120.0f - 60.0f);
                this.targetZ += (double)(this.field_70146_Z.nextFloat() * 120.0f - 60.0f);
            } while (!(flag = (d0 = this.func_226277_ct_() - this.targetX) * d0 + (d1 = this.func_226278_cu_() - this.targetY) * d1 + (d2 = this.func_226281_cx_() - this.targetZ) * d2 > 20.0));
            this.target = null;
        }
    }

    public float getWingProgressScaled(float scale) {
        return (float)this.wingProgress / (float)WINGLENGTH * scale;
    }

    static {
        MinecraftForge.EVENT_BUS.register(EntityPoisonousLibelle.class);
        WINGLENGTH = 4;
    }
}

