/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.entity.monster;

import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.GlobalEntityTypeAttributes;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import org.cyclops.cyclopscore.config.ConfigurableProperty;
import org.cyclops.cyclopscore.config.extendedconfig.EntityConfig;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.evilcraft.EvilCraft;
import org.cyclops.evilcraft.client.render.entity.ModelPoisonousLibelle;
import org.cyclops.evilcraft.client.render.entity.RenderPoisonousLibelle;
import org.cyclops.evilcraft.entity.monster.EntityPoisonousLibelle;

public class EntityPoisonousLibelleConfig
extends EntityConfig<EntityPoisonousLibelle> {
    @ConfigurableProperty(category="mob", comment="Should the Poisonous Libelle do damage, next to poisoning?", isCommandable=true)
    public static boolean hasAttackDamage = false;
    @ConfigurableProperty(category="mob", comment="The minimum Y-level this mob can spawn at.", isCommandable=true)
    public static int minY = 55;
    @ConfigurableProperty(category="mob", comment="1/X chance on getting poisoned when hit.", isCommandable=true)
    public static int poisonChance = 20;

    public EntityPoisonousLibelleConfig() {
        super((ModBase)EvilCraft._instance, "poisonous_libelle", eConfig -> EntityType.Builder.func_220322_a(EntityPoisonousLibelle::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(0.5f, 0.45f).func_220320_c(), EntityPoisonousLibelleConfig.getDefaultSpawnEggItemConfigConstructor((ModBase)EvilCraft._instance, (String)"poisonous_libelle_spawn_egg", (int)Helpers.RGBToInt((int)57, (int)125, (int)27), (int)Helpers.RGBToInt((int)196, (int)213, (int)57)));
        MinecraftForge.EVENT_BUS.addListener(this::onBiomeLoadingEvent);
    }

    public void onBiomeLoadingEvent(BiomeLoadingEvent event) {
        if (event.getName().equals((Object)Biomes.field_76781_i.func_240901_a_())) {
            event.getSpawns().getSpawner(((EntityType)this.getInstance()).func_220339_d()).add(new MobSpawnInfo.Spawners((EntityType)this.getInstance(), 1, 1, 2));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public EntityRenderer<? super EntityPoisonousLibelle> getRender(EntityRendererManager entityRendererManager, ItemRenderer itemRenderer) {
        return new RenderPoisonousLibelle(entityRendererManager, this, new ModelPoisonousLibelle(), 0.5f);
    }

    public void onForgeRegistered() {
        super.onForgeRegistered();
        GlobalEntityTypeAttributes.put((EntityType)((EntityType)this.getInstance()), (AttributeModifierMap)MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 1.0).func_233815_a_(Attributes.field_233821_d_, 0.625).func_233813_a_());
    }
}

