/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.entity.monster;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.LootTable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.client.particle.ParticleBlurData;
import org.cyclops.cyclopscore.helper.BlockHelpers;
import org.cyclops.cyclopscore.helper.WorldHelpers;
import org.cyclops.cyclopscore.inventory.PlayerExtendedInventoryIterator;
import org.cyclops.cyclopscore.inventory.PlayerInventoryIterator;
import org.cyclops.evilcraft.EvilCraft;
import org.cyclops.evilcraft.EvilCraftSoundEvents;
import org.cyclops.evilcraft.ExtendedDamageSource;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.block.BlockGemStoneTorchConfig;
import org.cyclops.evilcraft.client.particle.ParticleDarkSmokeData;
import org.cyclops.evilcraft.core.monster.EntityNoMob;
import org.cyclops.evilcraft.entity.monster.EntityVengeanceSpiritConfig;
import org.cyclops.evilcraft.entity.monster.EntityVengeanceSpiritData;
import org.cyclops.evilcraft.entity.monster.EntityVengeanceSpiritSyncedData;
import org.cyclops.evilcraft.item.ItemBurningGemStone;
import org.cyclops.evilcraft.item.ItemSpectralGlasses;
import org.cyclops.evilcraft.item.ItemVengeanceRing;

public class EntityVengeanceSpirit
extends EntityNoMob {
    private static final Set<String> IMC_BLACKLIST;
    public static final int REMAININGLIFE_MIN = 250;
    public static final int REMAININGLIFE_MAX = 1000;
    public static final DataParameter<String> WATCHERID_INNER;
    public static final DataParameter<Integer> WATCHERID_REMAININGLIFE;
    public static final DataParameter<Integer> WATCHERID_FROZENDURATION;
    public static final DataParameter<Integer> WATCHERID_GLOBALVENGEANCE;
    public static final DataParameter<String> WATCHERID_VENGEANCEPLAYERS;
    public static final DataParameter<Integer> WATCHERID_ISSWARM;
    public static final DataParameter<Integer> WATCHERID_SWARMTIER;
    public static final DataParameter<Integer> WATCHERID_BUILDUP;
    public static final DataParameter<String> WATCHERID_PLAYERID;
    public static final DataParameter<String> WATCHERID_PLAYERNAME;
    private EntityVengeanceSpiritSyncedData data;
    private MobEntity innerEntity = null;
    @Nullable
    private EntityType<?> preferredInnerEntity;
    private final Set<ServerPlayerEntity> entanglingPlayers = Sets.newHashSet();

    public EntityVengeanceSpirit(EntityType<? extends EntityVengeanceSpirit> type, World world) {
        this(type, world, null);
    }

    public EntityVengeanceSpirit(World world) {
        this(RegistryEntries.ENTITY_VENGEANCE_SPIRIT, world, null);
    }

    public EntityVengeanceSpirit(EntityType<? extends EntityVengeanceSpirit> type, World world, @Nullable EntityType<?> preferredInnerEntity) {
        super(type, world);
        this.preferredInnerEntity = preferredInnerEntity;
        this.field_70138_W = 5.0f;
        this.field_70156_m = false;
        float damage = 0.5f;
        int remainingLife = MathHelper.func_76136_a((Random)world.field_73012_v, (int)250, (int)1000);
        if (this.isSwarm()) {
            damage = (float)((double)damage + 0.5 * (double)this.getSwarmTier());
            remainingLife += 750 * this.getSwarmTier();
        }
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new RandomWalkingGoal((CreatureEntity)this, 0.6));
        this.field_70714_bg.func_75776_a(2, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(4, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, damage));
        this.field_70714_bg.func_75776_a(4, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, false));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
        this.setRemainingLife(remainingLife);
        this.setFrozenDuration(0);
    }

    public double func_233638_c_(Attribute attribute) {
        if (attribute == Attributes.field_233821_d_) {
            double speed = 0.25;
            if (this.isSwarm()) {
                speed += 0.125 * (double)this.getSwarmTier();
            }
            return speed;
        }
        return super.func_233638_c_(attribute);
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void vengeanceEvent(LivingDeathEvent event) {
        if (event.getEntityLiving() != null) {
            World world = event.getEntityLiving().field_70170_p;
            boolean directToPlayer = EntityVengeanceSpirit.shouldDirectSpiritToPlayer(event);
            if (!world.func_201670_d() && world.func_175659_aa() != Difficulty.PEACEFUL && EntityVengeanceSpirit.canSustain(event.getEntityLiving()) && (directToPlayer || EntityVengeanceSpirit.canSpawnNew(world, event.getEntityLiving().func_233580_cy_()))) {
                EntityVengeanceSpirit spirit = new EntityVengeanceSpirit(world);
                spirit.setInnerEntity(event.getEntityLiving());
                spirit.func_82149_j((Entity)event.getEntityLiving());
                world.func_217376_c((Entity)spirit);
                if (directToPlayer) {
                    PlayerEntity player = (PlayerEntity)event.getSource().func_76346_g();
                    spirit.setBuildupDuration(60);
                    spirit.setGlobalVengeance(true);
                    spirit.func_70624_b((LivingEntity)player);
                }
            }
        }
    }

    private static boolean shouldDirectSpiritToPlayer(LivingDeathEvent event) {
        if (event.getSource().func_76346_g() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)event.getSource().func_76346_g();
            PlayerExtendedInventoryIterator it = new PlayerExtendedInventoryIterator(player);
            while (it.hasNext()) {
                ItemStack itemStack = it.next();
                if (itemStack.func_190926_b() || !(itemStack.func_77973_b() instanceof ItemVengeanceRing)) continue;
                return true;
            }
        }
        return false;
    }

    public void func_70088_a() {
        super.func_70088_a();
        this.data = this.preferredInnerEntity == null ? new EntityVengeanceSpiritSyncedData(this.field_70180_af, EntityVengeanceSpiritData.getRandomInnerEntity(this.field_70146_Z)) : new EntityVengeanceSpiritSyncedData(this.field_70180_af, this.preferredInnerEntity);
    }

    public void func_213281_b(CompoundNBT tag) {
        super.func_213281_b(tag);
        this.data.writeNBT(tag);
    }

    public void func_70037_a(CompoundNBT tag) {
        super.func_70037_a(tag);
        this.data.readNBT(tag);
    }

    public ResourceLocation func_184647_J() {
        return new ResourceLocation("evilcraft", "entities/" + this.func_200600_R().getRegistryName().func_110623_a());
    }

    protected float func_70647_i() {
        return super.func_70647_i() / 3.0f;
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223223_b_;
    }

    public boolean func_180431_b(DamageSource damageSource) {
        return !(damageSource instanceof ExtendedDamageSource.VengeanceBeamDamageSource) && damageSource != DamageSource.field_76380_i;
    }

    public boolean func_70652_k(Entity entity) {
        PlayerEntity player;
        if (this.getBuildupDuration() > 0) {
            return false;
        }
        this.func_70106_y();
        if (entity instanceof PlayerEntity && ItemBurningGemStone.damageForPlayer(player = (PlayerEntity)entity, this.isSwarm() ? this.getSwarmTier() : 0, false)) {
            entity.func_70024_g((double)(-MathHelper.func_76126_a((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * 0.01f), 0.025, (double)(MathHelper.func_76134_b((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * 0.01f));
            entity.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), 0.1f);
            return false;
        }
        return super.func_70652_k(entity);
    }

    protected void func_213354_a(DamageSource damageSource, boolean fromPlayer) {
        ResourceLocation deathLootTable;
        super.func_213354_a(damageSource, fromPlayer);
        MobEntity innerEntity = this.getInnerEntity();
        if (innerEntity instanceof MobEntity && damageSource != DamageSource.field_76380_i && (deathLootTable = innerEntity.func_184647_J()) != null) {
            LootTable loottable = this.func_130014_f_().func_73046_m().func_200249_aQ().func_186521_a(deathLootTable);
            LootContext.Builder lootcontext$builder = new LootContext.Builder((ServerWorld)this.func_130014_f_()).func_216023_a(this.field_70146_Z).func_216015_a(LootParameters.field_216281_a, (Object)innerEntity).func_216015_a(LootParameters.field_237457_g_, (Object)new Vector3d(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_())).func_216015_a(LootParameters.field_216283_c, (Object)DamageSource.field_76377_j).func_216021_b(LootParameters.field_216284_d, null).func_216021_b(LootParameters.field_216285_e, null);
            if (fromPlayer && this.field_70717_bb != null) {
                lootcontext$builder = lootcontext$builder.func_216015_a(LootParameters.field_216282_b, (Object)this.field_70717_bb).func_186469_a(this.field_70717_bb.func_184817_da());
            }
            for (ItemStack itemstack : loottable.func_216113_a(lootcontext$builder.func_216022_a(LootParameterSets.field_216263_d))) {
                this.func_70099_a(itemstack, 0.0f);
            }
        }
    }

    public void func_70106_y() {
        super.func_70106_y();
        if (this.field_70170_p.func_201670_d() && this.isVisible()) {
            this.spawnSmoke();
            this.func_184185_a(this.func_184615_bR(), 0.1f + this.field_70170_p.field_73012_v.nextFloat() * 0.9f, 0.1f + this.field_70170_p.field_73012_v.nextFloat() * 0.9f);
        }
    }

    public boolean func_70610_aX() {
        return this.isFrozen() || this.getBuildupDuration() > 0;
    }

    @Override
    public void func_70636_d() {
        int buildupDuration;
        super.func_70636_d();
        if (this.isVisible()) {
            if (this.innerEntity != null) {
                this.innerEntity.field_70725_aQ = this.field_70725_aQ;
                this.innerEntity.func_70604_c(this.func_70638_az());
                this.innerEntity.field_70737_aN = this.field_70737_aN;
                this.innerEntity.field_70125_A = this.field_70125_A;
                this.innerEntity.field_70177_z = this.field_70177_z;
                this.innerEntity.field_70759_as = this.field_70759_as;
                this.innerEntity.field_70761_aq = this.field_70761_aq;
                this.innerEntity.field_70127_C = this.field_70127_C;
                this.innerEntity.field_70760_ar = this.field_70760_ar;
                this.innerEntity.field_70126_B = this.field_70126_B;
                this.innerEntity.field_70758_at = this.field_70758_at;
            }
            if (this.field_70170_p.func_201670_d()) {
                this.spawnSmoke();
                if (this.isSwarm()) {
                    this.spawnSwarmParticles();
                }
            }
        }
        if ((buildupDuration = this.getBuildupDuration()) > 0) {
            this.setBuildupDuration(buildupDuration - 1);
        }
        if (this.isFrozen()) {
            this.func_213293_j(0.0, 0.0, 0.0);
            this.addFrozenDuration(-1);
        } else {
            this.setRemainingLife(this.getRemainingLife() - 1);
            if (this.getRemainingLife() <= 0) {
                this.func_70106_y();
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void spawnSmoke() {
        EntitySize size = this.func_213305_a(this.func_213283_Z());
        int numParticles = this.field_70146_Z.nextInt(5);
        if (!this.func_70089_S()) {
            numParticles *= 10;
        }
        float clearRange = size.field_220315_a;
        for (int i = 0; i < numParticles; ++i) {
            double particleX = this.func_226277_ct_() - (double)(size.field_220315_a / 2.0f) + (double)(size.field_220315_a * this.field_70146_Z.nextFloat());
            if (particleX < (double)0.7f && particleX >= 0.0) {
                particleX += (double)(size.field_220315_a / 2.0f);
            }
            if (particleX > (double)-0.7f && particleX <= 0.0) {
                particleX -= (double)(size.field_220315_a / 2.0f);
            }
            double particleY = this.func_226278_cu_() + (double)(size.field_220316_b * this.field_70146_Z.nextFloat());
            double particleZ = this.func_226281_cx_() - (double)(size.field_220315_a / 2.0f) + (double)(size.field_220315_a * this.field_70146_Z.nextFloat());
            if (particleZ < (double)clearRange && particleZ >= 0.0) {
                particleZ += (double)(size.field_220315_a / 2.0f);
            }
            if (particleZ > (double)(-clearRange) && particleZ <= 0.0) {
                particleZ -= (double)(size.field_220315_a / 2.0f);
            }
            float particleMotionX = (-0.5f + this.field_70146_Z.nextFloat()) * 0.05f;
            float particleMotionY = (-0.5f + this.field_70146_Z.nextFloat()) * 0.05f;
            float particleMotionZ = (-0.5f + this.field_70146_Z.nextFloat()) * 0.05f;
            Minecraft.func_71410_x().field_71438_f.func_195461_a((IParticleData)new ParticleDarkSmokeData(!this.func_70089_S()), false, particleX, particleY, particleZ, (double)particleMotionX, (double)particleMotionY, (double)particleMotionZ);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void spawnSwarmParticles() {
        EntitySize size = this.func_213305_a(this.func_213283_Z());
        int numParticles = 5 * (this.field_70146_Z.nextInt((this.getSwarmTier() << 1) + 1) + 1);
        for (int i = 0; i < numParticles; ++i) {
            double particleX = this.func_226277_ct_() - (double)(size.field_220315_a / 2.0f) + (double)(size.field_220315_a * this.field_70146_Z.nextFloat());
            if (particleX < (double)0.7f && particleX >= 0.0) {
                particleX += (double)(size.field_220315_a / 2.0f);
            }
            if (particleX > (double)-0.7f && particleX <= 0.0) {
                particleX -= (double)(size.field_220315_a / 2.0f);
            }
            double particleY = this.func_226278_cu_() + (double)(size.field_220316_b * this.field_70146_Z.nextFloat());
            double particleZ = this.func_226281_cx_() - (double)(size.field_220315_a / 2.0f) + (double)(size.field_220315_a * this.field_70146_Z.nextFloat());
            float particleMotionX = (-0.5f + this.field_70146_Z.nextFloat()) * 0.05f;
            float particleMotionY = (-0.5f + this.field_70146_Z.nextFloat()) * 0.05f;
            float particleMotionZ = (-0.5f + this.field_70146_Z.nextFloat()) * 0.05f;
            Minecraft.func_71410_x().field_71438_f.func_195461_a((IParticleData)RegistryEntries.PARTICLE_DEGRADE, false, particleX, particleY, particleZ, (double)particleMotionX, (double)particleMotionY, (double)particleMotionZ);
        }
    }

    public void func_184185_a(SoundEvent soundIn, float volume, float pitch) {
        if (soundIn != null && this.isVisible() && !this.func_174814_R()) {
            this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), soundIn, this.func_184176_by(), volume, pitch, true);
        }
    }

    public boolean isVisible() {
        return this.field_70170_p.func_201670_d() && (this.isAlternativelyVisible() || this.isClientVisible());
    }

    @OnlyIn(value=Dist.CLIENT)
    private boolean isClientVisible() {
        if (this.isEnabledVengeance((PlayerEntity)Minecraft.func_71410_x().field_71439_g)) {
            return true;
        }
        PlayerInventoryIterator it = new PlayerInventoryIterator((PlayerEntity)Minecraft.func_71410_x().field_71439_g);
        while (it.hasNext()) {
            ItemStack itemStack = it.next();
            if (itemStack.func_190926_b() || !(itemStack.func_77973_b() instanceof ItemSpectralGlasses)) continue;
            return true;
        }
        return false;
    }

    private boolean isAlternativelyVisible() {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        return EntityVengeanceSpiritConfig.alwaysVisibleInCreative && player != null && player.func_184812_l_();
    }

    protected void func_85033_bc() {
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean func_70067_L() {
        return false;
    }

    public void func_241841_a(ServerWorld world, LightningBoltEntity lightning) {
        this.setGlobalVengeance(true);
    }

    public boolean func_70685_l(Entity entity) {
        if (entity instanceof PlayerEntity) {
            return this.isEnabledVengeance((PlayerEntity)entity);
        }
        return super.func_70685_l(entity);
    }

    public boolean isEnabledVengeance(PlayerEntity player) {
        return this.isGlobalVengeance() || player != null && ArrayUtils.contains((Object[])this.getVengeancePlayers(), (Object)player.func_200200_C_());
    }

    public void setEnabledVengeance(PlayerEntity player, boolean enabled) {
        Object[] players = this.getVengeancePlayers();
        int index = ArrayUtils.indexOf((Object[])players, (Object)player.func_145748_c_().getString());
        if (enabled && index == -1) {
            players = (String[])ArrayUtils.add((Object[])players, (Object)player.func_200200_C_().getString());
        } else if (!enabled && index != -1) {
            players = (String[])ArrayUtils.remove((Object[])players, (int)index);
        }
        this.setVengeancePlayers((String[])players);
    }

    public boolean func_70684_aJ() {
        return this.containsPlayer();
    }

    public EntitySize func_213305_a(Pose poseIn) {
        if (this.isSwarm()) {
            return EntitySize.func_220314_b((float)(this.getSwarmTier() / 3 + 1), (float)(this.getSwarmTier() / 2 + 1));
        }
        MobEntity innerEntity = this.getInnerEntity();
        if (innerEntity != null) {
            return innerEntity.func_213305_a(poseIn);
        }
        return super.func_213305_a(poseIn);
    }

    @Nullable
    public MobEntity getInnerEntity() {
        if (this.isSwarm()) {
            return null;
        }
        EntityType<?> entityType = this.data.getInnerEntityType();
        if (this.innerEntity != null && entityType != null && entityType == this.innerEntity.func_200600_R()) {
            return this.innerEntity;
        }
        try {
            Entity entity;
            if (entityType != RegistryEntries.ENTITY_VENGEANCE_SPIRIT && EntityVengeanceSpirit.canSustain((LivingEntity)((MobEntity)(entity = entityType.func_200721_a(this.field_70170_p))))) {
                this.innerEntity = (MobEntity)entity;
                return this.innerEntity;
            }
        }
        catch (ClassCastException | NullPointerException runtimeException) {
            // empty catch block
        }
        return null;
    }

    public void setInnerEntity(LivingEntity innerEntity) {
        if (innerEntity instanceof PlayerEntity) {
            this.setPlayerId(((PlayerEntity)innerEntity).func_146103_bH().getId().toString());
            this.setPlayerName(((PlayerEntity)innerEntity).func_146103_bH().getName());
            this.data.setInnerEntityType(EntityType.field_200725_aD);
        } else {
            this.data.setInnerEntityType(innerEntity.func_200600_R());
        }
    }

    public static boolean canSustain(LivingEntity entityLiving) {
        String entityName = entityLiving.func_200600_R().getRegistryName().toString();
        for (String blacklistedRegex : EntityVengeanceSpiritConfig.entityBlacklist) {
            if (!entityName.matches(blacklistedRegex)) continue;
            return false;
        }
        for (String blacklistedRegex : IMC_BLACKLIST) {
            if (!entityName.matches(blacklistedRegex)) continue;
            return false;
        }
        return true;
    }

    public static boolean canSpawnNew(World world, BlockPos blockPos) {
        int area = EntityVengeanceSpiritConfig.spawnLimitArea;
        int threshold = EntityVengeanceSpiritConfig.spawnLimit;
        AxisAlignedBB box = new AxisAlignedBB((double)blockPos.func_177958_n(), (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p(), (double)blockPos.func_177958_n(), (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p()).func_72314_b((double)area, (double)area, (double)area);
        List spirits = world.func_217357_a(EntityVengeanceSpirit.class, box);
        if (spirits.size() >= threshold) {
            return false;
        }
        return (Boolean)WorldHelpers.foldArea((IWorld)world, (int)BlockGemStoneTorchConfig.area, (BlockPos)blockPos, (input, world1, blockPos1) -> input != false && !BlockTags.func_199896_a().func_199910_a(new ResourceLocation("evilcraft:vengeance_spirit_blocker")).func_230235_a_((Object)world1.func_180495_p(blockPos1).func_177230_c()), (Object)true);
    }

    public void onHit(double hitX, double hitY, double hitZ, double impactMotionX, double impactMotionY, double impactMotionZ) {
        this.addFrozenDuration(this.field_70170_p.field_73012_v.nextInt(4) + 3);
        if (this.field_70170_p.func_201670_d()) {
            this.showBurstParticles(hitX, hitY, hitZ, impactMotionX, impactMotionY, impactMotionZ);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void showBurstParticles(double hitX, double hitY, double hitZ, double impactMotionX, double impactMotionY, double impactMotionZ) {
        for (int i = 0; i < this.field_70170_p.field_73012_v.nextInt(5); ++i) {
            float scale = 0.04f - this.field_70146_Z.nextFloat() * 0.02f;
            float red = this.field_70146_Z.nextFloat() * 0.2f + 0.3f;
            float green = this.field_70146_Z.nextFloat() * 0.2f + 0.3f;
            float blue = this.field_70146_Z.nextFloat() * 0.01f;
            float ageMultiplier = (float)(this.field_70146_Z.nextDouble() * 0.5 + 3.0);
            double dx = 0.1 - this.field_70146_Z.nextDouble() * 0.2 - impactMotionX * 0.1;
            double dy = 0.1 - this.field_70146_Z.nextDouble() * 0.2 - impactMotionY * 0.1;
            double dz = 0.1 - this.field_70146_Z.nextDouble() * 0.2 - impactMotionZ * 0.1;
            Minecraft.func_71410_x().field_71438_f.func_195461_a((IParticleData)new ParticleBlurData(red, green, blue, scale, ageMultiplier), false, hitX, hitY, hitZ, dx, dy, dz);
        }
    }

    public static EntityVengeanceSpirit spawnRandom(World world, BlockPos blockPos, int area) {
        EntityVengeanceSpirit spirit = new EntityVengeanceSpirit(world);
        int baseDistance = 5;
        for (int attempts = 50; EntityVengeanceSpirit.canSpawnNew(world, blockPos) && attempts > 0; --attempts) {
            BlockPos spawnPos = blockPos.func_177982_a(MathHelper.func_76136_a((Random)world.field_73012_v, (int)baseDistance, (int)(baseDistance + area)) * MathHelper.func_76136_a((Random)world.field_73012_v, (int)-1, (int)1), MathHelper.func_76136_a((Random)world.field_73012_v, (int)0, (int)3) * MathHelper.func_76136_a((Random)world.field_73012_v, (int)-1, (int)1), MathHelper.func_76136_a((Random)world.field_73012_v, (int)baseDistance, (int)(baseDistance + area)) * MathHelper.func_76136_a((Random)world.field_73012_v, (int)-1, (int)1));
            if (!BlockHelpers.doesBlockHaveSolidTopSurface((IWorldReader)world, (BlockPos)spawnPos.func_177982_a(0, -1, 0))) continue;
            spirit.func_70107_b((double)spawnPos.func_177958_n() + 0.5, (double)spawnPos.func_177956_o() + 0.5, (double)spawnPos.func_177952_p() + 0.5);
            if (world.func_226669_j_((Entity)spirit) || !spirit.func_205019_a((IWorldReader)world) || world.func_72953_d(spirit.func_174813_aQ())) continue;
            world.func_217376_c((Entity)spirit);
            return spirit;
        }
        return null;
    }

    @Override
    public SoundEvent func_184615_bR() {
        if (this.getInnerEntity() != null) {
            return this.getInnerEntity().func_184615_bR();
        }
        return EvilCraftSoundEvents.mob_vengeancespirit_death;
    }

    public SoundEvent func_184639_G() {
        MobEntity entity = this.getInnerEntity();
        if (entity != null && entity instanceof MobEntity) {
            return this.getInnerEntity().func_184639_G();
        }
        return EvilCraftSoundEvents.mob_vengeancespirit_ambient;
    }

    public static void addToBlacklistIMC(String entityName) {
        IMC_BLACKLIST.add(entityName);
        EvilCraft.clog("Added entity name " + entityName + " to the spirit blacklist.", Level.TRACE);
    }

    public boolean func_210500_b(ITag<Fluid> fluidTag, double p_210500_2_) {
        return this.field_70171_ac;
    }

    public boolean func_145773_az() {
        return true;
    }

    public static EntityVengeanceSpirit fromNBT(World world, CompoundNBT spiritTag) {
        EntityVengeanceSpirit spirit = new EntityVengeanceSpirit(world);
        spirit.func_70037_a(spiritTag);
        return spirit;
    }

    public void addEntanglingPlayer(ServerPlayerEntity player) {
        this.entanglingPlayers.add(player);
    }

    public Set<ServerPlayerEntity> getEntanglingPlayers() {
        return this.entanglingPlayers;
    }

    public EntityVengeanceSpiritSyncedData getData() {
        return this.data;
    }

    public void register(EntityDataManager dataManager) {
        this.getData().register(dataManager);
    }

    public EntityType<?> getInnerEntityType() {
        return this.getData().getInnerEntityType();
    }

    public void setInnerEntityType(EntityType<?> innerEntityType) {
        this.getData().setInnerEntityType(innerEntityType);
    }

    public int getRemainingLife() {
        return this.getData().getRemainingLife();
    }

    public void setRemainingLife(int remainingLife) {
        this.getData().setRemainingLife(remainingLife);
    }

    public int getFrozenDuration() {
        return this.getData().getFrozenDuration();
    }

    public void setFrozenDuration(int frozenDuration) {
        this.getData().setFrozenDuration(frozenDuration);
    }

    public String getPlayerId() {
        return this.getData().getPlayerId();
    }

    public void setPlayerId(String playerId) {
        this.getData().setPlayerId(playerId);
    }

    public String getPlayerName() {
        return this.getData().getPlayerName();
    }

    public void setPlayerName(String playerName) {
        this.getData().setPlayerName(playerName);
    }

    public boolean isSwarm() {
        return this.getData().isSwarm();
    }

    public void setSwarm(boolean isSwarm) {
        this.getData().setSwarm(isSwarm);
    }

    public int getSwarmTier() {
        return this.getData().getSwarmTier();
    }

    public void setSwarmTier(int swarmTier) {
        this.getData().setSwarmTier(swarmTier);
    }

    public boolean isGlobalVengeance() {
        return this.getData().isGlobalVengeance();
    }

    public void setGlobalVengeance(boolean globalVengeance) {
        this.getData().setGlobalVengeance(globalVengeance);
    }

    public String[] getVengeancePlayers() {
        return this.getData().getVengeancePlayers();
    }

    public void setVengeancePlayers(String[] vengeancePlayers) {
        this.getData().setVengeancePlayers(vengeancePlayers);
    }

    public boolean isFrozen() {
        return this.getData().isFrozen();
    }

    public void addFrozenDuration(int amount) {
        this.getData().addFrozenDuration(amount);
    }

    public boolean containsPlayer() {
        return this.getData().containsPlayer();
    }

    public boolean hasInnerEntity() {
        return this.getData().hasInnerEntity();
    }

    public void setRandomSwarmTier(Random random) {
        this.getData().setRandomSwarmTier(random);
    }

    public void readNBT(CompoundNBT tag) {
        this.getData().readNBT(tag);
    }

    public CompoundNBT writeNBT(CompoundNBT tag) {
        return this.getData().writeNBT(tag);
    }

    public UUID getPlayerUUID() {
        return this.getData().getPlayerUUID();
    }

    public int getBuildupDuration() {
        return this.getData().getBuildupDuration();
    }

    public void setBuildupDuration(int buildupDuration) {
        this.getData().setBuildupDuration(buildupDuration);
    }

    static {
        MinecraftForge.EVENT_BUS.register(EntityVengeanceSpirit.class);
        IMC_BLACKLIST = Sets.newHashSet();
        WATCHERID_INNER = EntityDataManager.func_187226_a(EntityVengeanceSpirit.class, (IDataSerializer)DataSerializers.field_187194_d);
        WATCHERID_REMAININGLIFE = EntityDataManager.func_187226_a(EntityVengeanceSpirit.class, (IDataSerializer)DataSerializers.field_187192_b);
        WATCHERID_FROZENDURATION = EntityDataManager.func_187226_a(EntityVengeanceSpirit.class, (IDataSerializer)DataSerializers.field_187192_b);
        WATCHERID_GLOBALVENGEANCE = EntityDataManager.func_187226_a(EntityVengeanceSpirit.class, (IDataSerializer)DataSerializers.field_187192_b);
        WATCHERID_VENGEANCEPLAYERS = EntityDataManager.func_187226_a(EntityVengeanceSpirit.class, (IDataSerializer)DataSerializers.field_187194_d);
        WATCHERID_ISSWARM = EntityDataManager.func_187226_a(EntityVengeanceSpirit.class, (IDataSerializer)DataSerializers.field_187192_b);
        WATCHERID_SWARMTIER = EntityDataManager.func_187226_a(EntityVengeanceSpirit.class, (IDataSerializer)DataSerializers.field_187192_b);
        WATCHERID_BUILDUP = EntityDataManager.func_187226_a(EntityVengeanceSpirit.class, (IDataSerializer)DataSerializers.field_187192_b);
        WATCHERID_PLAYERID = EntityDataManager.func_187226_a(EntityVengeanceSpirit.class, (IDataSerializer)DataSerializers.field_187194_d);
        WATCHERID_PLAYERNAME = EntityDataManager.func_187226_a(EntityVengeanceSpirit.class, (IDataSerializer)DataSerializers.field_187194_d);
    }
}

