/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.entity.monster;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.GlobalEntityTypeAttributes;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.cyclops.cyclopscore.config.ConfigurableProperty;
import org.cyclops.cyclopscore.config.extendedconfig.EntityConfig;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.evilcraft.EvilCraft;
import org.cyclops.evilcraft.client.render.entity.RenderVengeanceSpirit;
import org.cyclops.evilcraft.entity.monster.EntityVengeanceSpirit;

public class EntityVengeanceSpiritConfig
extends EntityConfig<EntityVengeanceSpirit> {
    @ConfigurableProperty(category="mob", comment="The maximum amount of vengeance spirits naturally spawnable in the spawnLimitArea.")
    public static int spawnLimit = 5;
    @ConfigurableProperty(category="mob", comment="The area in which the spawn limit will be checked on each spawn attempt.")
    public static int spawnLimitArea = 5;
    @ConfigurableProperty(category="mob", comment="The blacklisted entity spirits, by entity name. Regular expressions are allowed.")
    public static List<String> entityBlacklist = Lists.newArrayList((Object[])new String[]{"evilcraft:vengeance_spirit", "evilcraft:controlled_zombie", "evilcraft:werewolf", "minecraft:ender_dragon"});
    @ConfigurableProperty(category="mob", comment="Whether vengeance spirits should always be visible in creative mode.")
    public static boolean alwaysVisibleInCreative = false;
    @ConfigurableProperty(category="mob", comment="The 1/X chance that an actual spirit will spawn when doing actions like mining with the Vengeance Pickaxe.")
    public static int nonDegradedSpawnChance = 5;

    public EntityVengeanceSpiritConfig() {
        super((ModBase)EvilCraft._instance, "vengeance_spirit", eConfig -> EntityType.Builder.func_220322_a(EntityVengeanceSpirit::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(1.0f, 1.0f).func_220320_c(), EntityVengeanceSpiritConfig.getDefaultSpawnEggItemConfigConstructor((ModBase)EvilCraft._instance, (String)"vengeance_spirit_spawn_egg", (int)Helpers.RGBToInt((int)64, (int)16, (int)93), (int)Helpers.RGBToInt((int)134, (int)60, (int)169)));
    }

    @OnlyIn(value=Dist.CLIENT)
    public EntityRenderer<? super EntityVengeanceSpirit> getRender(EntityRendererManager entityRendererManager, ItemRenderer itemRenderer) {
        return new RenderVengeanceSpirit(entityRendererManager, this);
    }

    public void onRegistered() {
        super.onRegistered();
        EvilCraft._instance.getImcHandler().registerAction("blacklist_vengeance_spirit", message -> {
            Object value = message.getMessageSupplier().get();
            if (value instanceof String) {
                EntityVengeanceSpirit.addToBlacklistIMC((String)value);
                return true;
            }
            return false;
        });
    }

    public void onForgeRegistered() {
        super.onForgeRegistered();
        GlobalEntityTypeAttributes.put((EntityType)((EntityType)this.getInstance()), (AttributeModifierMap)MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233819_b_, 10.0).func_233815_a_(Attributes.field_233818_a_, 10.0).func_233815_a_(Attributes.field_233821_d_, 0.3125).func_233815_a_(Attributes.field_233823_f_, 4.0).func_233813_a_());
    }
}

