/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.entity.monster;

import java.util.Optional;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.villager.VillagerType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Difficulty;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.cyclops.evilcraft.RegistryEntries;

public class EntityWerewolf
extends MonsterEntity {
    private CompoundNBT villagerNBTTagCompound = new CompoundNBT();
    private boolean fromVillager = false;
    private static final int BARKCHANCE = 1000;
    private static final int BARKLENGTH = 40;
    private static int barkprogress;

    public EntityWerewolf(EntityType<? extends EntityWerewolf> type, World world) {
        super(type, world);
    }

    public EntityWerewolf(World world) {
        super(RegistryEntries.ENTITY_WEREWOLF, world);
        this.field_70138_W = 1.0f;
        this.villagerNBTTagCompound.func_74778_a("ProfessionName", RegistryEntries.VILLAGER_PROFESSION_WEREWOLF.getRegistryName().toString());
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(2, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new RandomWalkingGoal((CreatureEntity)this, 0.6));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, false));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void transformWerewolfVillager(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntity() instanceof VillagerEntity && !event.getEntity().field_70170_p.func_201670_d()) {
            VillagerEntity villager = (VillagerEntity)event.getEntity();
            if (EntityWerewolf.isWerewolfTime(event.getEntity().field_70170_p) && villager.func_213700_eh().func_221130_b() == RegistryEntries.VILLAGER_PROFESSION_WEREWOLF && villager.field_70170_p.func_226658_a_(LightType.SKY, villager.func_233580_cy_()) > 0) {
                EntityWerewolf.replaceVillager(villager);
            }
        }
    }

    protected float func_70647_i() {
        return super.func_70647_i() * 0.75f;
    }

    public void func_213281_b(CompoundNBT NBTTagCompound) {
        super.func_213281_b(NBTTagCompound);
        NBTTagCompound.func_218657_a("villager", (INBT)this.villagerNBTTagCompound);
        NBTTagCompound.func_74757_a("fromVillager", this.fromVillager);
    }

    public void func_70037_a(CompoundNBT NBTTagCompound) {
        super.func_70037_a(NBTTagCompound);
        this.villagerNBTTagCompound = NBTTagCompound.func_74775_l("villager");
        this.fromVillager = NBTTagCompound.func_74767_n("fromVillager");
    }

    public static boolean isWerewolfTime(World world) {
        return (double)world.func_242413_ae() == 1.0 && !world.func_72935_r() && world.func_175659_aa() != Difficulty.PEACEFUL;
    }

    private static void replaceEntity(MobEntity old, MobEntity neww, World world) {
        neww.func_82149_j((Entity)old);
        old.func_70106_y();
        world.func_217376_c((Entity)neww);
        world.func_217378_a(null, 1016, old.func_233580_cy_(), 0);
    }

    public void replaceWithVillager() {
        VillagerEntity villager = new VillagerEntity(EntityType.field_200756_av, this.field_70170_p, VillagerType.func_242371_a((Optional)this.field_70170_p.func_242406_i(this.func_233580_cy_())));
        EntityWerewolf.initializeWerewolfVillagerData(villager);
        EntityWerewolf.replaceEntity((MobEntity)this, (MobEntity)villager, this.field_70170_p);
        try {
            villager.func_70037_a(this.villagerNBTTagCompound);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
    }

    public static void initializeWerewolfVillagerData(VillagerEntity villager) {
        villager.func_213753_a(villager.func_213700_eh().func_221135_a(2).func_221126_a(RegistryEntries.VILLAGER_PROFESSION_WEREWOLF));
    }

    public static void replaceVillager(VillagerEntity villager) {
        EntityWerewolf werewolf = new EntityWerewolf(villager.field_70170_p);
        villager.func_213281_b(werewolf.getVillagerNBTTagCompound());
        werewolf.setFromVillager(true);
        EntityWerewolf.replaceEntity((MobEntity)villager, (MobEntity)werewolf, villager.field_70170_p);
    }

    public void func_70636_d() {
        if (!(this.field_70170_p.func_201670_d() || EntityWerewolf.isWerewolfTime(this.field_70170_p) && this.field_70170_p.func_175659_aa() != Difficulty.PEACEFUL)) {
            this.replaceWithVillager();
        } else {
            super.func_70636_d();
        }
        Random random = this.field_70170_p.field_73012_v;
        if (random.nextInt(1000) == 0 && barkprogress == -1) {
            ++barkprogress;
        } else if (barkprogress > -1) {
            this.func_184185_a(SoundEvents.field_187861_gG, 0.15f, 1.0f);
            if (++barkprogress > 40) {
                barkprogress = -1;
            }
        }
    }

    public float getBarkProgressScaled(float scale) {
        if (barkprogress == -1) {
            return 0.0f;
        }
        return (float)barkprogress / 40.0f * scale;
    }

    public ResourceLocation func_184647_J() {
        return new ResourceLocation("evilcraft", "entities/werewolf");
    }

    public SoundEvent func_184639_G() {
        return SoundEvents.field_187861_gG;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return SoundEvents.field_187863_gH;
    }

    public SoundEvent func_184615_bR() {
        return SoundEvents.field_187859_gF;
    }

    protected void func_180429_a(BlockPos blockPos, BlockState block) {
        this.func_184185_a(SoundEvents.field_187939_hm, 0.15f, 1.0f);
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223224_c_;
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return super.func_213397_c(distanceToClosestPlayer) && !this.isFromVillager();
    }

    public CompoundNBT getVillagerNBTTagCompound() {
        return this.villagerNBTTagCompound;
    }

    public boolean isFromVillager() {
        return this.fromVillager;
    }

    public void setFromVillager(boolean fromVillager) {
        this.fromVillager = fromVillager;
    }

    static {
        MinecraftForge.EVENT_BUS.register(EntityWerewolf.class);
        barkprogress = -1;
    }
}

