/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.event;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraftforge.event.entity.EntityStruckByLightningEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.entity.monster.EntityWerewolf;
import org.cyclops.evilcraft.item.IItemEmpowerable;

public class EntityStruckByLightningEventHook {
    private LightningBoltEntity lastLightningBolt;
    private Set<VillagerEntity> affectedVillagers;

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onEntityStruckByLightning(EntityStruckByLightningEvent event) {
        this.empowerItem(event);
        this.transformVillager(event);
    }

    private void empowerItem(EntityStruckByLightningEvent event) {
        IItemEmpowerable empowerable;
        ItemEntity entity;
        if (event.getEntity() instanceof ItemEntity && (entity = (ItemEntity)event.getEntity()).func_92059_d().func_77973_b() instanceof IItemEmpowerable && !(empowerable = (IItemEmpowerable)entity.func_92059_d().func_77973_b()).isEmpowered(entity.func_92059_d())) {
            entity.func_92058_a(empowerable.empower(entity.func_92059_d()));
            event.setCanceled(true);
            event.getLightning().func_70106_y();
        }
    }

    private void transformVillager(EntityStruckByLightningEvent event) {
        if (event.getEntity() instanceof VillagerEntity) {
            VillagerEntity entity = (VillagerEntity)event.getEntity();
            if (this.lastLightningBolt != event.getLightning()) {
                this.lastLightningBolt = event.getLightning();
                this.affectedVillagers = new HashSet<VillagerEntity>();
            }
            if (!this.affectedVillagers.add(entity)) {
                event.setCanceled(true);
                return;
            }
            if (entity.func_213700_eh().func_221130_b() != RegistryEntries.VILLAGER_PROFESSION_WEREWOLF) {
                EntityWerewolf.initializeWerewolfVillagerData(entity);
            }
            if (entity.func_190670_t_().field_73012_v.nextBoolean()) {
                event.setCanceled(true);
            }
        }
    }
}

