/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.event;

import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.cyclops.cyclopscore.helper.FluidHelpers;
import org.cyclops.cyclopscore.helper.RenderHelpers;
import org.cyclops.cyclopscore.helper.WorldHelpers;
import org.cyclops.cyclopscore.inventory.PlayerExtendedInventoryIterator;
import org.cyclops.evilcraft.GeneralConfig;
import org.cyclops.evilcraft.core.algorithm.Wrapper;
import org.cyclops.evilcraft.core.fluid.BloodFluidConverter;

public class RenderOverlayEventHook {
    private static final int WIDTH = 5;
    private static final int HEIGHT = 51;
    protected static final ResourceLocation BLOOD_OVERLAY = new ResourceLocation("evilcraft", "textures/gui/overlay.png");
    private int filledHeight = -1;

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onRenderOverlayEvent(RenderGameOverlayEvent.Post event) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (GeneralConfig.bloodGuiOverlay && event.getType() == RenderGameOverlayEvent.ElementType.ALL) {
            if (this.filledHeight < 0 || WorldHelpers.efficientTick((World)player.field_70170_p, (int)50, (int[])new int[0])) {
                Wrapper<Integer> amount = new Wrapper<Integer>(0);
                Wrapper<Integer> capacity = new Wrapper<Integer>(1);
                PlayerExtendedInventoryIterator it = new PlayerExtendedInventoryIterator((PlayerEntity)player);
                while (it.hasNext()) {
                    ItemStack itemStack = it.next();
                    IFluidHandler fluidHandler = (IFluidHandler)FluidUtil.getFluidHandler((ItemStack)itemStack).orElse(null);
                    if (itemStack.func_190926_b() || fluidHandler == null) continue;
                    FluidStack fluidStack = FluidHelpers.getFluid((IFluidHandler)fluidHandler);
                    if (!fluidStack.isEmpty() && BloodFluidConverter.getInstance().canConvert(fluidStack.getFluid())) {
                        amount.set(amount.get() + fluidStack.getAmount());
                    }
                    if (!fluidStack.isEmpty() && !BloodFluidConverter.getInstance().canConvert(fluidStack.getFluid())) continue;
                    capacity.set(capacity.get() + FluidHelpers.getCapacity((IFluidHandler)fluidHandler));
                }
                this.filledHeight = (int)Math.floor(51.0f * ((float)amount.get().intValue() / (float)capacity.get().intValue()));
            }
            if (this.filledHeight > 0) {
                OverlayPosition overlayPosition = OverlayPosition.values()[MathHelper.func_76125_a((int)GeneralConfig.bloodGuiOverlayPosition, (int)0, (int)(OverlayPosition.values().length - 1))];
                MainWindow resolution = event.getWindow();
                int x = overlayPosition.getX(resolution, 5, 51) + GeneralConfig.bloodGuiOverlayPositionOffsetX;
                int y = overlayPosition.getY(resolution, 5, 51) + GeneralConfig.bloodGuiOverlayPositionOffsetY;
                GlStateManager.func_227626_N_();
                GlStateManager.func_227740_m_();
                GlStateManager.func_227676_b_((int)770, (int)771);
                RenderHelpers.bindTexture((ResourceLocation)BLOOD_OVERLAY);
                Minecraft.func_71410_x().field_71456_v.func_238474_b_(event.getMatrixStack(), x, y, 0, 0, 5, 51);
                Minecraft.func_71410_x().field_71456_v.func_238474_b_(event.getMatrixStack(), x, y + (51 - this.filledHeight), 5, 51 - this.filledHeight, 5, this.filledHeight);
                GlStateManager.func_227737_l_();
                GlStateManager.func_227627_O_();
            }
        }
    }

    public static enum OverlayPosition {
        NE{

            @Override
            public int getX(MainWindow resolution, int width, int height) {
                return resolution.func_198107_o() - width;
            }

            @Override
            public int getY(MainWindow resolution, int width, int height) {
                return 0;
            }
        }
        ,
        SE{

            @Override
            public int getX(MainWindow resolution, int width, int height) {
                return resolution.func_198107_o() - width;
            }

            @Override
            public int getY(MainWindow resolution, int width, int height) {
                return resolution.func_198087_p() - height;
            }
        }
        ,
        SW{

            @Override
            public int getX(MainWindow resolution, int width, int height) {
                return 0;
            }

            @Override
            public int getY(MainWindow resolution, int width, int height) {
                return resolution.func_198087_p() - height;
            }
        }
        ,
        NW{

            @Override
            public int getX(MainWindow resolution, int width, int height) {
                return 0;
            }

            @Override
            public int getY(MainWindow resolution, int width, int height) {
                return 0;
            }
        };


        public abstract int getX(MainWindow var1, int var2, int var3);

        public abstract int getY(MainWindow var1, int var2, int var3);
    }
}

