/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.inventory.container;

import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Slot;
import org.cyclops.cyclopscore.inventory.slot.SlotFluidContainer;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.core.inventory.container.ContainerTileWorking;
import org.cyclops.evilcraft.core.tileentity.TileWorking;
import org.cyclops.evilcraft.inventory.slot.SlotRepairable;
import org.cyclops.evilcraft.tileentity.TileColossalBloodChest;

public class ContainerColossalBloodChest
extends ContainerTileWorking<TileColossalBloodChest> {
    private static final int INVENTORY_OFFSET_X = 28;
    private static final int INVENTORY_OFFSET_Y = 107;
    private static final int ARMOR_INVENTORY_OFFSET_X = 192;
    private static final int ARMOR_INVENTORY_OFFSET_Y = 109;
    private static final int CHEST_INVENTORY_OFFSET_X = 59;
    private static final int CHEST_INVENTORY_OFFSET_Y = 13;
    public static final int CHEST_INVENTORY_ROWS = 5;
    public static final int CHEST_INVENTORY_COLUMNS = 9;
    public static final int SLOT_CONTAINER_X = 6;
    public static final int SLOT_CONTAINER_Y = 46;
    private static final int UPGRADE_INVENTORY_OFFSET_X = -22;
    private static final int UPGRADE_INVENTORY_OFFSET_Y = 6;
    private final Supplier<Integer> variableEfficiency;

    public ContainerColossalBloodChest(int id, PlayerInventory playerInventory) {
        this(id, playerInventory, (IInventory)new Inventory(50), Optional.empty());
    }

    public ContainerColossalBloodChest(int id, PlayerInventory playerInventory, IInventory inventory, Optional<TileColossalBloodChest> tileSupplier) {
        super(RegistryEntries.CONTAINER_COLOSSAL_BLOOD_CHEST, id, playerInventory, inventory, tileSupplier, TileColossalBloodChest.TICKERS, 4);
        this.func_75146_a((Slot)new SlotFluidContainer(inventory, 45, 6, 46, (Fluid)RegistryEntries.FLUID_BLOOD));
        this.addChestSlots(5, 9);
        this.addUpgradeInventory(-22, 6, 46);
        this.addPlayerInventory(playerInventory, 28, 107);
        this.addPlayerArmorInventory(playerInventory, 192, 109);
        this.variableEfficiency = this.registerSyncedVariable(Integer.class, () -> ((TileColossalBloodChest)this.getTileSupplier().get()).getEfficiency());
    }

    public int getEfficiency() {
        return this.variableEfficiency.get();
    }

    protected void addChestSlots(int rows, int columns) {
        for (int row = 0; row < rows; ++row) {
            for (int column = 0; column < columns; ++column) {
                this.func_75146_a(this.makeSlot(this.inventory, column + row * columns, 59 + column * 18, 13 + row * 18));
            }
        }
    }

    protected Slot makeSlot(IInventory inventory, int index, int row, int column) {
        return new SlotRepairable(inventory, index, row, column);
    }

    @Override
    public TileWorking.Metadata getTileWorkingMetadata() {
        return TileColossalBloodChest.METADATA;
    }
}

