/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.inventory.container;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.CraftResultInventory;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.CraftingResultSlot;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SSetSlotPacket;
import net.minecraft.util.Hand;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.helper.InventoryHelpers;
import org.cyclops.cyclopscore.inventory.container.ItemInventoryContainer;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.core.inventory.NBTCraftingGrid;
import org.cyclops.evilcraft.item.ItemExaltedCrafter;
import org.cyclops.evilcraft.item.ItemExaltedCrafterConfig;

public class ContainerExaltedCrafter
extends ItemInventoryContainer<ItemExaltedCrafter> {
    private static final int GRID_OFFSET_X = 30;
    private static final int GRID_OFFSET_Y = 17;
    private static final int GRID_ROWS = 3;
    private static final int GRID_COLUMNS = 3;
    private static final int CHEST_INVENTORY_OFFSET_X = 8;
    private static final int CHEST_INVENTORY_OFFSET_Y = 84;
    private static final int CHEST_INVENTORY_ROWS = 3;
    private static final int CHEST_INVENTORY_COLUMNS = 9;
    private static final int INVENTORY_OFFSET_X = 8;
    private static final int INVENTORY_OFFSET_Y = 143;
    public static final String BUTTON_CLEAR = "clear";
    public static final String BUTTON_BALANCE = "balance";
    public static final String BUTTON_TOGGLERETURN = "toggleReturn";
    private final World world;
    private final NBTCraftingGrid craftingGrid;
    private final CraftResultInventory result;
    private boolean initialized = false;

    public ContainerExaltedCrafter(int id, PlayerInventory inventory, PacketBuffer packetBuffer) {
        this(id, inventory, ContainerExaltedCrafter.readItemIndex((PacketBuffer)packetBuffer), ContainerExaltedCrafter.readHand((PacketBuffer)packetBuffer));
    }

    public ContainerExaltedCrafter(int id, PlayerInventory inventory, int itemIndex, Hand hand) {
        super(RegistryEntries.CONTAINER_EXALTED_CRAFTER, id, inventory, itemIndex, hand);
        this.world = this.player.field_70170_p;
        this.result = new CraftResultInventory();
        this.craftingGrid = new NBTCraftingGrid(this.player, itemIndex, hand, (Container)this);
        this.addCraftingGrid(this.player, this.craftingGrid);
        this.addInventory(((ItemExaltedCrafter)this.getItem()).getSupplementaryInventory(this.player, InventoryHelpers.getItemFromIndex((PlayerEntity)this.player, (int)itemIndex, (Hand)hand), itemIndex, hand), 0, 8, 84, 3, 9);
        this.addPlayerInventory(this.player.field_71071_by, 8, 143);
        this.initialized = true;
        this.func_75130_a((IInventory)this.craftingGrid);
        this.putButtonAction(BUTTON_CLEAR, (buttonId, container) -> this.clearGrid());
        this.putButtonAction(BUTTON_BALANCE, (buttonId, container) -> this.balanceGrid());
        this.putButtonAction(BUTTON_TOGGLERETURN, (buttonId, container) -> ((ContainerExaltedCrafter)container).setReturnToInnerInventory(!((ContainerExaltedCrafter)container).isReturnToInnerInventory()));
    }

    public void clearGrid() {
        for (int i = 0; i < this.craftingGrid.func_70302_i_(); ++i) {
            this.func_82846_b(this.player, i);
        }
    }

    public void balanceGrid() {
        ArrayList bins = Lists.newArrayListWithExpectedSize((int)this.craftingGrid.func_70302_i_());
        for (int slot = 0; slot < this.craftingGrid.func_70302_i_(); ++slot) {
            ItemStack itemStack = this.craftingGrid.func_70301_a(slot);
            if (itemStack.func_190926_b()) continue;
            int amount = itemStack.func_190916_E();
            itemStack = itemStack.func_77946_l();
            itemStack.func_190920_e(1);
            boolean addedToBin = false;
            for (int bin = 0; bin < bins.size() && !addedToBin; ++bin) {
                Pair pair = (Pair)bins.get(bin);
                ItemStack original = ((ItemStack)pair.getLeft()).func_77946_l();
                original.func_190920_e(1);
                if (!ItemStack.func_77989_b((ItemStack)original, (ItemStack)itemStack)) continue;
                ((ItemStack)pair.getLeft()).func_190917_f(amount);
                ((List)pair.getRight()).add(new MutablePair((Object)slot, (Object)0));
                addedToBin = true;
            }
            if (addedToBin) continue;
            itemStack.func_190920_e(amount);
            bins.add(new MutablePair((Object)itemStack, (Object)Lists.newArrayList((Object[])new Pair[]{new MutablePair((Object)slot, (Object)0)})));
        }
        for (Pair pair : bins) {
            int division = ((ItemStack)pair.getLeft()).func_190916_E() / ((List)pair.getRight()).size();
            int modulus = ((ItemStack)pair.getLeft()).func_190916_E() % ((List)pair.getRight()).size();
            for (Pair slot : (List)pair.getRight()) {
                slot.setValue((Object)(division + Math.max(0, Math.min(1, modulus--))));
            }
        }
        for (Pair pair : bins) {
            for (Pair slot : (List)pair.getRight()) {
                ItemStack itemStack = ((ItemStack)pair.getKey()).func_77946_l();
                itemStack.func_190920_e(((Integer)slot.getRight()).intValue());
                this.craftingGrid.func_70299_a((Integer)slot.getKey(), itemStack);
            }
        }
    }

    public boolean isReturnToInnerInventory() {
        ItemStack itemStack = this.getItemStack(this.player);
        return !itemStack.func_190926_b() && ItemExaltedCrafter.isReturnToInner(itemStack);
    }

    protected void setReturnToInnerInventory(boolean returnToInner) {
        ItemStack itemStack = this.getItemStack(this.player);
        if (!itemStack.func_190926_b()) {
            ItemExaltedCrafter.setReturnToInner(itemStack, returnToInner);
        }
    }

    protected int getSlotStart(int originSlot, int slotStart, boolean reverse) {
        if (!reverse && !ItemExaltedCrafterConfig.shiftCraftingGrid) {
            return 10;
        }
        if (reverse && originSlot < 10) {
            if (this.isReturnToInnerInventory()) {
                return 10;
            }
            return slotStart;
        }
        return super.getSlotStart(originSlot, slotStart, reverse);
    }

    protected int getSlotRange(int originSlot, int slotRange, boolean reverse) {
        if (this.isReturnToInnerInventory() && reverse && originSlot < 10) {
            return this.getSizeInventory();
        }
        return slotRange;
    }

    protected void addCraftingGrid(PlayerEntity player, NBTCraftingGrid grid) {
        this.addInventory((IInventory)grid, 0, 30, 17, 3, 3);
        this.func_75146_a((Slot)new CraftingResultSlot(player, (CraftingInventory)grid, (IInventory)this.result, 0, 124, 35));
    }

    protected int getSizeInventory() {
        return 37;
    }

    public void func_75130_a(IInventory inventory) {
        if (this.initialized && !this.world.func_201670_d()) {
            ItemStack itemstack = ItemStack.field_190927_a;
            ICraftingRecipe irecipe = this.world.func_73046_m().func_199529_aN().func_215371_a(IRecipeType.field_222149_a, (IInventory)this.craftingGrid, this.world).orElse(null);
            if (irecipe != null && this.result.func_201561_a(this.world, (ServerPlayerEntity)this.player, (IRecipe)irecipe)) {
                itemstack = irecipe.func_77572_b((IInventory)this.craftingGrid);
            }
            this.result.func_70299_a(0, itemstack);
            ((ServerPlayerEntity)this.player).field_71135_a.func_147359_a((IPacket)new SSetSlotPacket(this.field_75152_c, 9, itemstack));
            this.craftingGrid.save();
        }
    }
}

