/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.item;

import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemModelsProperties;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.helper.WorldHelpers;
import org.cyclops.evilcraft.EvilCraftSoundEvents;

public abstract class ItemAbstractFocus
extends Item {
    private static final int TICK_MODULUS = 3;

    public ItemAbstractFocus(Item.Properties properties) {
        super(properties);
        if (MinecraftHelpers.isClientSide()) {
            this.registerProperties();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void registerProperties() {
        ItemModelsProperties.func_239418_a_((Item)this, (ResourceLocation)new ResourceLocation("pull"), (IItemPropertyGetter)new IItemPropertyGetter(){

            @OnlyIn(value=Dist.CLIENT)
            public float call(ItemStack stack, ClientWorld worldIn, LivingEntity entityIn) {
                if (entityIn == null) {
                    return 0.0f;
                }
                ItemStack itemStack = entityIn.func_184607_cu();
                return !itemStack.func_190926_b() && itemStack.func_77973_b() instanceof ItemAbstractFocus ? (float)(stack.func_77988_m() - entityIn.func_184605_cv()) / 20.0f : 0.0f;
            }
        });
        ItemModelsProperties.func_239418_a_((Item)this, (ResourceLocation)new ResourceLocation("pulling"), (IItemPropertyGetter)new IItemPropertyGetter(){

            @OnlyIn(value=Dist.CLIENT)
            public float call(ItemStack stack, ClientWorld worldIn, LivingEntity entityIn) {
                return entityIn != null && entityIn.func_184587_cr() && entityIn.func_184607_cu() == stack ? 1.0f : 0.0f;
            }
        });
    }

    private int getItemInUseDuration(LivingEntity player) {
        return Math.max(0, player.func_184612_cw() - player.func_184605_cv());
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack itemStack = player.func_184586_b(hand);
        if (this.getItemInUseDuration((LivingEntity)player) > 0) {
            return new ActionResult(ActionResultType.FAIL, (Object)itemStack);
        }
        player.func_184598_c(hand);
        return MinecraftHelpers.successAction((Object)itemStack);
    }

    public UseAction func_77661_b(ItemStack itemStack) {
        return UseAction.BOW;
    }

    public int func_77626_a(ItemStack itemStack) {
        return Integer.MAX_VALUE;
    }

    public void func_77615_a(ItemStack itemStack, World world, LivingEntity player, int duration) {
        if (player.field_70170_p.func_201670_d() && this.getItemInUseDuration(player) > 6) {
            player.func_184185_a(EvilCraftSoundEvents.effect_vengeancebeam_stop, 0.6f + player.field_70170_p.field_73012_v.nextFloat() * 0.2f, 1.0f);
        }
    }

    protected abstract ThrowableEntity newBeamEntity(LivingEntity var1);

    public void onUsingTick(ItemStack itemStack, LivingEntity player, int remaining) {
        int duration = this.func_77626_a(itemStack) - remaining;
        if (duration > 6) {
            if (WorldHelpers.efficientTick((World)player.field_70170_p, (int)3, (int[])new int[]{player.func_145782_y()})) {
                ThrowableEntity beam = this.newBeamEntity(player);
                if (!player.field_70170_p.func_201670_d()) {
                    beam.func_234612_a_((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, 0.5f, 1.0f);
                    player.field_70170_p.func_217376_c((Entity)beam);
                }
            }
        } else if (duration == 3 && player.field_70170_p.func_201670_d()) {
            player.func_184185_a(EvilCraftSoundEvents.effect_vengeancebeam_start, 0.6f + player.field_70170_p.field_73012_v.nextFloat() * 0.2f, 1.0f);
        }
    }
}

