/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.item;

import java.util.List;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.helper.ItemStackHelpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.evilcraft.entity.item.EntityBiomeExtract;
import org.cyclops.evilcraft.item.ItemBiomeExtractConfig;

public class ItemBiomeExtract
extends Item {
    private static final String NBT_BIOMEKEY = "biomeKey";

    public ItemBiomeExtract(Item.Properties properties) {
        super(properties);
    }

    public String func_77667_c(ItemStack itemStack) {
        return super.func_77667_c(itemStack) + (ItemBiomeExtract.getBiome(itemStack) == null ? ".empty" : "");
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.BOW;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack itemStack = player.func_184586_b(hand);
        if (!world.func_201670_d() && ItemBiomeExtract.getBiome(itemStack) != null && !ItemBiomeExtractConfig.isUsageBlacklisted(ItemBiomeExtract.getBiome(itemStack))) {
            world.func_184148_a(player, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), new SoundEvent(new ResourceLocation("random.bow")), SoundCategory.PLAYERS, 0.5f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
            EntityBiomeExtract entity = new EntityBiomeExtract(world, (LivingEntity)player, itemStack.func_77946_l());
            entity.func_234612_a_((Entity)player, player.field_70125_A, player.field_70177_z, -20.0f, 0.5f, 1.0f);
            world.func_217376_c((Entity)entity);
            itemStack.func_190918_g(1);
        }
        return MinecraftHelpers.successAction((Object)itemStack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack itemStack, World world, List<ITextComponent> list, ITooltipFlag flag) {
        super.func_77624_a(itemStack, world, list, flag);
        Biome biome = ItemBiomeExtract.getBiome(itemStack);
        if (biome != null) {
            list.add((ITextComponent)new TranslationTextComponent(this.func_77658_a() + ".info.content", new Object[]{new TranslationTextComponent("biome." + biome.getRegistryName().func_110624_b() + "." + biome.getRegistryName().func_110623_a())}));
        }
    }

    public Iterable<Biome> getBiomes() {
        return ForgeRegistries.BIOMES.getValues();
    }

    public void func_150895_a(ItemGroup creativeTabs, NonNullList<ItemStack> list) {
        if (!ItemStackHelpers.isValidCreativeTab((Item)this, (ItemGroup)creativeTabs)) {
            return;
        }
        super.func_150895_a(creativeTabs, list);
        if (ItemBiomeExtractConfig.creativeTabVariants) {
            for (Biome biome : this.getBiomes()) {
                list.add((Object)this.createItemStack(biome, 1));
            }
        }
    }

    public boolean isEmpty(ItemStack itemStack) {
        return ItemBiomeExtract.getBiome(itemStack) == null;
    }

    public static Biome getBiome(ItemStack itemStack) {
        String biomeName;
        if (itemStack.func_77942_o() && ForgeRegistries.BIOMES.containsKey(new ResourceLocation(biomeName = itemStack.func_77978_p().func_74779_i(NBT_BIOMEKEY)))) {
            return (Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation(biomeName));
        }
        return null;
    }

    public ItemStack createItemStack(Biome biome, int amount) {
        ItemStack itemStack = new ItemStack((IItemProvider)this, amount);
        if (biome != null) {
            CompoundNBT tag = new CompoundNBT();
            tag.func_74778_a(NBT_BIOMEKEY, biome.getRegistryName().toString());
            itemStack.func_77982_d(tag);
        }
        return itemStack;
    }

    public Rarity func_77613_e(ItemStack itemStack) {
        Biome biome = ItemBiomeExtract.getBiome(itemStack);
        if (biome == null) {
            return Rarity.COMMON;
        }
        return biome.func_242433_b().func_242557_a() <= 0.05f ? Rarity.EPIC : (biome.func_242433_b().func_242557_a() <= 0.1f ? Rarity.RARE : Rarity.UNCOMMON);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class ItemColor
    implements IItemColor {
        public int getColor(ItemStack itemStack, int renderPass) {
            if (renderPass == 0) {
                Biome biome = ItemBiomeExtract.getBiome(itemStack);
                if (biome != null) {
                    return biome.func_225527_a_();
                }
                return Helpers.RGBToInt((int)125, (int)125, (int)125);
            }
            return 0xFFFFFF;
        }
    }
}

