/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.item;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.item.Item;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.cyclops.cyclopscore.config.ConfigurableProperty;
import org.cyclops.cyclopscore.config.extendedconfig.ItemConfig;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.evilcraft.EvilCraft;
import org.cyclops.evilcraft.item.ItemBiomeExtract;

public class ItemBiomeExtractConfig
extends ItemConfig {
    @ConfigurableProperty(category="item", comment="If creative versions for all variants should be added to the creative tab.", requiresMcRestart=true)
    public static boolean creativeTabVariants = true;
    @ConfigurableProperty(category="item", comment="A list of biome names for which no Biome Extracts may be created.")
    public static List<String> craftingBlacklist = Lists.newArrayList();
    @ConfigurableProperty(category="item", comment="A list of biome names for which no Biome Extracts may be used.")
    public static List<String> usageBlacklist = Lists.newArrayList();

    public ItemBiomeExtractConfig() {
        super((ModBase)EvilCraft._instance, "biome_extract", eConfig -> new ItemBiomeExtract(new Item.Properties().func_200916_a(EvilCraft._instance.getDefaultItemGroup())));
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)this);
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onModLoaded(FMLLoadCompleteEvent event) {
        Minecraft.func_71410_x().getItemColors().func_199877_a((IItemColor)new ItemBiomeExtract.ItemColor(), new IItemProvider[]{(IItemProvider)this.getInstance()});
    }

    public static boolean isCraftingBlacklisted(Biome biome) {
        return craftingBlacklist.contains(biome.getRegistryName().toString());
    }

    public static boolean isUsageBlacklisted(Biome biome) {
        return usageBlacklist.contains(biome.getRegistryName().toString());
    }
}

