/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.cyclops.cyclopscore.item.ItemBlockNBT;
import org.cyclops.evilcraft.block.BlockBoxOfEternalClosure;
import org.cyclops.evilcraft.tileentity.TileBoxOfEternalClosure;

public class ItemBlockBoxOfEternalClosure
extends ItemBlockNBT {
    public ItemBlockBoxOfEternalClosure(Block block, Item.Properties builder) {
        super(block, builder);
    }

    protected boolean itemStackDataToTile(ItemStack itemStack, TileEntity tile) {
        if (tile instanceof TileBoxOfEternalClosure && itemStack.func_77942_o()) {
            ((TileBoxOfEternalClosure)tile).setSpiritTag(itemStack.func_77978_p().func_74775_l("spiritTag"));
            ((TileBoxOfEternalClosure)tile).setPlayerId(itemStack.func_77978_p().func_74779_i("playerId"));
            ((TileBoxOfEternalClosure)tile).setPlayerName(itemStack.func_77978_p().func_74779_i("playerName"));
            ((TileBoxOfEternalClosure)tile).initializeState();
        }
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add(this.getInfo(stack));
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    @OnlyIn(value=Dist.CLIENT)
    public ITextComponent getInfo(ItemStack itemStack) {
        IFormattableTextComponent content = new TranslationTextComponent("general.evilcraft.info.empty").func_240699_a_(TextFormatting.ITALIC);
        if (BlockBoxOfEternalClosure.hasPlayer(itemStack)) {
            content = new StringTextComponent(BlockBoxOfEternalClosure.getPlayerName(itemStack));
        } else {
            EntityType<?> spiritType = BlockBoxOfEternalClosure.getSpiritTypeWithFallbackSpirit(itemStack);
            if (spiritType != null) {
                content = spiritType.func_212546_e();
            }
        }
        return new TranslationTextComponent(this.func_77658_a() + ".info.content").func_240699_a_(TextFormatting.LIGHT_PURPLE).func_230529_a_((ITextComponent)content);
    }
}

