/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.item;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.helper.TileHelpers;
import org.cyclops.cyclopscore.inventory.PlayerInventoryIterator;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.block.BlockBloodStain;
import org.cyclops.evilcraft.client.particle.ParticleBloodSplash;
import org.cyclops.evilcraft.core.helper.ItemHelpers;
import org.cyclops.evilcraft.core.item.ItemBloodContainer;
import org.cyclops.evilcraft.item.ItemBloodExtractorConfig;
import org.cyclops.evilcraft.item.ItemVeinSword;
import org.cyclops.evilcraft.item.ItemVeinSwordConfig;

public class ItemBloodExtractor
extends ItemBloodContainer {
    public ItemBloodExtractor(Item.Properties properties) {
        super(properties, ItemBloodExtractorConfig.containerSize);
        this.setPlaceFluids(true);
        MinecraftForge.EVENT_BUS.addListener(this::bloodObtainEvent);
    }

    @Override
    public ActionResultType onItemUseFirst(ItemStack itemStack, ItemUseContext context) {
        Block block = context.func_195991_k().func_180495_p(context.func_195995_a()).func_177230_c();
        if (context.func_195999_j().func_213453_ef() && block instanceof BlockBloodStain) {
            Random random = context.func_195991_k().field_73012_v;
            TileHelpers.getCapability((IBlockReader)context.func_195991_k(), (BlockPos)context.func_195995_a(), (Capability)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).ifPresent(source -> {
                FluidStack moved = FluidUtil.tryFluidTransfer((IFluidHandler)((IFluidHandler)FluidUtil.getFluidHandler((ItemStack)itemStack).orElse(null)), (IFluidHandler)source, (int)Integer.MAX_VALUE, (boolean)true);
                if (!moved.isEmpty() && context.func_195991_k().func_201670_d()) {
                    ParticleBloodSplash.spawnParticles(context.func_195991_k(), context.func_195995_a(), 5, 1 + random.nextInt(2));
                }
            });
            return ActionResultType.PASS;
        }
        return ActionResultType.PASS;
    }

    public boolean func_77636_d(ItemStack itemStack) {
        return ItemHelpers.isActivated(itemStack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack itemStack, World world, List<ITextComponent> list, ITooltipFlag flag) {
        super.func_77624_a(itemStack, world, list, flag);
        L10NHelpers.addStatusInfo(list, (boolean)ItemHelpers.isActivated(itemStack), (String)(this.func_77658_a() + ".info.auto_supply"));
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack itemStack = player.func_184586_b(hand);
        if (!player.func_213453_ef()) {
            return super.func_77659_a(world, player, hand);
        }
        BlockRayTraceResult target = ItemBloodExtractor.func_219968_a((World)world, (PlayerEntity)player, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.ANY);
        if (!(target != null && target.func_216346_c() != RayTraceResult.Type.MISS || world.func_201670_d())) {
            ItemHelpers.toggleActivation(itemStack);
        }
        return MinecraftHelpers.successAction((Object)itemStack);
    }

    public static void fillForAllBloodExtractors(PlayerEntity player, int minimumMB, int maximumMB) {
        int toFill = minimumMB + field_77697_d.nextInt(Math.max(1, maximumMB - minimumMB));
        PlayerInventoryIterator it = new PlayerInventoryIterator(player);
        while (it.hasNext() && toFill > 0) {
            ItemStack itemStack = it.next();
            if (itemStack.func_190926_b() || !(itemStack.func_77973_b() instanceof ItemBloodExtractor)) continue;
            IFluidHandlerItem fluidHandler = (IFluidHandlerItem)FluidUtil.getFluidHandler((ItemStack)itemStack).orElse(null);
            toFill -= fluidHandler.fill(new FluidStack((Fluid)RegistryEntries.FLUID_BLOOD, toFill), IFluidHandler.FluidAction.EXECUTE);
            it.replace(fluidHandler.getContainer());
        }
    }

    public void func_77663_a(ItemStack itemStack, World world, Entity entity, int itemSlot, boolean par5) {
        if (ItemHelpers.isActivated(itemStack)) {
            ItemHelpers.updateAutoFill((IFluidHandlerItem)FluidUtil.getFluidHandler((ItemStack)itemStack).orElse(null), world, entity, ItemBloodExtractorConfig.autoFillBuckets);
        }
        super.func_77663_a(itemStack, world, entity, itemSlot, par5);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return oldStack.func_77973_b() != newStack.func_77973_b();
    }

    public void bloodObtainEvent(LivingDeathEvent event) {
        Entity e = event.getSource().func_76346_g();
        if (e != null && e instanceof ServerPlayerEntity && !e.field_70170_p.func_201670_d() && event.getEntityLiving() != null) {
            float boost = 1.0f;
            ServerPlayerEntity player = (ServerPlayerEntity)e;
            Hand hand = player.func_184600_cs();
            if (player.func_184586_b(hand) != null && player.func_184586_b(hand).func_77973_b() instanceof ItemVeinSword) {
                boost = (float)ItemVeinSwordConfig.extractionBoost;
            }
            float health = event.getEntityLiving().func_110138_aP();
            int minimumMB = MathHelper.func_76141_d((float)(health * (float)ItemBloodExtractorConfig.minimumMobMultiplier * boost));
            int maximumMB = MathHelper.func_76141_d((float)(health * (float)ItemBloodExtractorConfig.maximumMobMultiplier * boost));
            ItemBloodExtractor.fillForAllBloodExtractors((PlayerEntity)player, minimumMB, maximumMB);
        }
    }
}

