/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.item;

import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.evilcraft.RegistryEntries;

public class ItemBowlOfPromises
extends Item {
    private final Type type;

    public ItemBowlOfPromises(Item.Properties properties, Type type) {
        super(properties);
        this.type = type;
    }

    public ItemStack getContainerItem(ItemStack itemStack) {
        if (this.type.isActive()) {
            return new ItemStack((IItemProvider)RegistryEntries.ITEM_BOWL_OF_PROMISES_EMPTY);
        }
        return super.getContainerItem(itemStack);
    }

    public boolean hasContainerItem(ItemStack itemStack) {
        return this.type.isActive();
    }

    public static enum Type {
        EMPTY("empty", false, 0),
        DUSTED("dusted", false, 0),
        TIER0("tier0", true, 0),
        TIER1("tier1", true, 1),
        TIER2("tier2", true, 2),
        TIER3("tier3", true, 3);

        private final String name;
        private final boolean active;
        private final int tier;

        private Type(String name, boolean active, int tier) {
            this.name = name;
            this.active = active;
            this.tier = tier;
        }

        public String getName() {
            return this.name;
        }

        public boolean isActive() {
            return this.active;
        }

        public int getTier() {
            return this.tier;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class ItemColor
    implements IItemColor {
        public int getColor(ItemStack itemStack, int renderPass) {
            if (((ItemBowlOfPromises)itemStack.func_77973_b()).type.isActive() && renderPass == 0) {
                float division = (float)(Type.values().length - 2 - ((ItemBowlOfPromises)itemStack.func_77973_b()).type.getTier() - 1) / 3.0f + 1.0f;
                int channel = (int)(255.0f / division);
                return Helpers.RGBToInt((int)channel, (int)channel, (int)channel);
            }
            return -1;
        }
    }
}

