/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.item;

import com.google.common.collect.Sets;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Rarity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.helper.FluidHelpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.helper.RenderHelpers;
import org.cyclops.cyclopscore.helper.TileHelpers;
import org.cyclops.evilcraft.api.broom.BroomModifier;
import org.cyclops.evilcraft.api.broom.BroomModifiers;
import org.cyclops.evilcraft.api.broom.IBroom;
import org.cyclops.evilcraft.api.broom.IBroomPart;
import org.cyclops.evilcraft.core.broom.BroomParts;
import org.cyclops.evilcraft.core.item.ItemBloodContainer;
import org.cyclops.evilcraft.entity.item.EntityBroom;
import org.cyclops.evilcraft.event.RenderOverlayEventHook;
import org.cyclops.evilcraft.item.ItemBroomConfig;

public class ItemBroom
extends ItemBloodContainer
implements IBroom {
    protected static final ResourceLocation OVERLAY = new ResourceLocation("evilcraft", "textures/gui/overlay.png");
    private static final float Y_SPAWN_OFFSET = 1.5f;

    public ItemBroom(Item.Properties properties) {
        super(properties, 10000);
        if (MinecraftHelpers.isClientSide()) {
            MinecraftForge.EVENT_BUS.addListener(this::onFovEvent);
            MinecraftForge.EVENT_BUS.addListener(this::onRenderOverlayEvent);
        }
    }

    @Override
    public boolean isPlaceFluids() {
        return false;
    }

    @Override
    public boolean isPickupFluids() {
        return false;
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.func_201670_d() && player.func_184187_bx() == null && !player.func_213453_ef()) {
            player.func_70107_b(player.func_226277_ct_(), player.func_226278_cu_() + 1.5, player.func_226281_cx_());
            EntityBroom entityBroom = new EntityBroom(world, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_());
            entityBroom.setBroomStack(stack);
            entityBroom.field_70177_z = player.field_70177_z;
            world.func_217376_c((Entity)entityBroom);
            player.func_184220_m((Entity)entityBroom);
            stack.func_190918_g(1);
        }
        return MinecraftHelpers.successAction((Object)stack);
    }

    @Override
    public ActionResultType onItemUseFirst(ItemStack stack, ItemUseContext context) {
        if (!context.func_195991_k().func_201670_d() && context.func_195999_j().func_213453_ef()) {
            BlockPos blockPos = context.func_195995_a();
            if (!TileHelpers.getCapability((IBlockReader)context.func_195991_k(), (BlockPos)blockPos, (Direction)context.func_196000_l(), (Capability)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).isPresent() && context.func_195991_k().func_175623_d(blockPos.func_177963_a(0.0, 1.5, 0.0))) {
                EntityBroom entityBroom = new EntityBroom(context.func_195991_k(), (double)blockPos.func_177958_n() + 0.5, (float)blockPos.func_177956_o() + 1.5f, (double)blockPos.func_177952_p() + 0.5);
                entityBroom.setBroomStack(stack);
                entityBroom.field_70177_z = context.func_195999_j().field_70177_z;
                context.func_195991_k().func_217376_c((Entity)entityBroom);
                if (!context.func_195999_j().func_184812_l_()) {
                    stack.func_190918_g(1);
                }
                return ActionResultType.SUCCESS;
            }
        }
        return ActionResultType.PASS;
    }

    public Rarity func_77613_e(ItemStack itemStack) {
        int maxRarity = 0;
        for (IBroomPart part : this.getBroomParts(itemStack)) {
            maxRarity = Math.max(maxRarity, part.getRarity().ordinal());
        }
        return Rarity.values()[maxRarity];
    }

    @Override
    public Collection<IBroomPart> getBroomParts(ItemStack itemStack) {
        return BroomParts.REGISTRY.getBroomParts(itemStack);
    }

    @Override
    public Map<BroomModifier, Float> getBroomModifiers(ItemStack itemStack) {
        return BroomModifiers.REGISTRY.getModifiers(itemStack);
    }

    @Override
    public boolean canConsumeBroomEnergy(int amount, ItemStack itemStack, @Nullable LivingEntity entityLiving) {
        return this.canConsume(amount, itemStack, entityLiving instanceof PlayerEntity ? (PlayerEntity)entityLiving : null);
    }

    @Override
    public int consumeBroom(int amount, ItemStack itemStack, @Nullable LivingEntity entityLiving) {
        return FluidHelpers.getAmount((FluidStack)this.consume(amount, itemStack, entityLiving instanceof PlayerEntity ? (PlayerEntity)entityLiving : null));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack itemStack, World world, List<ITextComponent> list, ITooltipFlag flag) {
        super.func_77624_a(itemStack, world, list, flag);
        if (MinecraftHelpers.isShifted()) {
            list.add((ITextComponent)new TranslationTextComponent("broom.parts.evilcraft.types").func_240699_a_(TextFormatting.ITALIC));
            Map<BroomModifier, Float> baseModifiers = BroomParts.REGISTRY.getBaseModifiersFromBroom(itemStack);
            Map<BroomModifier, Float> modifiers = this.getBroomModifiers(itemStack);
            HashSet modifierTypes = Sets.newHashSet();
            modifierTypes.addAll(baseModifiers.keySet());
            modifierTypes.addAll(modifiers.keySet());
            for (IBroomPart part : this.getBroomParts(itemStack)) {
                ITextComponent line = part.getTooltipLine("  ");
                if (line == null) continue;
                list.add(line);
            }
            Pair<Integer, Integer> modifiersAndMax = this.getModifiersAndMax(modifiers, baseModifiers);
            int modifierCount = (Integer)modifiersAndMax.getLeft();
            int maxModifiers = (Integer)modifiersAndMax.getRight();
            list.add((ITextComponent)new TranslationTextComponent("broom.modifiers.evilcraft.types.nameparam", new Object[]{modifierCount, maxModifiers}).func_240699_a_(TextFormatting.ITALIC));
            for (BroomModifier modifier : modifierTypes) {
                if (!modifier.showTooltip()) continue;
                Float value = modifiers.get(modifier);
                Float baseValue = baseModifiers.get(modifier);
                list.add(modifier.getTooltipLine("  ", value == null ? 0.0f : value.floatValue(), baseValue == null ? 0.0f : baseValue.floatValue()));
            }
        } else {
            list.add((ITextComponent)new TranslationTextComponent("broom.evilcraft.shiftinfo").func_240699_a_(TextFormatting.ITALIC));
        }
    }

    private Pair<Integer, Integer> getModifiersAndMax(Map<BroomModifier, Float> broomModifiers, Map<BroomModifier, Float> baseModifiers) {
        int baseMaxModifiers = 0;
        if (baseModifiers.containsKey(BroomModifiers.MODIFIER_COUNT)) {
            baseMaxModifiers = (int)baseModifiers.get(BroomModifiers.MODIFIER_COUNT).floatValue();
        }
        int maxModifiers = baseMaxModifiers;
        int modifiers = 0;
        for (Map.Entry<BroomModifier, Float> entry : broomModifiers.entrySet()) {
            int tier = BroomModifier.getTier(entry.getKey(), entry.getValue().floatValue());
            if (entry.getKey() == BroomModifiers.MODIFIER_COUNT) {
                maxModifiers += (int)entry.getValue().floatValue();
                continue;
            }
            modifiers += tier;
        }
        return Pair.of((Object)modifiers, (Object)maxModifiers);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onFovEvent(FOVUpdateEvent event) {
        if (event.getEntity().func_184187_bx() instanceof EntityBroom) {
            EntityBroom broom = (EntityBroom)event.getEntity().func_184187_bx();
            double speed = broom.getLastPlayerSpeed();
            event.setNewfov((float)((double)event.getFov() + speed / 10.0));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onRenderOverlayEvent(RenderGameOverlayEvent.Post event) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player.func_184187_bx() instanceof EntityBroom && event.getType() == RenderGameOverlayEvent.ElementType.ALL) {
            EntityBroom broom = (EntityBroom)player.func_184187_bx();
            ItemStack broomStack = broom.getBroomStack();
            MainWindow resolution = event.getWindow();
            int height = 21;
            int width = 21;
            RenderOverlayEventHook.OverlayPosition overlayPosition = RenderOverlayEventHook.OverlayPosition.values()[MathHelper.func_76125_a((int)ItemBroomConfig.guiOverlayPosition, (int)0, (int)(RenderOverlayEventHook.OverlayPosition.values().length - 1))];
            int x = overlayPosition.getX(resolution, width, height) + ItemBroomConfig.guiOverlayPositionOffsetX;
            int y = overlayPosition.getY(resolution, width, height) + ItemBroomConfig.guiOverlayPositionOffsetY;
            GlStateManager.func_227626_N_();
            GlStateManager.func_227740_m_();
            GlStateManager.func_227676_b_((int)770, (int)771);
            RenderHelpers.bindTexture((ResourceLocation)OVERLAY);
            Minecraft.func_71410_x().field_71456_v.func_238474_b_(event.getMatrixStack(), x, y, 11, 0, 24, 24);
            GlStateManager.func_227716_f_();
            RenderHelper.func_227780_a_();
            Minecraft.func_71410_x().func_175599_af().func_180450_b(broomStack, x + 3, y + 3);
            Minecraft.func_71410_x().func_175599_af().func_180453_a(Minecraft.func_71410_x().field_71456_v.func_175179_f(), broomStack, x + 3, y + 3, "");
            RenderHelper.func_227780_a_();
            GlStateManager.func_227722_g_();
            GlStateManager.func_227737_l_();
            GlStateManager.func_227627_O_();
        }
    }
}

