/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.item;

import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.util.NonNullList;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.cyclops.cyclopscore.helper.ItemStackHelpers;
import org.cyclops.evilcraft.api.broom.IBroomPart;
import org.cyclops.evilcraft.core.broom.BroomParts;

public class ItemBroomPart
extends Item {
    public ItemBroomPart(Item.Properties properties) {
        super(properties);
    }

    public static IBroomPart getPart(ItemStack itemStack) {
        return BroomParts.REGISTRY.getPartFromItem(itemStack);
    }

    public String func_77667_c(ItemStack itemStack) {
        IBroomPart part = ItemBroomPart.getPart(itemStack);
        if (part != null) {
            return part.getTranslationKey();
        }
        return super.func_77667_c(itemStack);
    }

    public Rarity func_77613_e(ItemStack stack) {
        IBroomPart part = ItemBroomPart.getPart(stack);
        if (part != null) {
            return part.getRarity();
        }
        return super.func_77613_e(stack);
    }

    public boolean func_77636_d(ItemStack stack) {
        IBroomPart part = ItemBroomPart.getPart(stack);
        if (part != null) {
            return part.isEffect();
        }
        return super.func_77636_d(stack);
    }

    public void func_150895_a(ItemGroup creativeTabs, NonNullList<ItemStack> list) {
        if (!ItemStackHelpers.isValidCreativeTab((Item)this, (ItemGroup)creativeTabs)) {
            return;
        }
        for (IBroomPart part : BroomParts.REGISTRY.getParts()) {
            for (ItemStack itemStack : BroomParts.REGISTRY.getItemsFromPart(part)) {
                if (itemStack.func_77973_b() != this) continue;
                list.add((Object)itemStack);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class ItemColor
    implements IItemColor {
        public int getColor(ItemStack itemStack, int renderPass) {
            IBroomPart part = ItemBroomPart.getPart(itemStack);
            if (part != null) {
                return part.getModelColor();
            }
            return -1;
        }
    }
}

