/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.item;

import javax.annotation.Nullable;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootTables;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.wrappers.FluidBucketWrapper;
import org.cyclops.cyclopscore.config.ConfigurableProperty;
import org.cyclops.cyclopscore.config.extendedconfig.ItemConfig;
import org.cyclops.cyclopscore.helper.LootHelpers;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.evilcraft.EvilCraft;
import org.cyclops.evilcraft.RegistryEntries;

public class ItemCondensedBloodConfig
extends ItemConfig {
    @ConfigurableProperty(category="item", comment="If this item should be injected in loot tables..", requiresMcRestart=true)
    public static boolean injectLootTables = true;

    public ItemCondensedBloodConfig() {
        super((ModBase)EvilCraft._instance, "condensed_blood", eConfig -> new Item(new Item.Properties().func_200916_a(EvilCraft._instance.getDefaultItemGroup())){

            public ICapabilityProvider initCapabilities(ItemStack stack, CompoundNBT nbt) {
                return new FluidWrapper(stack);
            }
        });
    }

    public void onForgeRegistered() {
        super.onForgeRegistered();
        if (injectLootTables) {
            LootHelpers.injectLootTable((ResourceLocation)new ResourceLocation("evilcraft", "inject/chests/condensed_blood"), (ResourceLocation[])new ResourceLocation[]{LootTables.field_186420_b, LootTables.field_215815_f, LootTables.field_215814_e, LootTables.field_215819_j, LootTables.field_186425_g, LootTables.field_186422_d, LootTables.field_186424_f, LootTables.field_186430_l});
        }
    }

    public static class FluidWrapper
    extends FluidBucketWrapper {
        public FluidWrapper(ItemStack container) {
            super(container);
        }

        protected int getVolume() {
            return 500;
        }

        public FluidStack getFluid() {
            return new FluidStack((Fluid)RegistryEntries.FLUID_BLOOD, this.getVolume());
        }

        protected void setFluid(@Nullable FluidStack fluidStack) {
            if (fluidStack == null) {
                this.container = this.container.func_77946_l();
                this.container.func_190918_g(1);
            }
        }

        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            if (resource.isEmpty() || resource.getAmount() < this.getVolume()) {
                return FluidStack.EMPTY;
            }
            FluidStack fluidStack = this.getFluid();
            if (!fluidStack.isEmpty() && fluidStack.isFluidEqual(resource)) {
                if (action.execute()) {
                    this.setFluid(null);
                }
                return fluidStack;
            }
            return FluidStack.EMPTY;
        }

        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            if (maxDrain < this.getVolume()) {
                return FluidStack.EMPTY;
            }
            FluidStack fluidStack = this.getFluid();
            if (!fluidStack.isEmpty()) {
                if (action.execute()) {
                    this.setFluid(null);
                }
                return fluidStack;
            }
            return FluidStack.EMPTY;
        }
    }
}

