/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.item;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.cyclops.cyclopscore.capability.fluid.FluidHandlerItemCapacity;
import org.cyclops.cyclopscore.helper.ItemStackHelpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.helper.TileHelpers;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.client.particle.ParticleBloodSplash;
import org.cyclops.evilcraft.core.helper.ItemHelpers;
import org.cyclops.evilcraft.core.item.ItemBloodContainer;
import org.cyclops.evilcraft.tileentity.TileBloodStain;

public class ItemCreativeBloodDrop
extends ItemBloodContainer {
    private static final int MB_FILL_PERTICK = 1000;

    public ItemCreativeBloodDrop(Item.Properties properties) {
        super(properties, 1000);
        this.setPlaceFluids(true);
    }

    public boolean func_77636_d(ItemStack itemStack) {
        return ItemHelpers.isActivated(itemStack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack itemStack, World world, List<ITextComponent> list, ITooltipFlag flag) {
        super.func_77624_a(itemStack, world, list, flag);
        L10NHelpers.addStatusInfo(list, (boolean)ItemHelpers.isActivated(itemStack), (String)(this.func_77658_a() + ".info.auto_supply"));
    }

    public void func_77663_a(ItemStack itemStack, World world, Entity entity, int par4, boolean par5) {
        ItemCreativeBloodDrop.updateAutoFill(itemStack, world, entity);
        super.func_77663_a(itemStack, world, entity, par4, par5);
    }

    public static void updateAutoFill(ItemStack itemStack, World world, Entity entity) {
        FluidStack tickFluid;
        IFluidHandler source = (IFluidHandler)FluidUtil.getFluidHandler((ItemStack)itemStack).orElse(null);
        if (source != null && entity instanceof PlayerEntity && !world.func_201670_d() && ItemHelpers.isActivated(itemStack) && (tickFluid = source.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE)) != null && tickFluid.getAmount() > 0) {
            PlayerEntity player = (PlayerEntity)entity;
            for (Hand hand : Hand.values()) {
                ItemStack held = player.func_184586_b(hand);
                IFluidHandler fluidHandler = (IFluidHandler)FluidUtil.getFluidHandler((ItemStack)held).orElse(null);
                if (held.func_190926_b() || held == itemStack || fluidHandler == null || player.func_184605_cv() != 0 || fluidHandler.fill(tickFluid, IFluidHandler.FluidAction.SIMULATE) <= 0) continue;
                int filled = fluidHandler.fill(new FluidStack(tickFluid.getFluid(), 1000), IFluidHandler.FluidAction.EXECUTE);
                source.drain(filled, IFluidHandler.FluidAction.EXECUTE);
            }
        }
    }

    public double getDurabilityForDisplay(ItemStack itemStack) {
        return 1.0;
    }

    public void func_150895_a(ItemGroup itemGroup, NonNullList<ItemStack> items) {
        if (ItemStackHelpers.isValidCreativeTab((Item)this, (ItemGroup)itemGroup) && this.func_194125_a(this.field_77701_a)) {
            items.add((Object)new ItemStack((IItemProvider)this));
        }
    }

    @Override
    public ActionResultType onItemUseFirst(ItemStack stack, ItemUseContext context) {
        if (context.func_195999_j().func_213453_ef()) {
            BlockPos pos = context.func_195995_a().func_177982_a(0, 1, 0);
            if (RegistryEntries.BLOCK_BLOOD_STAIN.func_196260_a(RegistryEntries.BLOCK_BLOOD_STAIN.func_176223_P(), (IWorldReader)context.func_195991_k(), pos)) {
                if (context.func_195991_k().func_201670_d()) {
                    ParticleBloodSplash.spawnParticles(context.func_195991_k(), pos, 5, 1 + context.func_195991_k().field_73012_v.nextInt(2));
                } else {
                    if (context.func_195991_k().func_175623_d(pos)) {
                        context.func_195991_k().func_175656_a(pos, RegistryEntries.BLOCK_BLOOD_STAIN.func_176223_P());
                    }
                    if (context.func_195991_k().func_180495_p(pos).func_177230_c() == RegistryEntries.BLOCK_BLOOD_STAIN) {
                        TileHelpers.getSafeTile((IBlockReader)context.func_195991_k(), (BlockPos)pos, TileBloodStain.class).ifPresent(tile -> tile.addAmount(1000));
                    }
                }
                return ActionResultType.PASS;
            }
        }
        return super.onItemUseFirst(stack, context);
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack itemStack = player.func_184586_b(hand);
        if (!player.func_213453_ef()) {
            return super.func_77659_a(world, player, hand);
        }
        BlockRayTraceResult target = ItemCreativeBloodDrop.func_219968_a((World)world, (PlayerEntity)player, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.ANY);
        if (!(target != null && target.func_216346_c() != RayTraceResult.Type.MISS || world.func_201670_d())) {
            ItemHelpers.toggleActivation(itemStack);
        }
        return MinecraftHelpers.successAction((Object)itemStack);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundNBT nbt) {
        return new FluidHandlerItemCapacity(stack, 1000){

            public FluidStack getFluid() {
                return new FluidStack(ItemCreativeBloodDrop.this.getFluid(), 500);
            }

            @Nonnull
            public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
                return new FluidStack(this.getFluid(), maxDrain);
            }

            public int fill(FluidStack resource, IFluidHandler.FluidAction doFill) {
                return resource.getAmount();
            }
        };
    }
}

