/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.item;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import org.cyclops.cyclopscore.helper.ItemStackHelpers;

public class ItemEffortlessRing
extends Item {
    private static final int TICK_MODULUS = 1;
    private static final String PLAYER_NBT_KEY = "evilcraft:lastStepSize";
    private static final float SPEED_BONUS = 0.05f;
    private static final float STEP_SIZE = 1.0f;
    private static final float JUMP_DISTANCE_FACTOR = 0.05f;
    private static final float JUMP_HEIGHT_FACTOR = 0.3f;
    private static final float FALLDISTANCE_REDUCTION = 2.0f;

    public ItemEffortlessRing(Item.Properties properties) {
        super(properties);
        MinecraftForge.EVENT_BUS.addListener(this::onPlayerFall);
        MinecraftForge.EVENT_BUS.addListener(this::onPlayerJump);
        MinecraftForge.EVENT_BUS.addListener(this::onPlayerUpdate);
    }

    public void adjustParameters(ItemStack itemStack, PlayerEntity player) {
        if (player.field_191988_bg > 0.0f && player.func_233570_aj_()) {
            player.func_213309_a(player.func_70090_H() ? 0.016666668f : 0.05f, new Vector3d(0.0, 0.0, 1.0));
        }
        if (!player.getPersistentData().func_74764_b(PLAYER_NBT_KEY)) {
            player.getPersistentData().func_74776_a(PLAYER_NBT_KEY, player.field_70138_W);
        }
        float f = player.field_70138_W = player.func_213453_ef() ? 0.5f : 1.0f;
        if (!player.func_233570_aj_()) {
            player.field_70747_aH = 0.05f;
        }
    }

    public void onPlayerJump(LivingEvent.LivingJumpEvent event) {
        PlayerEntity player;
        if (event.getEntityLiving() instanceof PlayerEntity && ItemStackHelpers.hasPlayerItem((PlayerEntity)(player = (PlayerEntity)event.getEntityLiving()), (Item)this)) {
            player.func_213317_d(player.func_213322_ci().func_72441_c(0.0, (double)0.3f, 0.0));
        }
    }

    public void onPlayerUpdate(LivingEvent.LivingUpdateEvent event) {
        PlayerEntity player;
        if (event.getEntityLiving() instanceof PlayerEntity && (player = (PlayerEntity)event.getEntityLiving()).getPersistentData().func_74764_b(PLAYER_NBT_KEY) && !ItemStackHelpers.hasPlayerItem((PlayerEntity)player, (Item)this)) {
            player.field_70138_W = player.getPersistentData().func_74760_g(PLAYER_NBT_KEY);
            player.getPersistentData().func_82580_o(PLAYER_NBT_KEY);
        }
    }

    public void onPlayerFall(LivingFallEvent event) {
        PlayerEntity player;
        if (event.getEntityLiving() instanceof PlayerEntity && ItemStackHelpers.hasPlayerItem((PlayerEntity)(player = (PlayerEntity)event.getEntityLiving()), (Item)this)) {
            event.setDistance(event.getDistance() - 2.0f);
        }
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (entityIn instanceof PlayerEntity) {
            this.adjustParameters(stack, (PlayerEntity)entityIn);
        }
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
    }
}

