/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import org.cyclops.cyclopscore.helper.FluidHelpers;
import org.cyclops.cyclopscore.inventory.PlayerExtendedInventoryIterator;
import org.cyclops.evilcraft.EvilCraft;
import org.cyclops.evilcraft.core.fluid.FluidContainerItemWrapperWithSimulation;
import org.cyclops.evilcraft.core.fluid.WorldSharedTankCache;
import org.cyclops.evilcraft.core.helper.ItemHelpers;
import org.cyclops.evilcraft.core.item.ItemBlockFluidContainer;
import org.cyclops.evilcraft.tileentity.TileEntangledChalice;

public class ItemEntangledChalice
extends ItemBlockFluidContainer {
    public static String[] namePartsArray = "the elder scrolls klaatu berata niktu xyzzy bless curse light darkness fire air earth water hot dry cold wet ignite snuff embiggen twist shorten stretch fiddle destroy imbue galvanize enchant free limited range of towards inside sphere cube self other ball mental physical grow shrink demon elemental spirit animal creature beast humanoid undead fresh stale phnglui mglwnafh cthulhu rlyeh wgahnagl fhtagnbaguette".split(" ");

    public ItemEntangledChalice(Block block, Item.Properties properties) {
        super(block, properties);
    }

    @Override
    public boolean func_77636_d(ItemStack itemStack) {
        return ItemHelpers.isActivated(itemStack);
    }

    @Override
    protected void autofill(int itemSlot, IFluidHandlerItem source, World world, Entity entity) {
        if (entity instanceof PlayerEntity && !world.func_201670_d()) {
            FluidStack tickFluid;
            PlayerEntity player = (PlayerEntity)entity;
            PlayerExtendedInventoryIterator it = new PlayerExtendedInventoryIterator(player);
            do {
                ItemStack filled;
                tickFluid = FluidHelpers.getFluid((IFluidHandler)source);
                ItemStack toFill = it.next();
                if (tickFluid == null || toFill.func_190926_b() || toFill.func_190916_E() != 1 || (filled = ItemHelpers.tryFillContainerForPlayer(source, toFill, tickFluid, player)).func_190926_b()) continue;
                it.replace(filled);
                player.field_71071_by.func_70299_a(itemSlot, source.getContainer());
            } while (tickFluid != null && tickFluid.getAmount() > 0 && it.hasNext());
        }
    }

    @Override
    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundNBT nbt) {
        return new FluidHandler(stack, 4000);
    }

    @Override
    protected boolean itemStackDataToTile(ItemStack itemStack, TileEntity tile) {
        super.itemStackDataToTile(itemStack, tile);
        FluidHandler fluidHandler = (FluidHandler)((Object)FluidUtil.getFluidHandler((ItemStack)itemStack).orElse(null));
        String tankId = fluidHandler.getTankID();
        ((TileEntangledChalice)tile).setWorldTankId(tankId);
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack itemStack, @Nullable World worldIn, List<ITextComponent> list, ITooltipFlag flagIn) {
        super.func_77624_a(itemStack, worldIn, list, flagIn);
        FluidHandler fluidHandler = (FluidHandler)((Object)FluidUtil.getFluidHandler((ItemStack)itemStack).orElse(null));
        String tankId = fluidHandler == null ? "null" : fluidHandler.getTankID();
        list.add((ITextComponent)new TranslationTextComponent("block.evilcraft.entangled_chalice.info.id", new Object[]{ItemEntangledChalice.tankIdToNameParts(tankId)}));
    }

    public static String tankIdToNameParts(String tankId) {
        try {
            int i = Integer.parseInt(tankId);
            String a = namePartsArray[(i + 3) % namePartsArray.length];
            String b = namePartsArray[(i * 3 + 5) % namePartsArray.length];
            String c = namePartsArray[(i * 13 + 7) % namePartsArray.length];
            return String.format("%s %s %s", a, b, c);
        }
        catch (NumberFormatException e) {
            return tankId;
        }
    }

    public static class FluidHandler
    extends FluidContainerItemWrapperWithSimulation {
        public FluidHandler(ItemStack container, int capacity) {
            super(container, capacity);
        }

        public FluidStack getFluid() {
            return WorldSharedTankCache.getInstance().getTankContent(this.getTankID());
        }

        protected void setFluid(FluidStack fluidStack) {
            WorldSharedTankCache.getInstance().setTankContent(this.getTankID(), fluidStack);
        }

        protected void setContainerToEmpty() {
            this.setFluid(FluidStack.EMPTY);
        }

        public String getTankID() {
            CompoundNBT tag = this.getContainer().func_77978_p();
            if (tag != null) {
                if (!tag.func_74764_b("tankID")) {
                    tag.func_74778_a("tankID", "");
                }
                return tag.func_74779_i("tankID");
            }
            return "";
        }

        public void setTankID(String tankID) {
            CompoundNBT tag = this.getContainer().func_196082_o();
            tag.func_74778_a("tankID", tankID);
        }

        public void setNextTankID() {
            this.setTankID(Integer.toString(EvilCraft.globalCounters.getNext("EntangledChalice")));
        }
    }
}

