/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.item;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import org.cyclops.cyclopscore.inventory.NBTSimpleInventoryItemHeld;
import org.cyclops.cyclopscore.inventory.container.NamedContainerProviderItem;
import org.cyclops.cyclopscore.item.ItemGui;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.entity.item.EntityItemEmpowerable;
import org.cyclops.evilcraft.inventory.container.ContainerExaltedCrafter;
import org.cyclops.evilcraft.item.IItemEmpowerable;

public class ItemExaltedCrafter
extends ItemGui
implements IItemEmpowerable {
    private static final String NBT_RETURNTOINNER = "returnToInner";
    private static final String NBT_INVENTORY = "inventory";
    private final boolean wooden;
    private final boolean empowered;

    public ItemExaltedCrafter(Item.Properties properties, boolean wooden, boolean empowered) {
        super(properties);
        this.wooden = wooden;
        this.empowered = empowered;
    }

    public boolean func_77636_d(ItemStack itemStack) {
        return this.isEmpowered(itemStack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Rarity func_77613_e(ItemStack itemStack) {
        return this.isEmpowered(itemStack) ? Rarity.UNCOMMON : super.func_77613_e(itemStack);
    }

    @Override
    public boolean isEmpowered(ItemStack itemStack) {
        return this.empowered;
    }

    @Override
    public ItemStack empower(ItemStack itemStack) {
        ItemStack newStack = new ItemStack((IItemProvider)(this.wooden ? RegistryEntries.ITEM_EXALTED_CRAFTER_WOODEN_EMPOWERED : RegistryEntries.ITEM_EXALTED_CRAFTER_EMPOWERED));
        newStack.func_77982_d(itemStack.func_77978_p().func_74737_b());
        return newStack;
    }

    public IInventory getSupplementaryInventory(PlayerEntity player, ItemStack itemStack, int itemIndex, Hand hand) {
        if (this.wooden) {
            return new NBTSimpleInventoryItemHeld(player, itemIndex, hand, 27, 64, NBT_INVENTORY);
        }
        return player.func_71005_bN();
    }

    public boolean hasCustomEntity(ItemStack itemStack) {
        return true;
    }

    public Entity createEntity(World world, Entity location, ItemStack itemStack) {
        return new EntityItemEmpowerable(world, (ItemEntity)location);
    }

    public static void setReturnToInner(ItemStack itemStack, boolean returnToInner) {
        if (itemStack.func_77942_o()) {
            itemStack.func_77978_p().func_74757_a(NBT_RETURNTOINNER, returnToInner);
        }
    }

    public static boolean isReturnToInner(ItemStack itemStack) {
        if (itemStack.func_77942_o()) {
            return itemStack.func_77978_p().func_74767_n(NBT_RETURNTOINNER);
        }
        return false;
    }

    @Nullable
    public INamedContainerProvider getContainer(World world, PlayerEntity playerEntity, int itemIndex, Hand hand, ItemStack itemStack) {
        return new NamedContainerProviderItem(itemIndex, hand, itemStack.func_200301_q(), ContainerExaltedCrafter::new);
    }

    public Class<? extends Container> getContainerClass(World world, PlayerEntity playerEntity, ItemStack itemStack) {
        return ContainerExaltedCrafter.class;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        if (world.func_201670_d()) {
            world.func_184148_a(player, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), this.wooden ? SoundEvents.field_187657_V : SoundEvents.field_187520_aJ, SoundCategory.BLOCKS, 0.5f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
        return super.func_77659_a(world, player, hand);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundNBT nbt) {
        ItemHandler itemHandler = new ItemHandler(stack);
        return new ICapabilityProvider((IItemHandler)itemHandler){
            final /* synthetic */ IItemHandler val$itemHandler;
            {
                this.val$itemHandler = iItemHandler;
            }

            public <T> LazyOptional getCapability(Capability<T> capability, Direction facing) {
                return ItemExaltedCrafter.this.wooden && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? LazyOptional.of(() -> this.val$itemHandler) : LazyOptional.empty();
            }
        };
    }

    public class ItemHandler
    implements IItemHandlerModifiable {
        protected ItemStack itemStack;

        public ItemHandler(ItemStack itemStack) {
            this.itemStack = itemStack;
        }

        protected NonNullList<ItemStack> getItemList() {
            NonNullList itemStacks = NonNullList.func_191197_a((int)this.getSlots(), (Object)ItemStack.field_190927_a);
            CompoundNBT rootTag = this.itemStack.func_77978_p();
            if (rootTag != null && rootTag.func_150297_b(ItemExaltedCrafter.NBT_INVENTORY, 9)) {
                ListNBT nbttaglist = rootTag.func_150295_c(ItemExaltedCrafter.NBT_INVENTORY, 10);
                for (int j = 0; j < nbttaglist.size(); ++j) {
                    CompoundNBT slot = nbttaglist.func_150305_b(j);
                    int index = slot.func_74764_b("index") ? slot.func_74762_e("index") : (int)slot.func_74771_c("Slot");
                    if (index < 0 || index >= this.getSlots()) continue;
                    itemStacks.set(index, (Object)ItemStack.func_199557_a((CompoundNBT)slot));
                }
            }
            return itemStacks;
        }

        protected void setItemList(NonNullList<ItemStack> itemStacks) {
            CompoundNBT rootTag = this.itemStack.func_196082_o();
            ListNBT slots = new ListNBT();
            for (byte index = 0; index < this.getSlots(); index = (byte)((byte)(index + 1))) {
                ItemStack itemStack = (ItemStack)itemStacks.get((int)index);
                if (itemStack.func_190926_b() || itemStack.func_190916_E() <= 0) continue;
                CompoundNBT slot = new CompoundNBT();
                slots.add((Object)slot);
                slot.func_74774_a("Slot", index);
                itemStack.func_77955_b(slot);
            }
            rootTag.func_218657_a(ItemExaltedCrafter.NBT_INVENTORY, (INBT)slots);
        }

        public void setStackInSlot(int slot, ItemStack stack) {
            NonNullList<ItemStack> itemStacks = this.getItemList();
            itemStacks.set(slot, (Object)stack);
            this.setItemList(itemStacks);
        }

        public int getSlots() {
            return 27;
        }

        public ItemStack getStackInSlot(int slot) {
            return (ItemStack)this.getItemList().get(slot);
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (stack.func_190926_b()) {
                return ItemStack.field_190927_a;
            }
            NonNullList<ItemStack> itemStacks = this.getItemList();
            ItemStack existingStack = (ItemStack)itemStacks.get(slot);
            if (!existingStack.func_190926_b()) {
                if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)existingStack)) {
                    return stack;
                }
                int maxStackSize = Math.min(stack.func_77976_d(), this.getSlotLimit(slot)) - existingStack.func_190916_E();
                if (stack.func_190916_E() <= maxStackSize) {
                    if (!simulate) {
                        ItemStack copy = stack.func_77946_l();
                        copy.func_190917_f(existingStack.func_190916_E());
                        this.setStackInSlot(slot, copy);
                    }
                    return ItemStack.field_190927_a;
                }
                stack = stack.func_77946_l();
                if (!simulate) {
                    ItemStack copy = stack.func_77979_a(maxStackSize);
                    copy.func_190917_f(existingStack.func_190916_E());
                    this.setStackInSlot(slot, copy);
                    return stack;
                }
                stack.func_190918_g(maxStackSize);
                return stack;
            }
            int maxStackSize = Math.min(stack.func_77976_d(), this.getSlotLimit(slot));
            if (maxStackSize < stack.func_190916_E()) {
                stack = stack.func_77946_l();
                if (!simulate) {
                    this.setStackInSlot(slot, stack.func_77979_a(maxStackSize));
                    return stack;
                }
                stack.func_190918_g(maxStackSize);
                return stack;
            }
            if (!simulate) {
                this.setStackInSlot(slot, stack);
            }
            return ItemStack.field_190927_a;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (amount == 0) {
                return ItemStack.field_190927_a;
            }
            ItemStack existingStack = this.getStackInSlot(slot);
            if (existingStack.func_190926_b()) {
                return ItemStack.field_190927_a;
            }
            ItemStack extracted = existingStack.func_77979_a(amount);
            if (!simulate) {
                this.setStackInSlot(slot, existingStack);
            }
            return extracted;
        }

        public int getSlotLimit(int slot) {
            return 64;
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return true;
        }
    }
}

