/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.item;

import com.google.common.collect.Lists;
import java.util.Iterator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.world.World;
import org.cyclops.cyclopscore.helper.WorldHelpers;
import org.cyclops.evilcraft.core.item.ItemBloodContainer;
import org.cyclops.evilcraft.item.ItemInvigoratingPendantConfig;

public class ItemInvigoratingPendant
extends ItemBloodContainer {
    private static final int TICK_MODULUS = 10;

    public ItemInvigoratingPendant(Item.Properties properties) {
        super(properties, ItemInvigoratingPendantConfig.capacity);
    }

    public void clearBadEffects(ItemStack itemStack, PlayerEntity player) {
        int amount = ItemInvigoratingPendantConfig.usage;
        if (this.canConsume(amount, itemStack, player)) {
            int originalReducableDuration;
            int reducableDuration = originalReducableDuration = ItemInvigoratingPendantConfig.reduceDuration * 20;
            Iterator it = Lists.newLinkedList((Iterable)player.func_70651_bq()).iterator();
            while (reducableDuration > 0 && it.hasNext() && this.canConsume(amount, itemStack, player)) {
                EffectInstance effect = (EffectInstance)it.next();
                Effect potion = effect.func_188419_a();
                boolean shouldClear = true;
                if (potion != null) {
                    shouldClear = !potion.func_188408_i();
                }
                if (!(shouldClear &= !effect.func_82720_e())) continue;
                int reductionMultiplier = effect.func_76458_c() + 1;
                int reducableDurationForThisEffect = reducableDuration / reductionMultiplier;
                int remaining = effect.func_76459_b();
                int toReduce = Math.min(reducableDurationForThisEffect, remaining);
                int toDrain = amount;
                reducableDuration -= toReduce;
                if (remaining == toReduce) {
                    player.func_195063_d(potion);
                } else {
                    effect.field_76460_b = remaining - toReduce;
                    player.func_70695_b(effect, true);
                    toDrain = (int)Math.ceil((double)(reductionMultiplier * amount) * ((double)toReduce / (double)originalReducableDuration));
                }
                this.consume(toDrain, itemStack, player);
            }
        }
        if (ItemInvigoratingPendantConfig.fireUsage >= 0 && player.func_70027_ad() && this.canConsume(ItemInvigoratingPendantConfig.fireUsage, itemStack, player)) {
            player.func_70066_B();
            this.consume(ItemInvigoratingPendantConfig.fireUsage, itemStack, player);
        }
    }

    public void func_77663_a(ItemStack itemStack, World world, Entity entity, int par4, boolean par5) {
        if (entity instanceof PlayerEntity && WorldHelpers.efficientTick((World)world, (int)10, (int[])new int[]{entity.func_145782_y()})) {
            this.clearBadEffects(itemStack, (PlayerEntity)entity);
        }
        super.func_77663_a(itemStack, world, entity, par4, par5);
    }
}

