/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.item;

import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.cyclops.cyclopscore.client.particle.ParticleBlurData;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.evilcraft.core.helper.ItemHelpers;
import org.cyclops.evilcraft.core.item.ItemBloodContainer;
import org.cyclops.evilcraft.entity.item.EntityItemUndespawnable;
import org.cyclops.evilcraft.item.ItemKineticatorConfig;
import org.cyclops.evilcraft.item.ItemPowerableHelpers;

public class ItemKineticator
extends ItemBloodContainer {
    private static final int POWER_LEVELS = 5;
    private static final int RANGE_PER_LEVEL = 2;
    private static final double USAGE_PER_D = 0.1;
    private static final int CONTAINER_SIZE = 1000;
    private final boolean repelling;

    public ItemKineticator(Item.Properties properties, boolean repelling) {
        super(properties, 1000);
        this.repelling = repelling;
    }

    public boolean isRepelling(ItemStack itemStack) {
        return this.repelling;
    }

    private int getArea(ItemStack itemStack) {
        return 2 * (this.getPower(itemStack) + 1);
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack itemStack = player.func_184586_b(hand);
        if (!ItemPowerableHelpers.onPowerableItemItemRightClick(itemStack, world, player, 5, false) && !world.func_201670_d()) {
            ItemHelpers.toggleActivation(itemStack);
        }
        return MinecraftHelpers.successAction((Object)itemStack);
    }

    public boolean func_77636_d(ItemStack itemStack) {
        return ItemHelpers.isActivated(itemStack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack itemStack, World world, List<ITextComponent> list, ITooltipFlag flag) {
        super.func_77624_a(itemStack, world, list, flag);
        L10NHelpers.addStatusInfo(list, (boolean)ItemHelpers.isActivated(itemStack), (String)(this.func_77658_a() + ".info.attraction"));
        list.add((ITextComponent)new TranslationTextComponent(this.func_77658_a() + ".info.area", new Object[]{this.getArea(itemStack)}).func_240699_a_(TextFormatting.BOLD));
    }

    public int getPower(ItemStack itemStack) {
        return ItemPowerableHelpers.getPower(itemStack);
    }

    public void setPower(ItemStack itemStack, int power) {
        ItemPowerableHelpers.setPower(itemStack, power);
    }

    public void func_77663_a(ItemStack itemStack, World world, Entity entity, int par4, boolean par5) {
        if (entity instanceof PlayerEntity) {
            this.kineticate(itemStack, world, entity);
        }
        super.func_77663_a(itemStack, world, entity, par4, par5);
    }

    public boolean onEntityItemUpdate(ItemStack itemStack, ItemEntity entityItem) {
        this.kineticate(itemStack, entityItem.field_70170_p, (Entity)entityItem);
        return super.onEntityItemUpdate(itemStack, entityItem);
    }

    private void kineticate(ItemStack itemStack, World world, Entity entity) {
        if (ItemHelpers.isActivated(itemStack) && (FluidUtil.getFluidContained((ItemStack)itemStack) != null || entity instanceof PlayerEntity && this.canConsume(1, itemStack, (PlayerEntity)entity)) && entity != null && !entity.func_213453_ef()) {
            IFluidHandler fluidHandler = (IFluidHandler)FluidUtil.getFluidHandler((ItemStack)itemStack).orElse(null);
            boolean repelling = this.isRepelling(itemStack);
            boolean isPlayer = entity instanceof PlayerEntity;
            double x = entity.func_226277_ct_();
            double y = entity.func_226278_cu_();
            double z = entity.func_226281_cx_();
            if (0L == world.func_82737_E() % (long)ItemKineticatorConfig.tickHoldoff) {
                int area = this.getArea(itemStack);
                AxisAlignedBB box = new AxisAlignedBB(x, y, z, x, y, z).func_186662_g((double)area);
                List entities = world.func_175674_a(entity, box, (Predicate)new com.google.common.base.Predicate<Entity>(){

                    public boolean apply(Entity entity) {
                        return entity instanceof ItemEntity || ItemKineticatorConfig.moveXP && entity instanceof ExperienceOrbEntity;
                    }
                });
                for (Entity moveEntity : entities) {
                    if (!repelling && (!(moveEntity instanceof ItemEntity) || ((ItemEntity)moveEntity).func_174874_s() || !this.canKineticateItem(((ItemEntity)moveEntity).func_92059_d())) && !(moveEntity instanceof ExperienceOrbEntity)) continue;
                    double dx = moveEntity.func_226277_ct_() - x;
                    double dy = moveEntity.func_226278_cu_() - (isPlayer ? y + (double)(world.func_201670_d() ? -1 : 1) : y);
                    double dz = moveEntity.func_226281_cx_() - z;
                    double strength = -0.3;
                    if (isPlayer) {
                        strength = -1.0;
                    }
                    if (repelling) {
                        strength /= -1.0;
                        if (isPlayer) {
                            strength = 0.3;
                        }
                    }
                    double d = MathHelper.func_76133_a((double)(dx * dx + dy * dy + dz * dz));
                    int usage = (int)Math.round(d * 0.1);
                    if (!repelling && !(d > 0.5) || usage != 0 && fluidHandler.drain(usage, IFluidHandler.FluidAction.SIMULATE) == null && (!isPlayer || !this.canConsume(usage, itemStack, (PlayerEntity)entity))) continue;
                    double m = 1.0 / (2.0 * Math.max(1.0, d));
                    dx *= m;
                    dy *= m;
                    dz *= m;
                    if (world.func_201670_d()) {
                        this.showEntityMoved(world, entity, moveEntity, dx / 10.0, dy / 10.0, dz / 10.0);
                    } else {
                        if (moveEntity instanceof ItemEntity && d < 5.0) {
                            ((ItemEntity)moveEntity).func_174867_a(repelling ? 5 : 0);
                        }
                        moveEntity.func_213317_d(new Vector3d(dx, dy, dz).func_216372_d(strength, strength, strength));
                        if (moveEntity.field_70123_F) {
                            moveEntity.func_213317_d(new Vector3d(moveEntity.func_213322_ci().field_72450_a, 0.3, moveEntity.func_213322_ci().field_72449_c));
                        }
                    }
                    if (0L != world.func_82737_E() % (long)ItemKineticatorConfig.consumeHoldoff) continue;
                    if (isPlayer) {
                        this.consume(usage, itemStack, (PlayerEntity)entity);
                        continue;
                    }
                    fluidHandler.drain(usage, IFluidHandler.FluidAction.EXECUTE);
                }
            }
        }
    }

    protected boolean canKineticateItem(ItemStack entityItem) {
        if (entityItem == null) {
            return false;
        }
        return !ItemKineticatorConfig.kineticateBlacklist.contains(entityItem.func_77973_b().getRegistryName().toString());
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void showEntityMoved(World world, Entity player, Entity entity, double dx, double dy, double dz) {
        Random rand = world.field_73012_v;
        float scale = 0.05f;
        float red = rand.nextFloat() * 0.03f + 0.5f;
        float green = rand.nextFloat() * 0.03f + (rand.nextBoolean() ? 0.5f : 0.3f);
        float blue = rand.nextFloat() * 0.05f;
        float ageMultiplier = (float)(rand.nextDouble() * 2.5 + 10.0);
        world.func_195590_a((IParticleData)new ParticleBlurData(red, green, blue, scale, ageMultiplier), false, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), -dx, -dy, -dz);
    }

    public boolean hasCustomEntity(ItemStack itemStack) {
        return true;
    }

    public Entity createEntity(World world, Entity location, ItemStack itemStack) {
        return new EntityItemUndespawnable(world, (ItemEntity)location);
    }
}

