/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import org.cyclops.cyclopscore.capability.fluid.IFluidHandlerItemCapacity;
import org.cyclops.cyclopscore.helper.FluidHelpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.evilcraft.client.particle.ParticleBlurTargettedEntityData;
import org.cyclops.evilcraft.client.particle.ParticleDistortData;
import org.cyclops.evilcraft.client.particle.ParticleExplosionExtendedData;
import org.cyclops.evilcraft.core.item.ItemBloodContainer;
import org.cyclops.evilcraft.item.ItemPowerableHelpers;

public abstract class ItemMace
extends ItemBloodContainer {
    private final int hitUsage;
    private final int maximumCharge;
    private final int powerLevels;
    private final float meleeDamage;

    public ItemMace(Item.Properties builder, int containerSize, int hitUsage, int maximumCharge, int powerLevels, float meleeDamage) {
        super(builder, containerSize);
        this.hitUsage = hitUsage;
        this.maximumCharge = maximumCharge;
        this.powerLevels = powerLevels;
        this.meleeDamage = meleeDamage;
    }

    protected boolean isUsable(ItemStack itemStack, PlayerEntity player) {
        return this.canConsume(1, itemStack, player);
    }

    public boolean func_77644_a(ItemStack itemStack, LivingEntity attacked, LivingEntity attacker) {
        if (attacker instanceof PlayerEntity && this.isUsable(itemStack, (PlayerEntity)attacker)) {
            ((IFluidHandlerItem)FluidUtil.getFluidHandler((ItemStack)itemStack).orElseGet(null)).drain(this.hitUsage, IFluidHandler.FluidAction.EXECUTE);
        }
        return true;
    }

    public boolean onLeftClickEntity(ItemStack itemStack, PlayerEntity player, Entity entity) {
        return !this.isUsable(itemStack, player);
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.BOW;
    }

    public int func_77626_a(ItemStack itemStack) {
        return this.maximumCharge * (this.powerLevels - this.getPower(itemStack));
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack itemStack = player.func_184586_b(hand);
        if (ItemPowerableHelpers.onPowerableItemItemRightClick(itemStack, world, player, this.powerLevels, true)) {
            return MinecraftHelpers.successAction((Object)itemStack);
        }
        if (this.isUsable(itemStack, player)) {
            player.func_184598_c(hand);
            return MinecraftHelpers.successAction((Object)itemStack);
        }
        if (world.func_201670_d()) {
            this.animateOutOfEnergy(world, (LivingEntity)player);
            return new ActionResult(ActionResultType.FAIL, (Object)itemStack);
        }
        return new ActionResult(ActionResultType.PASS, (Object)itemStack);
    }

    public void onUsingTick(ItemStack itemStack, LivingEntity player, int duration) {
        World world = player.field_70170_p;
        if (world.func_201670_d() && duration % 2 == 0) {
            this.showUsingItemTick(world, itemStack, player, duration);
        }
        super.onUsingTick(itemStack, player, duration);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void showUsingItemTick(World world, ItemStack itemStack, LivingEntity entity, int duration) {
        int itemUsedCount = this.func_77626_a(itemStack) - duration;
        double area = this.getArea(itemUsedCount);
        int points = (int)Math.pow(area, 0.55) * 2 + 1;
        int particleChance = 5 * (this.powerLevels - this.getPower(itemStack));
        for (double point = (double)(-points); point <= (double)points; point += 1.0) {
            for (double pointHeight = (double)(-points); pointHeight <= (double)points; pointHeight += 0.5) {
                if (field_77697_d.nextInt(particleChance) != 0) continue;
                double u = Math.PI * (point / (double)points);
                double v = Math.PI * -2 * (pointHeight / (double)points);
                double xOffset = Math.cos(u) * Math.sin(v) * area;
                double yOffset = Math.sin(u) * area;
                double zOffset = Math.cos(v) * area;
                double xCoord = entity.func_226277_ct_();
                double yCoord = entity.func_226278_cu_() + (double)entity.func_70047_e() - (Minecraft.func_71410_x().field_71439_g == entity ? 0.5 : 1.5);
                double zCoord = entity.func_226281_cx_();
                double particleX = xCoord + xOffset - (double)world.field_73012_v.nextFloat() * area / 4.0 - 0.5;
                double particleY = yCoord + yOffset - (double)world.field_73012_v.nextFloat() * area / 4.0 - 0.5;
                double particleZ = zCoord + zOffset - (double)world.field_73012_v.nextFloat() * area / 4.0 - 0.5;
                float particleMotionX = (float)(xOffset * 10.0);
                float particleMotionY = (float)(yOffset * 10.0);
                float particleMotionZ = (float)(zOffset * 10.0);
                Minecraft.func_71410_x().field_71438_f.func_195461_a((IParticleData)new ParticleDistortData((float)area * 3.0f), false, particleX, particleY, particleZ, (double)particleMotionX, (double)particleMotionY, (double)particleMotionZ);
                if (world.field_73012_v.nextInt(10) != 0) continue;
                int spread = 10;
                float scale2 = 0.3f - world.field_73012_v.nextFloat() * 0.2f;
                float r = 1.0f * world.field_73012_v.nextFloat();
                float g = 0.2f + 0.01f * world.field_73012_v.nextFloat();
                float b = 0.1f + 0.5f * world.field_73012_v.nextFloat();
                float ageMultiplier2 = 20.0f;
                double motionX = (double)spread - world.field_73012_v.nextDouble() * 2.0 * (double)spread;
                double motionY = (double)spread - world.field_73012_v.nextDouble() * 2.0 * (double)spread;
                double motionZ = (double)spread - world.field_73012_v.nextDouble() * 2.0 * (double)spread;
                Minecraft.func_71410_x().field_71438_f.func_195461_a((IParticleData)new ParticleBlurTargettedEntityData(r, g, b, scale2, ageMultiplier2, entity.func_145782_y()), false, particleX, particleY, particleZ, motionX, motionY, motionZ);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void showUsedItemTick(World world, LivingEntity player, int power) {
        int particles = (power + 1) * (power + 1) * (power + 1) * 10;
        for (int i = 0; i < particles; ++i) {
            double x = player.func_226277_ct_() - 0.5 + world.field_73012_v.nextDouble();
            double y = player.func_226278_cu_() + (double)player.func_70047_e() - 1.0 + world.field_73012_v.nextDouble();
            double z = player.func_226281_cx_() - 0.5 + world.field_73012_v.nextDouble();
            double particleMotionX = (-1.0 + world.field_73012_v.nextDouble() * 2.0) * (double)(power + 1) / 2.0;
            double particleMotionY = (-1.0 + world.field_73012_v.nextDouble() * 2.0) * (double)(power + 1) / 2.0;
            double particleMotionZ = (-1.0 + world.field_73012_v.nextDouble() * 2.0) * (double)(power + 1) / 2.0;
            float r = 1.0f * world.field_73012_v.nextFloat();
            float g = 0.2f + 0.01f * world.field_73012_v.nextFloat();
            float b = 0.1f + 0.5f * world.field_73012_v.nextFloat();
            Minecraft.func_71410_x().field_71438_f.func_195461_a((IParticleData)new ParticleExplosionExtendedData(r, g, b, 0.3f), false, x, y, z, particleMotionX, particleMotionY, particleMotionZ);
        }
    }

    protected double getArea(int itemUsedCount) {
        return (double)(itemUsedCount / 5) + 2.0;
    }

    public void func_77615_a(ItemStack itemStack, World world, LivingEntity entity, int itemInUseCount) {
        if (entity instanceof PlayerEntity) {
            IFluidHandlerItemCapacity fluidHandler = (IFluidHandlerItemCapacity)FluidHelpers.getFluidHandlerItemCapacity((ItemStack)itemStack).orElse(null);
            PlayerEntity player = (PlayerEntity)entity;
            int itemUsedCount = this.func_77626_a(itemStack) - itemInUseCount;
            int toDrain = itemUsedCount * fluidHandler.getCapacity() * (this.getPower(itemStack) + 1) / (this.func_77626_a(itemStack) * this.powerLevels);
            FluidStack consumed = this.consume(toDrain, itemStack, player);
            int consumedAmount = consumed == null ? 0 : consumed.getAmount();
            itemUsedCount = consumedAmount * this.func_77626_a(itemStack) / fluidHandler.getCapacity();
            if (consumedAmount > 0) {
                this.use(world, entity, itemUsedCount, this.getPower(itemStack));
                if (world.func_201670_d()) {
                    this.showUsedItemTick(world, entity, this.getPower(itemStack));
                }
            } else if (world.func_201670_d()) {
                this.animateOutOfEnergy(world, entity);
            }
        }
    }

    protected abstract void use(World var1, LivingEntity var2, int var3, int var4);

    @OnlyIn(value=Dist.CLIENT)
    protected void animateOutOfEnergy(World world, LivingEntity entity) {
        double xCoord = entity.func_226277_ct_();
        double yCoord = entity.func_226278_cu_();
        double zCoord = entity.func_226281_cx_();
        float particleMotionX = world.field_73012_v.nextFloat() * 0.2f - 0.1f;
        float particleMotionY = 0.2f;
        float particleMotionZ = world.field_73012_v.nextFloat() * 0.2f - 0.1f;
        world.func_195594_a((IParticleData)ParticleTypes.field_197601_L, xCoord, yCoord, zCoord, (double)particleMotionX, (double)particleMotionY, (double)particleMotionZ);
        world.func_184148_a(null, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), SoundEvents.field_187676_dE, SoundCategory.NEUTRAL, 0.5f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
    }

    public int func_77619_b() {
        return 15;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack itemStack) {
        if (slot == EquipmentSlotType.MAINHAND) {
            return ImmutableMultimap.of((Object)Attributes.field_233823_f_, (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)this.meleeDamage, AttributeModifier.Operation.ADDITION));
        }
        return super.getAttributeModifiers(slot, itemStack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack itemStack, World world, List<ITextComponent> list, ITooltipFlag flag) {
        ItemPowerableHelpers.addPreInformation(itemStack, list);
        super.func_77624_a(itemStack, world, list, flag);
        ItemPowerableHelpers.addPostInformation(itemStack, list);
    }

    public int getPower(ItemStack itemStack) {
        return ItemPowerableHelpers.getPower(itemStack);
    }
}

