/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.cyclops.evilcraft.Advancements;
import org.cyclops.evilcraft.ExtendedDamageSource;
import org.cyclops.evilcraft.entity.monster.EntityVengeanceSpirit;
import org.cyclops.evilcraft.item.ItemMace;

public class ItemMaceOfDistortion
extends ItemMace {
    public static final int AOE_TICK_UPDATE = 20;
    private static final int MAXIMUM_CHARGE = 100;
    private static final float MELEE_DAMAGE = 7.0f;
    private static final float RADIAL_DAMAGE = 3.0f;
    private static final int CONTAINER_SIZE = 4000;
    private static final int HIT_USAGE = 5;
    private static final int POWER_LEVELS = 5;

    public ItemMaceOfDistortion(Item.Properties properties) {
        super(properties, 4000, 5, 100, 5, 7.0f);
    }

    protected void distortEntities(World world, LivingEntity initiator, int itemUsedCount, int power) {
        double x = initiator.func_226277_ct_();
        double y = initiator.func_226278_cu_();
        double z = initiator.func_226281_cx_();
        double area = this.getArea(itemUsedCount);
        AxisAlignedBB box = new AxisAlignedBB(x, y, z, x, y, z).func_186662_g(area);
        List entities = world.func_72839_b((Entity)initiator, box);
        boolean onePlayer = false;
        for (Entity entity : entities) {
            if (entity instanceof PlayerEntity) {
                onePlayer = true;
            }
            this.distortEntity(world, initiator, entity, x, y, z, itemUsedCount, power);
        }
        if (initiator instanceof ServerPlayerEntity) {
            Advancements.DISTORT.test((ServerPlayerEntity)initiator, entities);
        }
    }

    public void distortEntity(World world, @Nullable LivingEntity initiator, Entity entity, double x, double y, double z, int itemUsedCount, int power) {
        double dz;
        double dy;
        double inverseStrength = initiator != null ? (double)(entity.func_70032_d((Entity)initiator) / (float)(itemUsedCount + 1)) : 0.1;
        double knock = (double)(power + itemUsedCount / 200) + 1.0;
        double dx = entity.func_226277_ct_() - x;
        double d = MathHelper.func_76133_a((double)(dx * dx + (dy = entity.func_226278_cu_() + (double)entity.func_70047_e() - y) * dy + (dz = entity.func_226281_cx_() - z) * dz));
        if (d != 0.0) {
            dx /= d;
            dy /= d;
            dz /= d;
            double strength = (1.0 - inverseStrength) * knock;
            if (entity instanceof LivingEntity) {
                ExtendedDamageSource damageSource = initiator == null ? ExtendedDamageSource.distorted : (initiator instanceof PlayerEntity ? DamageSource.func_76365_a((PlayerEntity)((PlayerEntity)initiator)) : DamageSource.func_76358_a((LivingEntity)initiator));
                entity.func_70097_a((DamageSource)damageSource, 3.0f * (float)power);
                if (world.func_201670_d()) {
                    ItemMaceOfDistortion.showEntityDistored(world, initiator, entity, power);
                }
            }
            if (entity instanceof EntityVengeanceSpirit) {
                ((EntityVengeanceSpirit)entity).setSwarm(true);
            }
            entity.func_213317_d(entity.func_213322_ci().func_216372_d(strength /= 2.0, strength, strength));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void showEntityDistored(World world, LivingEntity initiator, Entity entity, int power) {
        world.func_184148_a(null, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), SoundEvents.field_187539_bB, SoundCategory.BLOCKS, (float)(power + 1) / 5.0f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
        if (initiator != null) {
            world.func_184148_a(null, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), SoundEvents.field_187539_bB, SoundCategory.BLOCKS, (float)(power + 1) / 5.0f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
        }
        world.func_195594_a((IParticleData)ParticleTypes.field_197627_t, entity.func_226277_ct_(), entity.func_226278_cu_() + (double)field_77697_d.nextFloat(), entity.func_226281_cx_(), 1.0, 0.0, 0.0);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void animateOutOfEnergy(World world, PlayerEntity player) {
        double xCoord = player.func_226277_ct_();
        double yCoord = player.func_226278_cu_();
        double zCoord = player.func_226281_cx_();
        float particleMotionX = world.field_73012_v.nextFloat() * 0.2f - 0.1f;
        float particleMotionY = 0.2f;
        float particleMotionZ = world.field_73012_v.nextFloat() * 0.2f - 0.1f;
        world.func_195594_a((IParticleData)ParticleTypes.field_197601_L, xCoord, yCoord, zCoord, (double)particleMotionX, (double)particleMotionY, (double)particleMotionZ);
        world.func_184148_a(player, xCoord, yCoord, zCoord, SoundEvents.field_187676_dE, SoundCategory.RECORDS, 0.5f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
    }

    @Override
    public int func_77619_b() {
        return 15;
    }

    public Multimap getAttributeModifiers(EquipmentSlotType slot, ItemStack itemStack) {
        if (slot == EquipmentSlotType.MAINHAND) {
            return ImmutableMultimap.of((Object)Attributes.field_233823_f_, (Object)new AttributeModifier(field_111210_e, "Weapon modifier", 7.0, AttributeModifier.Operation.ADDITION));
        }
        return super.getAttributeModifiers(slot, itemStack);
    }

    @Override
    protected void use(World world, LivingEntity entity, int itemUsedCount, int power) {
        this.distortEntities(world, entity, itemUsedCount, power);
    }
}

