/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.item;

import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.evilcraft.core.helper.ItemHelpers;

public class ItemPowerableHelpers {
    private static final String NBT_KEY_POWER = "power";

    public static int getPower(ItemStack itemStack) {
        return ItemHelpers.getNBTInt(itemStack, NBT_KEY_POWER);
    }

    public static void setPower(ItemStack itemStack, int power) {
        ItemHelpers.setNBTInt(itemStack, power, NBT_KEY_POWER);
    }

    public static boolean onPowerableItemItemRightClick(ItemStack itemStack, World world, PlayerEntity player, int powerLevels, boolean onSneak) {
        if (onSneak == player.func_213453_ef()) {
            if (!world.func_201670_d()) {
                int newPower = (ItemPowerableHelpers.getPower(itemStack) + 1) % powerLevels;
                ItemPowerableHelpers.setPower(itemStack, newPower);
                player.func_146105_b((ITextComponent)new TranslationTextComponent("item.evilcraft.powerable.set_power", new Object[]{newPower}).func_240699_a_(TextFormatting.DARK_PURPLE), true);
            }
            return true;
        }
        return false;
    }

    public static void addPreInformation(ItemStack itemStack, List<ITextComponent> lines) {
        L10NHelpers.addOptionalInfo(lines, (String)"item.evilcraft.powerable");
    }

    public static void addPostInformation(ItemStack itemStack, List<ITextComponent> lines) {
        lines.add((ITextComponent)new TranslationTextComponent("item.evilcraft.powerable.info.power", new Object[]{ItemPowerableHelpers.getPower(itemStack)}).func_240699_a_(TextFormatting.BOLD));
    }
}

