/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.PotionUtils;
import net.minecraft.stats.Stat;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.network.NetworkHooks;
import org.cyclops.cyclopscore.inventory.NBTSimpleInventoryItemHeld;
import org.cyclops.cyclopscore.inventory.NBTSimpleInventoryItemStack;
import org.cyclops.cyclopscore.inventory.container.NamedContainerProviderItem;
import org.cyclops.evilcraft.core.item.ItemBloodContainer;
import org.cyclops.evilcraft.inventory.container.ContainerPrimedPendant;
import org.cyclops.evilcraft.item.ItemPrimedPendantConfig;

public class ItemPrimedPendant
extends ItemBloodContainer {
    private static final int TICK_MODULUS = 10;

    public ItemPrimedPendant(Item.Properties properties) {
        super(properties, ItemPrimedPendantConfig.capacity);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack itemStack, World world, List<ITextComponent> list, ITooltipFlag flag) {
        super.func_77624_a(itemStack, world, list, flag);
        ItemStack potionStack = this.getPotionStack(itemStack);
        if (!potionStack.func_190926_b()) {
            List potionEffects = PotionUtils.func_185189_a((ItemStack)potionStack);
            for (EffectInstance potionEffect : potionEffects) {
                TranslationTextComponent textComponent = new TranslationTextComponent(super.func_77667_c(itemStack) + ".potion", new Object[]{new TranslationTextComponent(potionEffect.func_76453_d()), new TranslationTextComponent("enchantment.level." + (potionEffect.func_76458_c() + 1))});
                Double multiplier = ItemPrimedPendantConfig.getMultiplier(potionEffect.func_188419_a());
                if (multiplier != null && multiplier < 0.0) {
                    textComponent.func_240699_a_(TextFormatting.STRIKETHROUGH);
                }
                list.add((ITextComponent)textComponent);
            }
        }
    }

    public void func_77663_a(ItemStack itemStack, World world, Entity entity, int par4, boolean par5) {
        if (entity instanceof PlayerEntity && world.func_82737_E() % 10L == 0L) {
            PlayerEntity player = (PlayerEntity)entity;
            ItemStack potionStack = this.getPotionStack(itemStack);
            if (!potionStack.func_190926_b()) {
                List potionEffects = PotionUtils.func_185189_a((ItemStack)potionStack);
                for (EffectInstance potionEffect : potionEffects) {
                    int toDrain = ItemPrimedPendantConfig.usage * (potionEffect.func_76458_c() + 1);
                    Double multiplier = ItemPrimedPendantConfig.getMultiplier(potionEffect.func_188419_a());
                    if (multiplier != null) {
                        toDrain = (int)((double)toDrain * multiplier);
                    }
                    if (multiplier != null && !(multiplier >= 0.0) || !this.canConsume(toDrain, itemStack, player)) continue;
                    player.func_195064_c(new EffectInstance(potionEffect.func_188419_a(), 270, potionEffect.func_76458_c(), !potionEffect.getCurativeItems().isEmpty(), true));
                    this.consume(toDrain, itemStack, player);
                }
            }
        }
        super.func_77663_a(itemStack, world, entity, par4, par5);
    }

    public boolean hasPotionStack(ItemStack itemStack) {
        return !this.getPotionStack(itemStack).func_190926_b();
    }

    public ItemStack getPotionStack(ItemStack itemStack) {
        IInventory inventory = this.getSupplementaryInventory(itemStack);
        return inventory.func_70301_a(0);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_77636_d(ItemStack itemStack) {
        return this.hasPotionStack(itemStack);
    }

    public IInventory getSupplementaryInventory(PlayerEntity player, ItemStack itemStack, int itemIndex, Hand hand) {
        return new NBTSimpleInventoryItemHeld(player, itemIndex, hand, 1, 64, "inventoryItem");
    }

    public IInventory getSupplementaryInventory(ItemStack itemStack) {
        return new NBTSimpleInventoryItemStack(itemStack, 1, 64, "inventoryItem");
    }

    @Nullable
    public INamedContainerProvider getContainer(World world, PlayerEntity playerEntity, int itemIndex, Hand hand, ItemStack itemStack) {
        return new NamedContainerProviderItem(itemIndex, hand, itemStack.func_200301_q(), ContainerPrimedPendant::new);
    }

    public Class<? extends Container> getContainerClass(World world, PlayerEntity playerEntity, ItemStack itemStack) {
        return ContainerPrimedPendant.class;
    }

    public boolean onDroppedByPlayer(ItemStack itemstack, PlayerEntity player) {
        if (!itemstack.func_190926_b() && player instanceof ServerPlayerEntity && player.field_71070_bA != null && player.field_71070_bA.getClass() == this.getContainerClass(player.field_70170_p, player, itemstack)) {
            player.func_71053_j();
        }
        return super.onDroppedByPlayer(itemstack, player);
    }

    public void openGuiForItemIndex(World world, ServerPlayerEntity player, int itemIndex, Hand hand) {
        INamedContainerProvider containerProvider;
        if (!world.func_201670_d() && (containerProvider = this.getContainer(world, (PlayerEntity)player, itemIndex, hand, player.func_184586_b(hand))) != null) {
            NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)containerProvider, packetBuffer -> this.writeExtraGuiData((PacketBuffer)packetBuffer, world, player, itemIndex, hand));
            Stat<ResourceLocation> openStat = this.getOpenStat();
            if (openStat != null) {
                player.func_71029_a(openStat);
            }
        }
    }

    public void writeExtraGuiData(PacketBuffer packetBuffer, World world, ServerPlayerEntity player, int itemIndex, Hand hand) {
        packetBuffer.writeInt(itemIndex);
        packetBuffer.writeBoolean(hand == Hand.MAIN_HAND);
    }

    @Nullable
    protected Stat<ResourceLocation> getOpenStat() {
        return null;
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack itemStack = player.func_184586_b(hand);
        if (player instanceof FakePlayer) {
            return new ActionResult(ActionResultType.FAIL, (Object)itemStack);
        }
        if (player instanceof ServerPlayerEntity) {
            this.openGuiForItemIndex(world, (ServerPlayerEntity)player, player.field_71071_by.field_70461_c, hand);
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)itemStack);
    }
}

