/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.item;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.cyclops.cyclopscore.config.extendedconfig.BlockConfig;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.core.tileentity.upgrade.Upgrades;

public class ItemPromise
extends Item {
    public static final Upgrades.Upgrade[] UPGRADES = new Upgrades.Upgrade[]{Upgrades.UPGRADE_TIER1, Upgrades.UPGRADE_TIER2, Upgrades.UPGRADE_TIER3, Upgrades.UPGRADE_SPEED, Upgrades.UPGRADE_EFFICIENCY};
    public static final Map<Upgrades.Upgrade, Integer> MAIN_COLORS = Maps.newHashMap();
    public static final Map<Upgrades.Upgrade, Integer> SECONDARY_COLORS = Maps.newHashMap();
    private final Upgrades.Upgrade upgrade;

    public ItemPromise(Item.Properties properties, Upgrades.Upgrade upgrade) {
        super(properties);
        this.upgrade = upgrade;
    }

    public int getItemStackLimit(ItemStack itemStack) {
        if (this.upgrade.getTier() > 0) {
            return 1;
        }
        return super.getItemStackLimit(itemStack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack itemStack, World world, List<ITextComponent> list, ITooltipFlag flag) {
        super.func_77624_a(itemStack, world, list, flag);
        if (MinecraftHelpers.isShifted()) {
            list.add((ITextComponent)new TranslationTextComponent("item.evilcraft.promise.use_in").func_240699_a_(TextFormatting.DARK_GREEN));
            for (BlockConfig upgradable : this.getUpgrade(itemStack).getUpgradables()) {
                list.add((ITextComponent)new TranslationTextComponent(upgradable.getTranslationKey()).func_240699_a_(TextFormatting.ITALIC));
            }
        }
    }

    public Upgrades.Upgrade getUpgrade(ItemStack itemStack) {
        return this.upgrade;
    }

    public static Item getItem(int tier) {
        if (tier == 1) {
            return ItemPromise.getItem(Upgrades.UPGRADE_TIER1);
        }
        if (tier == 2) {
            return ItemPromise.getItem(Upgrades.UPGRADE_TIER2);
        }
        if (tier == 3) {
            return ItemPromise.getItem(Upgrades.UPGRADE_TIER3);
        }
        throw new IllegalStateException("Could not find an item for tier " + tier);
    }

    public static Item getItem(Upgrades.Upgrade upgrade) {
        if (upgrade == Upgrades.UPGRADE_TIER1) {
            return RegistryEntries.ITEM_PROMISE_TIER_1;
        }
        if (upgrade == Upgrades.UPGRADE_TIER2) {
            return RegistryEntries.ITEM_PROMISE_TIER_2;
        }
        if (upgrade == Upgrades.UPGRADE_TIER3) {
            return RegistryEntries.ITEM_PROMISE_TIER_3;
        }
        if (upgrade == Upgrades.UPGRADE_SPEED) {
            return RegistryEntries.ITEM_PROMISE_SPEED;
        }
        if (upgrade == Upgrades.UPGRADE_EFFICIENCY) {
            return RegistryEntries.ITEM_PROMISE_EFFICIENCY;
        }
        throw new IllegalStateException("Could not find an item for " + upgrade);
    }

    public boolean isTierUpgrade(ItemStack itemStack) {
        return !itemStack.func_190926_b() && this.upgrade.getTier() > 0;
    }

    public Rarity func_77613_e(ItemStack itemStack) {
        return this.upgrade.getTier() > 0 ? Rarity.RARE : Rarity.UNCOMMON;
    }

    static {
        MAIN_COLORS.put(Upgrades.UPGRADE_TIER1, Helpers.RGBToInt((int)220, (int)220, (int)220));
        SECONDARY_COLORS.put(Upgrades.UPGRADE_TIER1, Helpers.RGBToInt((int)255, (int)255, (int)255));
        MAIN_COLORS.put(Upgrades.UPGRADE_TIER2, Helpers.RGBToInt((int)234, (int)238, (int)87));
        SECONDARY_COLORS.put(Upgrades.UPGRADE_TIER2, Helpers.RGBToInt((int)230, (int)230, (int)160));
        MAIN_COLORS.put(Upgrades.UPGRADE_TIER3, Helpers.RGBToInt((int)51, (int)235, (int)203));
        SECONDARY_COLORS.put(Upgrades.UPGRADE_TIER3, Helpers.RGBToInt((int)150, (int)250, (int)200));
        MAIN_COLORS.put(Upgrades.UPGRADE_SPEED, Helpers.RGBToInt((int)200, (int)90, (int)80));
        SECONDARY_COLORS.put(Upgrades.UPGRADE_SPEED, Helpers.RGBToInt((int)240, (int)120, (int)110));
        MAIN_COLORS.put(Upgrades.UPGRADE_EFFICIENCY, Helpers.RGBToInt((int)80, (int)70, (int)200));
        SECONDARY_COLORS.put(Upgrades.UPGRADE_EFFICIENCY, Helpers.RGBToInt((int)120, (int)120, (int)210));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class ItemColor
    implements IItemColor {
        public int getColor(ItemStack itemStack, int renderPass) {
            Upgrades.Upgrade upgrade = ((ItemPromise)itemStack.func_77973_b()).getUpgrade(itemStack);
            return renderPass == 0 ? SECONDARY_COLORS.get(upgrade).intValue() : MAIN_COLORS.get(upgrade).intValue();
        }
    }
}

