/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.item;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.helper.WorldHelpers;
import org.cyclops.evilcraft.core.helper.ItemHelpers;
import org.cyclops.evilcraft.entity.monster.EntityVengeanceSpirit;
import org.cyclops.evilcraft.entity.monster.EntityVengeanceSpiritConfig;
import org.cyclops.evilcraft.item.ItemVengeanceRingConfig;

public class ItemVengeanceRing
extends Item {
    private static final int BONUS_TICK_MODULUS = 5;
    private static final int BONUS_POTION_DURATION = 60;
    private static final List<Triple<Effect, Integer, Integer>> RING_POWERS = Lists.newArrayList((Object[])new Triple[]{Triple.of((Object)Effects.field_76430_j, (Object)60, (Object)2), Triple.of((Object)Effects.field_76441_p, (Object)60, (Object)1), Triple.of((Object)Effects.field_76424_c, (Object)60, (Object)1), Triple.of((Object)Effects.field_76422_e, (Object)60, (Object)1)});

    public ItemVengeanceRing(Item.Properties properties) {
        super(properties);
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack itemStack = player.func_184586_b(hand);
        if (player.func_213453_ef()) {
            if (!world.func_201670_d()) {
                ItemHelpers.toggleActivation(itemStack);
            }
            return MinecraftHelpers.successAction((Object)itemStack);
        }
        return super.func_77659_a(world, player, hand);
    }

    public boolean func_77636_d(ItemStack itemStack) {
        return ItemHelpers.isActivated(itemStack);
    }

    public static void toggleVengeanceArea(World world, Entity entity, int area, boolean enableVengeance, boolean spawnRandom, boolean forceGlobal) {
        if (world.func_175659_aa() != Difficulty.PEACEFUL) {
            EntityVengeanceSpirit spirit;
            double x = entity.func_226277_ct_();
            double y = entity.func_226278_cu_();
            double z = entity.func_226281_cx_();
            BlockPos blockPos = entity.func_233580_cy_();
            AxisAlignedBB box = new AxisAlignedBB(x, y, z, x, y, z).func_72314_b((double)area, (double)area, (double)area);
            List spirits = world.func_175647_a(EntityVengeanceSpirit.class, box, (Predicate)new com.google.common.base.Predicate<Entity>(){

                public boolean apply(Entity entity) {
                    return entity instanceof EntityVengeanceSpirit;
                }
            });
            for (EntityVengeanceSpirit spirit2 : spirits) {
                spirit2.setEnabledVengeance((PlayerEntity)entity, enableVengeance);
                if (enableVengeance) {
                    spirit2.func_70624_b((LivingEntity)entity);
                    continue;
                }
                if (spirit2.func_70638_az() != entity) continue;
                spirit2.func_70624_b(null);
            }
            if (spirits.size() == 0 && enableVengeance && (spirit = EntityVengeanceSpirit.spawnRandom(world, blockPos, area / 4)) != null) {
                if (forceGlobal) {
                    spirit.setGlobalVengeance(true);
                } else {
                    spirit.setEnabledVengeance((PlayerEntity)entity, true);
                }
                spirit.func_70624_b((LivingEntity)entity);
                int chance = EntityVengeanceSpiritConfig.nonDegradedSpawnChance;
                spirit.setSwarm(chance <= 0 || world.field_73012_v.nextInt(chance) > 0);
            }
        }
    }

    public static void updateRingPowers(PlayerEntity player) {
        for (Triple<Effect, Integer, Integer> power : RING_POWERS) {
            player.func_195064_c(new EffectInstance((Effect)power.getLeft(), ((Integer)power.getMiddle()).intValue(), ((Integer)power.getRight()).intValue(), false, true));
        }
    }

    public void func_77663_a(ItemStack itemStack, World world, Entity entity, int par4, boolean par5) {
        if (entity instanceof PlayerEntity && !world.func_201670_d() && WorldHelpers.efficientTick((World)world, (int)5, (int[])new int[]{entity.func_145782_y()})) {
            int area = ItemVengeanceRingConfig.areaOfEffect;
            ItemVengeanceRing.toggleVengeanceArea(world, entity, area, ItemHelpers.isActivated(itemStack), true, false);
            if (ItemHelpers.isActivated(itemStack)) {
                ItemVengeanceRing.updateRingPowers((PlayerEntity)entity);
            }
        }
        super.func_77663_a(itemStack, world, entity, par4, par5);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack itemStack, World world, List<ITextComponent> list, ITooltipFlag flag) {
        super.func_77624_a(itemStack, world, list, flag);
        L10NHelpers.addStatusInfo(list, (boolean)ItemHelpers.isActivated(itemStack), (String)(this.func_77658_a() + ".info.status"));
    }
}

