/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.item;

import java.util.List;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.evilcraft.core.weather.WeatherType;
import org.cyclops.evilcraft.entity.item.EntityWeatherContainer;

public class ItemWeatherContainer
extends Item {
    public ItemWeatherContainer(Item.Properties properties) {
        super(properties);
    }

    public static WeatherContainerType getWeatherType(ItemStack itemStack) {
        CompoundNBT tag = itemStack.func_77978_p();
        if (tag != null) {
            try {
                return WeatherContainerType.valueOf(tag.func_74779_i("weather"));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return WeatherContainerType.EMPTY;
    }

    public static void setWeatherType(ItemStack itemStack, WeatherContainerType type) {
        CompoundNBT tag = itemStack.func_196082_o();
        tag.func_74778_a("weather", type.name());
    }

    public UseAction func_77661_b(ItemStack itemStack) {
        return UseAction.BOW;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack itemStack = player.func_184586_b(hand);
        if (!world.func_201670_d() && ItemWeatherContainer.getWeatherType(itemStack) != WeatherContainerType.EMPTY) {
            world.func_184148_a(player, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187737_v, SoundCategory.NEUTRAL, 0.5f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
            EntityWeatherContainer entity = new EntityWeatherContainer(world, (LivingEntity)player, itemStack.func_77946_l());
            entity.func_234612_a_((Entity)player, player.field_70125_A, player.field_70177_z, -20.0f, 0.5f, 1.0f);
            world.func_217376_c((Entity)entity);
            itemStack.func_190918_g(1);
        }
        return MinecraftHelpers.successAction((Object)itemStack);
    }

    public void onUse(ServerWorld world, ItemStack itemStack) {
        ItemWeatherContainer.getWeatherType(itemStack).onUse(world, itemStack);
    }

    public void onFill(ServerWorld world, ItemStack itemStack) {
        ItemWeatherContainer.getWeatherType(itemStack).onFill(world, itemStack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack itemStack, World world, List<ITextComponent> list, ITooltipFlag flag) {
        WeatherContainerType type = ItemWeatherContainer.getWeatherType(itemStack);
        list.add((ITextComponent)type.description.func_240699_a_(type.damageColor));
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            for (WeatherContainerType type : WeatherContainerType.values()) {
                ItemStack stack = new ItemStack((IItemProvider)this);
                ItemWeatherContainer.setWeatherType(stack, type);
                items.add((Object)stack);
            }
        }
    }

    public Rarity func_77613_e(ItemStack itemStack) {
        return ItemWeatherContainer.getWeatherType(itemStack).rarity;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class ItemColor
    implements IItemColor {
        public int getColor(ItemStack itemStack, int renderPass) {
            return renderPass > 0 ? 0xFFFFFF : ItemWeatherContainer.getWeatherType(itemStack).damageRenderColor;
        }
    }

    public static enum WeatherContainerType {
        EMPTY(null, "empty", TextFormatting.GRAY, Helpers.RGBToInt((int)125, (int)125, (int)125), Rarity.COMMON),
        CLEAR(WeatherType.CLEAR, "clear", TextFormatting.AQUA, Helpers.RGBToInt((int)30, (int)150, (int)230), Rarity.UNCOMMON),
        RAIN(WeatherType.RAIN, "rain", TextFormatting.DARK_BLUE, Helpers.RGBToInt((int)0, (int)0, (int)255), Rarity.UNCOMMON),
        LIGHTNING(WeatherType.LIGHTNING, "lightning", TextFormatting.GOLD, Helpers.RGBToInt((int)255, (int)215, (int)0), Rarity.RARE);

        private final WeatherType type;
        private final IFormattableTextComponent description;
        private final TextFormatting damageColor;
        private final int damageRenderColor;
        private final Rarity rarity;

        private WeatherContainerType(WeatherType type, String description, TextFormatting damageColor, int damageRenderColor, Rarity rarity) {
            this.type = type;
            this.description = new TranslationTextComponent("weather_container.evilcraft." + description);
            this.damageColor = damageColor;
            this.damageRenderColor = damageRenderColor;
            this.rarity = rarity;
        }

        public void onFill(ServerWorld world, ItemStack containerStack) {
            WeatherContainerType currentWeatherType = EMPTY;
            for (WeatherContainerType type : WeatherContainerType.values()) {
                if (type.type == null || !type.type.isActive((World)world)) continue;
                currentWeatherType = type;
            }
            ItemWeatherContainer.setWeatherType(containerStack, currentWeatherType);
            currentWeatherType.type.deactivate(world);
        }

        public void onUse(ServerWorld world, ItemStack containerStack) {
            if (world.func_201670_d()) {
                return;
            }
            if (this.type != null) {
                this.type.activate(world);
            }
            ItemWeatherContainer.setWeatherType(containerStack, EMPTY);
        }

        public static WeatherContainerType getWeatherContainerType(WeatherType weatherType) {
            for (WeatherContainerType type : WeatherContainerType.values()) {
                if (type.type != weatherType) continue;
                return type;
            }
            return null;
        }
    }
}

