/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.item;

import com.mojang.authlib.GameProfile;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Food;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.evilcraft.item.ItemWerewolfFleshConfig;

public class ItemWerewolfFlesh
extends Item {
    private static final int POISON_DURATION = 10;
    private static final int POWER_DURATION = 60;
    private static final int POWER_DURATION_BONUS = 240;
    private final boolean humanoid;
    private boolean power = false;
    public static final int MINECRAFT_DAY = 24000;

    public ItemWerewolfFlesh(Item.Properties properties, boolean humanoid) {
        super(properties.func_221540_a(new Food.Builder().func_221456_a(-5).func_221454_a(0.0f).func_221455_b().func_221453_d()));
        this.humanoid = humanoid;
        if (this.humanoid) {
            MinecraftForge.EVENT_BUS.addListener(this::dropHumanoidFleshEvent);
        }
    }

    public static boolean isDay(World world) {
        return world.func_72820_D() % 24000L < 12000L;
    }

    private boolean isPower(World world) {
        return world == null ? this.power : (this.power = !ItemWerewolfFlesh.isDay(world));
    }

    @OnlyIn(value=Dist.CLIENT)
    public Rarity func_77613_e(ItemStack itemStack) {
        return this.isHumanFlesh(itemStack) ? Rarity.RARE : Rarity.EPIC;
    }

    public boolean func_77636_d(ItemStack itemStack) {
        return this.isPower(null);
    }

    public void func_77663_a(ItemStack itemStack, World world, Entity player, int par4, boolean par5) {
        this.isPower(world);
    }

    private int getPowerDuration(ItemStack itemStack) {
        if (this.isHumanFlesh(itemStack)) {
            return 60;
        }
        return 240;
    }

    private boolean isHumanFlesh(ItemStack itemStack) {
        return this.humanoid;
    }

    private boolean isOwnCanibal(ItemStack itemStack, PlayerEntity player) {
        if (itemStack.func_77942_o()) {
            GameProfile profile = NBTUtil.func_152459_a((CompoundNBT)itemStack.func_77978_p());
            return player.func_146103_bH().equals((Object)profile);
        }
        return false;
    }

    public ItemStack func_77654_b(ItemStack itemStack, @Nullable World world, LivingEntity entity) {
        if (world != null && entity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity;
            if (player instanceof ServerPlayerEntity) {
                CriteriaTriggers.field_193138_y.func_193148_a((ServerPlayerEntity)player, itemStack);
            }
            itemStack.func_190918_g(1);
            if (this.isOwnCanibal(itemStack, player)) {
                if (!world.func_201670_d()) {
                    player.func_195064_c(new EffectInstance(Effects.field_82731_v, 200, 1));
                    player.func_195064_c(new EffectInstance(Effects.field_76440_q, this.getPowerDuration(itemStack) * 20, 1));
                }
                world.func_184148_a(player, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187863_gH, SoundCategory.HOSTILE, 0.5f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
            } else if (this.isPower(world)) {
                int foodLevel = this.func_219967_s().func_221466_a();
                float saturationLevel = this.func_219967_s().func_221469_b();
                player.func_71024_bL().func_75122_a(foodLevel, saturationLevel);
                if (!world.func_201670_d()) {
                    player.func_195064_c(new EffectInstance(Effects.field_76420_g, this.getPowerDuration(itemStack) * 20, 2));
                    player.func_195064_c(new EffectInstance(Effects.field_76424_c, this.getPowerDuration(itemStack) * 20, 2));
                    player.func_195064_c(new EffectInstance(Effects.field_76430_j, this.getPowerDuration(itemStack) * 20, 2));
                    player.func_195064_c(new EffectInstance(Effects.field_76439_r, this.getPowerDuration(itemStack) * 20, 2));
                }
                world.func_184148_a(player, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_189111_gN, SoundCategory.HOSTILE, 0.5f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
            } else {
                if (!world.func_201670_d()) {
                    player.func_195064_c(new EffectInstance(Effects.field_76436_u, 200, 1));
                }
                world.func_184148_a(player, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187863_gH, SoundCategory.HOSTILE, 0.5f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
            entity.func_213357_a(world, itemStack);
        }
        return itemStack;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack itemStack, World world, List<ITextComponent> list, ITooltipFlag flag) {
        super.func_77624_a(itemStack, world, list, flag);
        if (this.isHumanFlesh(itemStack)) {
            GameProfile profile;
            String player = TextFormatting.ITALIC + "None";
            if (itemStack.func_77942_o() && (profile = NBTUtil.func_152459_a((CompoundNBT)itemStack.func_77978_p())) != null) {
                player = profile.getName();
            }
            list.add((ITextComponent)new StringTextComponent("Player: ").func_240699_a_(TextFormatting.WHITE).func_240702_b_(player));
        }
    }

    public void dropHumanoidFleshEvent(LivingDeathEvent event) {
        if (event.getEntityLiving() instanceof ServerPlayerEntity && !event.getEntityLiving().field_70170_p.func_201670_d() && event.getEntityLiving().field_70170_p.field_73012_v.nextInt(ItemWerewolfFleshConfig.humanoidFleshDropChance) == 0) {
            ServerPlayerEntity player = (ServerPlayerEntity)event.getEntityLiving();
            ItemStack itemStack = new ItemStack((IItemProvider)this);
            CompoundNBT tag = itemStack.func_196082_o();
            NBTUtil.func_180708_a((CompoundNBT)tag, (GameProfile)player.func_146103_bH());
            double x = player.func_226277_ct_();
            double y = player.func_226278_cu_();
            double z = player.func_226281_cx_();
            ItemEntity entity = new ItemEntity(player.field_70170_p, x, y, z, itemStack);
            player.field_70170_p.func_217376_c((Entity)entity);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class ItemColor
    implements IItemColor {
        public int getColor(ItemStack itemStack, int renderPass) {
            if (((ItemWerewolfFlesh)itemStack.func_77973_b()).isHumanFlesh(itemStack)) {
                return Helpers.RGBToInt((int)255, (int)200, (int)180);
            }
            return -1;
        }
    }
}

