/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.metadata;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraftforge.fluids.FluidStack;
import org.cyclops.cyclopscore.metadata.IRegistryExportable;
import org.cyclops.cyclopscore.metadata.RegistryExportableRecipeAbstract;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.core.recipe.type.IInventoryFluidTier;
import org.cyclops.evilcraft.core.recipe.type.RecipeBloodInfuser;

public class RegistryExportableBloodInfuserRecipe
extends RegistryExportableRecipeAbstract<IRecipeType<RecipeBloodInfuser>, RecipeBloodInfuser, IInventoryFluidTier> {
    protected RegistryExportableBloodInfuserRecipe() {
        super(() -> RegistryEntries.RECIPETYPE_BLOOD_INFUSER);
    }

    public JsonObject serializeRecipe(RecipeBloodInfuser recipe) {
        return RegistryExportableBloodInfuserRecipe.serializeRecipeStatic(recipe);
    }

    public static JsonObject serializeRecipeStatic(RecipeBloodInfuser recipe) {
        JsonObject object = new JsonObject();
        object.addProperty("tier", (Number)recipe.getInputTier());
        object.addProperty("duration", (Number)recipe.getDuration());
        object.addProperty("xp", (Number)Float.valueOf(recipe.getXp()));
        JsonObject inputObject = new JsonObject();
        ItemStack[] inputItems = recipe.getInputIngredient().func_193365_a();
        JsonArray arrayInputs = new JsonArray();
        for (ItemStack input : inputItems) {
            arrayInputs.add((JsonElement)IRegistryExportable.serializeItemStack((ItemStack)input));
        }
        inputObject.add("item", (JsonElement)arrayInputs);
        FluidStack inputFluid = recipe.getInputFluid();
        if (inputFluid != null) {
            inputObject.add("fluid", (JsonElement)IRegistryExportable.serializeFluidStack((FluidStack)inputFluid));
        }
        JsonObject outputObject = new JsonObject();
        ItemStack itemOutput = recipe.getOutputItem();
        outputObject.add("item", (JsonElement)IRegistryExportable.serializeItemStack((ItemStack)itemOutput));
        object.add("input", (JsonElement)inputObject);
        object.add("output", (JsonElement)outputObject);
        return object;
    }
}

