/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.metadata;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraftforge.fluids.FluidStack;
import org.cyclops.cyclopscore.metadata.IRegistryExportable;
import org.cyclops.cyclopscore.metadata.RegistryExportableRecipeAbstract;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.core.recipe.type.RecipeEnvironmentalAccumulator;
import org.cyclops.evilcraft.tileentity.tickaction.sanguinaryenvironmentalaccumulator.AccumulateItemTickAction;

public class RegistryExportableEnvirAccRecipe
extends RegistryExportableRecipeAbstract<IRecipeType<RecipeEnvironmentalAccumulator>, RecipeEnvironmentalAccumulator, RecipeEnvironmentalAccumulator.Inventory> {
    public RegistryExportableEnvirAccRecipe() {
        super(() -> RegistryEntries.RECIPETYPE_ENVIRONMENTAL_ACCUMULATOR);
    }

    public JsonObject serializeRecipe(RecipeEnvironmentalAccumulator recipe) {
        return RegistryExportableEnvirAccRecipe.serializeRecipeStatic(recipe);
    }

    public static JsonObject serializeRecipeStatic(RecipeEnvironmentalAccumulator recipe) {
        JsonObject object = new JsonObject();
        ItemStack[] inputItems = recipe.getInputIngredient().func_193365_a();
        JsonArray arrayInputs = new JsonArray();
        for (ItemStack input : inputItems) {
            arrayInputs.add((JsonElement)IRegistryExportable.serializeItemStack((ItemStack)input));
        }
        object.add("input", (JsonElement)arrayInputs);
        object.add("output", (JsonElement)IRegistryExportable.serializeItemStack((ItemStack)recipe.getOutputItem()));
        object.addProperty("inputWeather", recipe.getInputWeather().toString());
        object.addProperty("outputWeather", recipe.getOutputWeather().toString());
        object.addProperty("duration", (Number)recipe.getDuration());
        int amount = AccumulateItemTickAction.getUsage(recipe.getCooldownTime());
        FluidStack fluidStack = new FluidStack((Fluid)RegistryEntries.FLUID_BLOOD, amount);
        object.add("fluid", (JsonElement)IRegistryExportable.serializeFluidStack((FluidStack)fluidStack));
        return object;
    }
}

