/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.network.packet;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.network.packet.PlayerPositionPacket;
import org.cyclops.evilcraft.Advancements;
import org.cyclops.evilcraft.EvilCraft;
import org.cyclops.evilcraft.GeneralConfig;
import org.cyclops.evilcraft.client.particle.ParticleFartData;

public class FartPacket
extends PlayerPositionPacket {
    private static final int MAX_PARTICLES = 200;
    private static final int MIN_PARTICLES = 100;
    private static final float CLIENT_PLAYER_Y_OFFSET = -0.8f;
    private static final float REMOTE_PLAYER_Y_OFFSET = 0.65f;
    private static final List<UUID> ALLOW_RAINBOW_FARTS = new ArrayList<UUID>();

    public FartPacket() {
    }

    public FartPacket(PlayerEntity player) {
        super(player);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void actionClient(World world, PlayerEntity player) {
        if (GeneralConfig.farting) {
            super.actionClient(world, player);
        }
    }

    protected void performClientAction(World world, PlayerEntity player) {
        this.spawnFartParticles(world, player, this.position, true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void spawnFartParticles(World world, PlayerEntity player, Vector3d pos, boolean isRemotePlayer) {
        if (player == null) {
            return;
        }
        Random rand = world.field_73012_v;
        int numParticles = rand.nextInt(100) + 100;
        boolean rainbow = this.hasRainbowFart(player);
        double yaw = (double)player.field_70177_z * Math.PI / 180.0;
        double playerXOffset = Math.sin(yaw) * 0.7;
        double playerZOffset = -Math.cos(yaw) * 0.7;
        float playerYOffset = isRemotePlayer ? 0.65f : -0.8f;
        for (int i = 0; i < numParticles; ++i) {
            double extraDistance = (double)rand.nextFloat() % 0.3;
            double particleX = pos.field_72450_a + playerXOffset + extraDistance;
            double particleY = pos.field_72448_b + (double)playerYOffset;
            double particleZ = pos.field_72449_c + playerZOffset + extraDistance;
            float particleMotionX = -0.5f + rand.nextFloat();
            float particleMotionY = -0.5f + rand.nextFloat();
            float particleMotionZ = -0.5f + rand.nextFloat();
            world.func_195594_a((IParticleData)new ParticleFartData(rainbow), particleX, particleY, particleZ, (double)particleMotionX, (double)particleMotionY, (double)particleMotionZ);
        }
    }

    public boolean hasRainbowFart(PlayerEntity player) {
        return player.func_146103_bH() != null && ALLOW_RAINBOW_FARTS.contains(player.func_146103_bH().getId());
    }

    public void actionServer(World world, ServerPlayerEntity player) {
        if (GeneralConfig.farting) {
            Advancements.FART.test(player);
            super.actionServer(world, player);
        }
    }

    protected PlayerPositionPacket create(PlayerEntity player, int range) {
        return new FartPacket(player);
    }

    protected ModBase getModInstance() {
        return EvilCraft._instance;
    }

    static {
        ALLOW_RAINBOW_FARTS.add(UUID.fromString("068d4de0-3a75-4c6a-9f01-8c37e16a394c"));
        ALLOW_RAINBOW_FARTS.add(UUID.fromString("e1dc75c6-dcf9-4e0c-8fbf-9c6e5e44527c"));
        ALLOW_RAINBOW_FARTS.add(UUID.fromString("777e7aa3-9373-4511-8d75-f99d23ebe252"));
    }
}

