/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.tileentity;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.tileentity.IChestLid;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import org.cyclops.cyclopscore.capability.item.ItemHandlerSlotMasked;
import org.cyclops.cyclopscore.fluid.SingleUseTank;
import org.cyclops.cyclopscore.helper.BlockHelpers;
import org.cyclops.cyclopscore.helper.WorldHelpers;
import org.cyclops.cyclopscore.inventory.SimpleInventory;
import org.cyclops.cyclopscore.inventory.slot.SlotFluidContainer;
import org.cyclops.cyclopscore.tileentity.CyclopsTileEntity;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.block.BlockBloodChest;
import org.cyclops.evilcraft.core.fluid.BloodFluidConverter;
import org.cyclops.evilcraft.core.fluid.ImplicitFluidConversionTank;
import org.cyclops.evilcraft.core.tileentity.TickingTankInventoryTileEntity;
import org.cyclops.evilcraft.core.tileentity.tickaction.ITickAction;
import org.cyclops.evilcraft.core.tileentity.tickaction.TickComponent;
import org.cyclops.evilcraft.inventory.container.ContainerBloodChest;
import org.cyclops.evilcraft.inventory.slot.SlotRepairable;
import org.cyclops.evilcraft.tileentity.tickaction.EmptyFluidContainerInTankTickAction;
import org.cyclops.evilcraft.tileentity.tickaction.bloodchest.RepairItemTickAction;

@OnlyIn(value=Dist.CLIENT, _interface=IChestLid.class)
public class TileBloodChest
extends TickingTankInventoryTileEntity<TileBloodChest>
implements INamedContainerProvider,
IChestLid {
    private static final int TICK_MODULUS = 200;
    public static final int SLOTS_CHEST = 10;
    public static final int SLOTS = 11;
    public static final int SLOT_CONTAINER = 10;
    public static final int LIQUID_PER_SLOT = 10000;
    private final CyclopsTileEntity.ITickingTile tickingTileComponent = new CyclopsTileEntity.TickingTileComponent((CyclopsTileEntity)this);
    public float prevLidAngle;
    public float lidAngle;
    private int playersUsing;
    private static final Map<Class<?>, ITickAction<TileBloodChest>> REPAIR_TICK_ACTIONS = new LinkedHashMap();
    private static final Map<Class<?>, ITickAction<TileBloodChest>> EMPTY_IN_TANK_TICK_ACTIONS;

    public TileBloodChest() {
        super(RegistryEntries.TILE_ENTITY_BLOOD_CHEST, 11, 64, 10000, (Fluid)RegistryEntries.FLUID_BLOOD);
        for (int i = 0; i < 10; ++i) {
            this.addTicker(new TickComponent<TileBloodChest, ITickAction<TileBloodChest>>(this, REPAIR_TICK_ACTIONS, i));
        }
        this.addTicker(new TickComponent<TileBloodChest, ITickAction<TileBloodChest>>(this, EMPTY_IN_TANK_TICK_ACTIONS, 10, false, true));
    }

    @Override
    protected void addItemHandlerCapabilities() {
        LazyOptional itemHandlerChest = LazyOptional.of(() -> new ItemHandlerSlotMasked((IInventory)this.getInventory(), new int[]{10}));
        LazyOptional itemHandlerContainer = LazyOptional.of(() -> new ItemHandlerSlotMasked((IInventory)this.getInventory(), new int[]{10}));
        this.addCapabilitySided(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.UP, itemHandlerChest);
        this.addCapabilitySided(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.DOWN, itemHandlerChest);
        this.addCapabilitySided(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.NORTH, itemHandlerContainer);
        this.addCapabilitySided(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.SOUTH, itemHandlerContainer);
        this.addCapabilitySided(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.WEST, itemHandlerContainer);
        this.addCapabilitySided(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.EAST, itemHandlerContainer);
    }

    public Direction getRotation() {
        if (this.func_145831_w() == null) {
            return Direction.SOUTH;
        }
        return ((Direction)BlockHelpers.getSafeBlockStateProperty((BlockState)this.func_195044_w(), (Property)BlockBloodChest.FACING, (Comparable)Direction.SOUTH)).func_176734_d();
    }

    @Override
    protected SingleUseTank createTank(int tankSize) {
        return new ImplicitFluidConversionTank(tankSize, BloodFluidConverter.getInstance());
    }

    @Override
    protected SimpleInventory createInventory(int inventorySize, int stackSize) {
        return new SimpleInventory(inventorySize, stackSize){

            public boolean func_94041_b(int slot, ItemStack itemstack) {
                if (slot == 10) {
                    return SlotFluidContainer.checkIsItemValid((ItemStack)itemstack, (Fluid)RegistryEntries.FLUID_BLOOD);
                }
                if (slot <= 10 && slot >= 0) {
                    return SlotRepairable.checkIsItemValid(itemstack);
                }
                return false;
            }

            public void func_174889_b(PlayerEntity entityPlayer) {
                TileBloodChest.this.triggerPlayerUsageChange(1);
            }

            public void func_174886_c(PlayerEntity entityPlayer) {
                TileBloodChest.this.triggerPlayerUsageChange(-1);
            }

            public boolean func_70300_a(PlayerEntity entityPlayer) {
                return super.func_70300_a(entityPlayer) && TileBloodChest.this.field_145850_b != null && TileBloodChest.this.field_145850_b.func_175625_s(TileBloodChest.this.func_174877_v()) == TileBloodChest.this;
            }
        };
    }

    @Override
    public int getNewState() {
        return 0;
    }

    @Override
    public void onStateChanged() {
    }

    @Override
    public void updateTileEntity() {
        super.updateTileEntity();
        int x = this.func_174877_v().func_177958_n();
        int y = this.func_174877_v().func_177956_o();
        int z = this.func_174877_v().func_177952_p();
        if (this.field_145850_b != null && !this.field_145850_b.func_201670_d() && this.playersUsing != 0 && WorldHelpers.efficientTick((World)this.field_145850_b, (int)200, (BlockPos)this.func_174877_v())) {
            this.playersUsing = 0;
            float range = 5.0f;
            List entities = this.field_145850_b.func_217357_a(PlayerEntity.class, new AxisAlignedBB((double)((float)x - range), (double)((float)y - range), (double)((float)z - range), (double)((float)(x + 1) + range), (double)((float)(y + 1) + range), (double)((float)(z + 1) + range)));
            for (PlayerEntity player : entities) {
                if (!(player.field_71070_bA instanceof ContainerBloodChest)) continue;
                ++this.playersUsing;
            }
            this.field_145850_b.func_175641_c(this.func_174877_v(), this.func_195044_w().func_177230_c(), 1, this.playersUsing);
        }
        this.prevLidAngle = this.lidAngle;
        float increaseAngle = 0.1f;
        if (this.playersUsing > 0 && this.lidAngle == 0.0f) {
            this.field_145850_b.func_184134_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, SoundEvents.field_187657_V, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f, false);
        }
        if (this.playersUsing == 0 && this.lidAngle > 0.0f || this.playersUsing > 0 && this.lidAngle < 1.0f) {
            float closedAngle;
            float preIncreaseAngle = this.lidAngle;
            this.lidAngle = this.playersUsing > 0 ? (this.lidAngle += increaseAngle) : (this.lidAngle -= increaseAngle);
            if (this.lidAngle > 1.0f) {
                this.lidAngle = 1.0f;
            }
            if (this.lidAngle < (closedAngle = 0.5f) && preIncreaseAngle >= closedAngle) {
                this.field_145850_b.func_184134_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, SoundEvents.field_187651_T, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f, false);
            }
            if (this.lidAngle < 0.0f) {
                this.lidAngle = 0.0f;
            }
        }
    }

    public boolean func_145842_c(int i, int j) {
        if (i == 1) {
            this.playersUsing = j;
        }
        return true;
    }

    private void triggerPlayerUsageChange(int change) {
        if (this.field_145850_b != null) {
            this.playersUsing += change;
            this.field_145850_b.func_175641_c(this.func_174877_v(), this.func_195044_w().func_177230_c(), 1, this.playersUsing);
        }
    }

    @Nullable
    public Container createMenu(int id, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerBloodChest(id, playerInventory, (IInventory)this.getInventory(), Optional.of(this));
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("block.evilcraft.blood_chest");
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_195480_a(float partialTicks) {
        return MathHelper.func_219799_g((float)partialTicks, (float)this.prevLidAngle, (float)this.lidAngle);
    }

    @Override
    public void func_73660_a() {
        this.tickingTileComponent.func_73660_a();
    }

    static {
        REPAIR_TICK_ACTIONS.put(Item.class, new RepairItemTickAction());
        EMPTY_IN_TANK_TICK_ACTIONS = new LinkedHashMap();
        EMPTY_IN_TANK_TICK_ACTIONS.put(Item.class, new EmptyFluidContainerInTankTickAction());
    }
}

