/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.tileentity;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.items.CapabilityItemHandler;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.capability.item.ItemHandlerSlotMasked;
import org.cyclops.cyclopscore.datastructure.SingleCache;
import org.cyclops.cyclopscore.fluid.SingleUseTank;
import org.cyclops.cyclopscore.helper.BlockHelpers;
import org.cyclops.cyclopscore.inventory.SimpleInventory;
import org.cyclops.cyclopscore.inventory.slot.SlotFluidContainer;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.block.BlockBloodInfuser;
import org.cyclops.evilcraft.core.fluid.BloodFluidConverter;
import org.cyclops.evilcraft.core.fluid.ImplicitFluidConversionTank;
import org.cyclops.evilcraft.core.recipe.type.InventoryFluidTier;
import org.cyclops.evilcraft.core.recipe.type.RecipeBloodInfuser;
import org.cyclops.evilcraft.core.tileentity.TileWorking;
import org.cyclops.evilcraft.core.tileentity.tickaction.ITickAction;
import org.cyclops.evilcraft.core.tileentity.tickaction.TickComponent;
import org.cyclops.evilcraft.core.tileentity.upgrade.IUpgradeSensitiveEvent;
import org.cyclops.evilcraft.core.tileentity.upgrade.UpgradeBehaviour;
import org.cyclops.evilcraft.core.tileentity.upgrade.Upgrades;
import org.cyclops.evilcraft.inventory.container.ContainerBloodInfuser;
import org.cyclops.evilcraft.tileentity.tickaction.EmptyFluidContainerInTankTickAction;
import org.cyclops.evilcraft.tileentity.tickaction.bloodinfuser.FluidContainerItemTickAction;
import org.cyclops.evilcraft.tileentity.tickaction.bloodinfuser.InfuseItemTickAction;

public class TileBloodInfuser
extends TileWorking<TileBloodInfuser, MutableInt>
implements INamedContainerProvider {
    public static final int SLOTS = 3;
    public static final int SLOT_CONTAINER = 0;
    public static final int SLOT_INFUSE = 1;
    public static final int SLOT_INFUSE_RESULT = 2;
    public static final int LIQUID_PER_SLOT = 10000;
    public static Metadata METADATA = new Metadata();
    private int infuseTicker = this.addTicker(new TickComponent<TileBloodInfuser, ITickAction<TileBloodInfuser>>(this, INFUSE_TICK_ACTIONS, 1));
    private SingleCache<Triple<ItemStack, Integer, Integer>, Optional<RecipeBloodInfuser>> recipeCache;
    private float xp;
    private static final Multimap<Class<?>, ITickAction<TileBloodInfuser>> INFUSE_TICK_ACTIONS = LinkedListMultimap.create();
    private static final Map<Class<?>, ITickAction<TileBloodInfuser>> EMPTY_IN_TANK_TICK_ACTIONS;
    public static int TICKERS;
    public static final Upgrades.UpgradeEventType UPGRADEEVENT_SPEED;
    public static final Upgrades.UpgradeEventType UPGRADEEVENT_BLOODUSAGE;
    public static final Upgrades.UpgradeEventType UPGRADEEVENT_FILLBLOODPERTICK;

    public TileBloodInfuser() {
        super(RegistryEntries.TILE_ENTITY_BLOOD_INFUSER, 3, 64, 10000, (Fluid)RegistryEntries.FLUID_BLOOD);
        this.addTicker(new TickComponent<TileBloodInfuser, ITickAction<TileBloodInfuser>>(this, EMPTY_IN_TANK_TICK_ACTIONS, 0, false, true));
        assert (this.getTickers().size() == TICKERS);
        this.upgradeBehaviour.put(Upgrades.UPGRADE_EFFICIENCY, new UpgradeBehaviour<TileBloodInfuser, MutableInt>(2.0){

            @Override
            public void applyUpgrade(TileBloodInfuser upgradable, Upgrades.Upgrade upgrade, int upgradeLevel, IUpgradeSensitiveEvent<MutableInt> event) {
                if (event.getType() == UPGRADEEVENT_BLOODUSAGE) {
                    int val = event.getObject().getValue();
                    val = (int)((double)val / (1.0 + (double)upgradeLevel / this.valueFactor));
                    event.getObject().setValue(val);
                }
            }
        });
        this.upgradeBehaviour.put(Upgrades.UPGRADE_SPEED, new UpgradeBehaviour<TileBloodInfuser, MutableInt>(1.0){

            @Override
            public void applyUpgrade(TileBloodInfuser upgradable, Upgrades.Upgrade upgrade, int upgradeLevel, IUpgradeSensitiveEvent<MutableInt> event) {
                if (event.getType() == UPGRADEEVENT_FILLBLOODPERTICK) {
                    int val = event.getObject().getValue();
                    val = (int)((double)val * (1.0 + (double)upgradeLevel / this.valueFactor));
                    event.getObject().setValue(val);
                } else if (event.getType() == UPGRADEEVENT_SPEED) {
                    int val = event.getObject().getValue();
                    val = (int)((double)val / (1.0 + (double)upgradeLevel / this.valueFactor));
                    event.getObject().setValue(val);
                }
            }
        });
        this.recipeCache = new SingleCache((SingleCache.ICacheUpdater)new SingleCache.ICacheUpdater<Triple<ItemStack, Integer, Integer>, Optional<RecipeBloodInfuser>>(){

            public Optional<RecipeBloodInfuser> getNewValue(Triple<ItemStack, Integer, Integer> key) {
                InventoryFluidTier recipeInput = new InventoryFluidTier((NonNullList<ItemStack>)NonNullList.func_193580_a((Object)ItemStack.field_190927_a, (Object[])new ItemStack[]{(ItemStack)key.getLeft()}), (NonNullList<FluidStack>)NonNullList.func_193580_a((Object)FluidStack.EMPTY, (Object[])new FluidStack[]{new FluidStack((Fluid)RegistryEntries.FLUID_BLOOD, ((Integer)key.getMiddle()).intValue())}), (Integer)key.getRight());
                return TileBloodInfuser.this.field_145850_b.func_199532_z().func_215370_b(TileBloodInfuser.this.getRegistry(), (IInventory)recipeInput, TileBloodInfuser.this.func_145831_w()).stream().max(Comparator.comparingInt(RecipeBloodInfuser::getInputTier));
            }

            public boolean isKeyEqual(Triple<ItemStack, Integer, Integer> cacheKey, Triple<ItemStack, Integer, Integer> newKey) {
                return cacheKey == null || newKey == null || ItemStack.func_77989_b((ItemStack)((ItemStack)cacheKey.getLeft()), (ItemStack)((ItemStack)newKey.getLeft())) && ((Integer)cacheKey.getMiddle()).equals(newKey.getMiddle()) && ((Integer)cacheKey.getRight()).equals(newKey.getRight());
            }
        });
    }

    @Override
    protected void addItemHandlerCapabilities() {
        LazyOptional itemHandlerInfuse = LazyOptional.of(() -> new ItemHandlerSlotMasked((IInventory)this.getInventory(), new int[]{1}));
        LazyOptional itemHandlerInfuseResult = LazyOptional.of(() -> new ItemHandlerSlotMasked((IInventory)this.getInventory(), new int[]{2}));
        LazyOptional itemHandlerContainer = LazyOptional.of(() -> new ItemHandlerSlotMasked((IInventory)this.getInventory(), new int[]{0}));
        this.addCapabilitySided(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.UP, itemHandlerInfuse);
        this.addCapabilitySided(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.DOWN, itemHandlerInfuseResult);
        this.addCapabilitySided(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.NORTH, itemHandlerContainer);
        this.addCapabilitySided(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.SOUTH, itemHandlerContainer);
        this.addCapabilitySided(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.WEST, itemHandlerContainer);
        this.addCapabilitySided(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.EAST, itemHandlerContainer);
    }

    @Override
    protected SimpleInventory createInventory(int inventorySize, int stackSize) {
        return new Inventory(inventorySize, stackSize, this);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT data) {
        data.func_74776_a("xp", this.xp);
        return super.func_189515_b(data);
    }

    @Override
    public void read(CompoundNBT data) {
        this.xp = data.func_74760_g("xp");
        super.read(data);
    }

    public Direction getRotation() {
        return ((Direction)BlockHelpers.getSafeBlockStateProperty((BlockState)this.func_145831_w().func_180495_p(this.func_174877_v()), (Property)BlockBloodInfuser.FACING, (Comparable)Direction.NORTH)).func_176734_d();
    }

    @Override
    protected SingleUseTank createTank(int tankSize) {
        return new ImplicitFluidConversionTank(tankSize, BloodFluidConverter.getInstance());
    }

    public Optional<RecipeBloodInfuser> getRecipe(ItemStack itemStack) {
        return (Optional)this.recipeCache.get((Object)Triple.of((Object)(itemStack.func_190926_b() ? ItemStack.field_190927_a : itemStack.func_77946_l()), (Object)this.getTank().getFluidAmount(), (Object)this.getTileWorkingMetadata().getTier((IInventory)this.getInventory())));
    }

    @Override
    public void onStateChanged() {
        this.sendUpdate();
        this.field_145850_b.func_175656_a(this.func_174877_v(), (BlockState)this.field_145850_b.func_180495_p(this.func_174877_v()).func_206870_a((Property)BlockBloodInfuser.ON, (Comparable)Boolean.valueOf(this.isWorking())));
        BlockHelpers.markForUpdate((World)this.func_145831_w(), (BlockPos)this.func_174877_v());
    }

    @Override
    public Metadata getTileWorkingMetadata() {
        return METADATA;
    }

    @Override
    public boolean canWork() {
        return true;
    }

    @Override
    protected int getWorkTicker() {
        return this.infuseTicker;
    }

    @Nullable
    public Container createMenu(int id, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerBloodInfuser(id, playerInventory, (IInventory)this.getInventory(), Optional.of(this));
    }

    public IRecipeType<RecipeBloodInfuser> getRegistry() {
        return RegistryEntries.RECIPETYPE_BLOOD_INFUSER;
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("block.evilcraft.blood_infuser");
    }

    public void setXp(float xp) {
        this.xp = xp;
        this.func_70296_d();
    }

    public float getXp() {
        return this.xp;
    }

    public void addXp(float xp) {
        this.setXp(this.getXp() + xp);
    }

    public void resetXp() {
        this.setXp(0.0f);
    }

    static {
        INFUSE_TICK_ACTIONS.put(Item.class, (Object)new FluidContainerItemTickAction());
        INFUSE_TICK_ACTIONS.put(Item.class, (Object)new InfuseItemTickAction());
        EMPTY_IN_TANK_TICK_ACTIONS = new LinkedHashMap();
        EMPTY_IN_TANK_TICK_ACTIONS.put(Item.class, new EmptyFluidContainerInTankTickAction());
        TICKERS = 2;
        UPGRADEEVENT_SPEED = Upgrades.newUpgradeEventType();
        UPGRADEEVENT_BLOODUSAGE = Upgrades.newUpgradeEventType();
        UPGRADEEVENT_FILLBLOODPERTICK = Upgrades.newUpgradeEventType();
    }

    public static class Inventory
    extends TileWorking.Inventory<TileBloodInfuser> {
        public Inventory(int size, int stackLimit, TileBloodInfuser tile) {
            super(size, stackLimit, tile);
        }

        @Override
        public boolean func_94041_b(int slot, ItemStack itemStack) {
            if (slot == 1) {
                return ((TileBloodInfuser)this.tile).getTileWorkingMetadata().canConsume(itemStack, ((TileBloodInfuser)this.tile).func_145831_w());
            }
            if (slot == 0) {
                return SlotFluidContainer.checkIsItemValid((ItemStack)itemStack, (Fluid)RegistryEntries.FLUID_BLOOD);
            }
            return super.func_94041_b(slot, itemStack);
        }
    }

    public static class Metadata
    extends TileWorking.Metadata {
        private Metadata() {
            super(3);
        }

        @Override
        public boolean canConsume(ItemStack itemStack, World world) {
            LazyOptional fluidHandler;
            if (!itemStack.func_190926_b() && (fluidHandler = FluidUtil.getFluidHandler((ItemStack)itemStack.func_77946_l().func_77979_a(1))).isPresent()) {
                return true;
            }
            InventoryFluidTier recipeInput = new InventoryFluidTier((NonNullList<ItemStack>)NonNullList.func_193580_a((Object)ItemStack.field_190927_a, (Object[])new ItemStack[]{itemStack}), (NonNullList<FluidStack>)NonNullList.func_193580_a((Object)FluidStack.EMPTY, (Object[])new FluidStack[]{new FluidStack((Fluid)RegistryEntries.FLUID_BLOOD, Integer.MAX_VALUE)}), 3);
            return world.func_199532_z().func_215371_a(RegistryEntries.RECIPETYPE_BLOOD_INFUSER, (IInventory)recipeInput, world).isPresent();
        }

        @Override
        public boolean canInsertItem(IInventory inventory, int slot, ItemStack itemStack) {
            return slot != this.getProduceSlot() && super.canInsertItem(inventory, slot, itemStack);
        }

        @Override
        protected Block getBlock() {
            return RegistryEntries.BLOCK_BLOOD_INFUSER;
        }

        public int getConsumeSlot() {
            return 1;
        }

        public int getProduceSlot() {
            return 2;
        }
    }
}

