/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.tileentity;

import javax.annotation.Nonnull;
import net.minecraft.fluid.Fluid;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.cyclops.cyclopscore.persist.nbt.NBTPersist;
import org.cyclops.cyclopscore.tileentity.CyclopsTileEntity;
import org.cyclops.evilcraft.RegistryEntries;

public class TileBloodStain
extends CyclopsTileEntity {
    public static final int CAPACITY = 5000;
    @NBTPersist
    private Integer amount = 0;

    public TileBloodStain() {
        super(RegistryEntries.TILE_ENTITY_BLOOD_STAIN);
        this.addCapabilityInternal(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, LazyOptional.of(() -> new FluidHandler(this)));
    }

    public int getAmount() {
        return this.amount;
    }

    public void addAmount(int amount) {
        this.amount = Math.min(5000, Math.max(0, this.amount + amount));
        if (this.amount == 0) {
            this.func_145831_w().func_217377_a(this.func_174877_v(), false);
        }
        this.func_70296_d();
    }

    public static class FluidHandler
    implements IFluidHandler {
        private final TileBloodStain tile;

        public FluidHandler(TileBloodStain tile) {
            this.tile = tile;
        }

        public int getTanks() {
            return 1;
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            return new FluidStack((Fluid)RegistryEntries.FLUID_BLOOD, this.tile.getAmount());
        }

        public int getTankCapacity(int tank) {
            return 5000;
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            return tank == 0 && stack.getFluid() == RegistryEntries.FLUID_BLOOD;
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            return 0;
        }

        @Nonnull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            if (resource.getFluid() == RegistryEntries.FLUID_BLOOD) {
                return this.drain(resource.getAmount(), action);
            }
            return FluidStack.EMPTY;
        }

        @Nonnull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            maxDrain = Math.min(this.tile.getAmount(), maxDrain);
            FluidStack drained = new FluidStack((Fluid)RegistryEntries.FLUID_BLOOD, maxDrain);
            if (action.execute()) {
                this.tile.addAmount(-maxDrain);
            }
            return drained;
        }
    }
}

