/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.tileentity;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.cyclops.cyclopscore.helper.WorldHelpers;
import org.cyclops.cyclopscore.persist.nbt.NBTPersist;
import org.cyclops.cyclopscore.tileentity.CyclopsTileEntity;
import org.cyclops.evilcraft.Advancements;
import org.cyclops.evilcraft.EvilCraftSoundEvents;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.entity.monster.EntityVengeanceSpirit;
import org.cyclops.evilcraft.entity.monster.EntityVengeanceSpiritData;

public class TileBoxOfEternalClosure
extends CyclopsTileEntity
implements CyclopsTileEntity.ITickingTile {
    public static final String NBTKEY_SPIRIT = "spiritTag";
    public static final String NBTKEY_PLAYERID = "playerId";
    public static final String NBTKEY_PLAYERNAME = "playerName";
    public static final float START_LID_ANGLE = 65.0f;
    private static final int TICK_MODULUS = 10;
    private static final int TARGET_RADIUS = 10;
    private static final double ABSORB_RADIUS = 0.5;
    private static final int NO_TARGET = -1;
    private static final float LID_STEP = 11.5f;
    private final CyclopsTileEntity.ITickingTile tickingTileComponent = new CyclopsTileEntity.TickingTileComponent((CyclopsTileEntity)this);
    public int innerRotation;
    @NBTPersist
    private CompoundNBT spiritTag = new CompoundNBT();
    @NBTPersist
    private String playerId = "";
    @NBTPersist
    private String playerName = "";
    private EntityVengeanceSpiritData spiritData = null;
    private EntityVengeanceSpirit targetSpirit = null;
    @NBTPersist(useDefaultValue=false)
    private Integer targetSpiritId = -1;
    @NBTPersist(useDefaultValue=false)
    private Float lidAngle = Float.valueOf(65.0f);
    private float previousLidAngle = 65.0f;
    private State state = State.UNKNOWN;

    public TileBoxOfEternalClosure() {
        super(RegistryEntries.TILE_ENTITY_BOX_OF_ETERNAL_CLOSURE);
        this.innerRotation = new Random().nextInt(100000);
    }

    @Nullable
    public static EntityType<?> getSpiritType(@Nullable CompoundNBT tag) {
        if (tag != null) {
            CompoundNBT spiritTag = tag.func_74775_l(NBTKEY_SPIRIT);
            return EntityVengeanceSpiritData.getSpiritType(spiritTag);
        }
        return null;
    }

    public CompoundNBT getSpiritTag() {
        if (this.spiritTag == null) {
            this.spiritTag = new CompoundNBT();
        }
        return this.spiritTag;
    }

    public String getPlayerId() {
        return this.playerId;
    }

    public void setPlayerId(String playerId) {
        this.playerId = playerId;
        this.func_70296_d();
        this.sendUpdate();
    }

    public String getPlayerName() {
        return this.playerName;
    }

    public void setPlayerName(String playerName) {
        this.playerName = playerName;
        this.func_70296_d();
        this.sendUpdate();
    }

    public void setSpiritTag(CompoundNBT tag) {
        this.spiritTag = tag;
        this.func_70296_d();
        this.sendUpdate();
    }

    public boolean isClosed() {
        return this.getState() == State.CLOSED;
    }

    public State getState() {
        if (this.state == State.UNKNOWN) {
            this.updateState();
        }
        return this.state;
    }

    private void setState(State newState) {
        if (newState != this.state) {
            State oldState = this.state;
            this.state = newState;
            this.onStateChanged(oldState, this.state);
        }
    }

    private void updateState() {
        if (this.lidAngle.floatValue() <= 0.0f) {
            this.setState(State.CLOSED);
        } else if (this.lidAngle.floatValue() >= 65.0f) {
            this.setState(State.OPEN);
        }
    }

    private void onStateChanged(State oldState, State newState) {
        if (oldState == State.UNKNOWN) {
            return;
        }
        switch (this.state) {
            case OPEN: {
                this.onBoxOpened();
                break;
            }
            case CLOSED: {
                this.onBoxClosed();
                break;
            }
            case OPENING: {
                this.onBoxOpening();
                break;
            }
            case CLOSING: {
                this.onBoxClosing();
                break;
            }
        }
    }

    private void onBoxOpened() {
        if (!this.field_145850_b.func_201670_d() && this.hasSpirit()) {
            this.releaseSpirit();
        }
    }

    private void onBoxClosed() {
    }

    private void onBoxOpening() {
        if (this.field_145850_b.func_201670_d()) {
            this.playOpenSound();
        }
    }

    private void onBoxClosing() {
        if (this.field_145850_b.func_201670_d()) {
            this.playCloseSound();
        }
    }

    public boolean hasSpirit() {
        return !this.getSpiritTag().isEmpty();
    }

    private void releaseSpirit() {
        EntityVengeanceSpirit spirit = this.createNewVengeanceSpirit();
        this.field_145850_b.func_217376_c((Entity)spirit);
        this.clearSpirit();
    }

    private void playOpenSound() {
        float pitch = this.randomFloat(0.1f, 0.9f);
        this.playSound(SoundEvents.field_187657_V, SoundCategory.BLOCKS, 0.5f, pitch);
    }

    private void playCloseSound() {
        float pitch = this.randomFloat(0.1f, 0.9f);
        this.playSound(SoundEvents.field_187651_T, SoundCategory.BLOCKS, 0.5f, pitch);
    }

    private EntityVengeanceSpirit createNewVengeanceSpirit() {
        Random rand = this.field_145850_b.field_73012_v;
        EntityVengeanceSpirit spirit = EntityVengeanceSpirit.fromNBT(this.func_145831_w(), this.getSpiritTag());
        spirit.func_70107_b((double)this.func_174877_v().func_177958_n() + rand.nextDouble(), (double)this.func_174877_v().func_177956_o() + rand.nextDouble(), (double)this.func_174877_v().func_177952_p() + rand.nextDouble());
        spirit.setFrozenDuration(0);
        spirit.setGlobalVengeance(true);
        spirit.setRemainingLife(MathHelper.func_76136_a((Random)this.field_145850_b.field_73012_v, (int)250, (int)1000));
        return spirit;
    }

    private void clearSpirit() {
        this.spiritTag = new CompoundNBT();
        this.spiritData = null;
    }

    private float randomFloat(float min, float max) {
        return min + this.field_145850_b.field_73012_v.nextFloat() * max;
    }

    private void playSound(SoundEvent sound, SoundCategory category, float volume, float pitch) {
        this.field_145850_b.func_184134_a((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), sound, category, volume, pitch, false);
    }

    public void open() {
        this.setState(State.OPENING);
    }

    public void close() {
        this.setState(State.CLOSING);
    }

    public void initializeState() {
        if (this.hasSpirit()) {
            this.setState(State.CLOSED);
        } else {
            this.setState(State.OPEN);
        }
    }

    private void initializeLidAngle() {
        if (this.getState() == State.OPEN) {
            this.lidAngle = Float.valueOf(65.0f);
            this.previousLidAngle = this.lidAngle.floatValue();
        } else if (this.getState() == State.CLOSED) {
            this.lidAngle = Float.valueOf(0.0f);
            this.previousLidAngle = this.lidAngle.floatValue();
        }
    }

    private void setSpirit(EntityVengeanceSpirit spirit) {
        spirit.getData().writeNBT(this.getSpiritTag());
    }

    public void updateTileEntity() {
        super.updateTileEntity();
        ++this.innerRotation;
        if (!this.field_145850_b.func_201670_d()) {
            this.updateTileEntityServer();
        } else {
            this.updateTileEntityClient();
        }
        this.updateLidAngle();
    }

    private void updateLidAngle() {
        State state = this.getState();
        this.previousLidAngle = this.lidAngle.floatValue();
        if (state == State.OPENING) {
            this.incrementLidAngle(11.5f);
        } else if (state == State.CLOSING) {
            this.incrementLidAngle(-11.5f);
        }
        if (state == State.OPENING || state == State.CLOSING) {
            this.updateState();
        }
    }

    private void updateTileEntityServer() {
        if (!this.hasSpirit() && this.findsOrHasTargetEntity()) {
            this.pullEntity();
        }
    }

    private void pullEntity() {
        EntityVengeanceSpirit target = this.getTargetSpirit();
        if (target != null) {
            double dx = this.targetSpirit.func_226277_ct_() - (double)this.func_174877_v().func_177958_n() - 0.5;
            double dy = this.targetSpirit.func_226278_cu_() - (double)this.func_174877_v().func_177956_o() - 0.5;
            double dz = this.targetSpirit.func_226281_cx_() - (double)this.func_174877_v().func_177952_p() - 0.5;
            double distance = MathHelper.func_76133_a((double)(dx * dx + dy * dy + dz * dz));
            if (!target.func_70089_S() || !target.isFrozen()) {
                this.setTargetSpirit(null);
            } else {
                BlockPos blockPos = this.func_174877_v();
                AxisAlignedBB boxBoundingBox = this.func_195044_w().func_196952_d((IBlockReader)this.field_145850_b, blockPos).func_197751_a((double)blockPos.func_177958_n(), (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p()).func_197752_a();
                AxisAlignedBB spiritBoundingBox = target.func_174813_aQ().func_186662_g(0.5);
                boolean spiritTrapped = spiritBoundingBox.func_72326_a(boxBoundingBox);
                if (spiritTrapped) {
                    this.captureSpirit(this.targetSpirit);
                    this.close();
                } else {
                    double strength = 1.0 / distance / 50.0 + 0.01;
                    target.func_213317_d(target.func_213322_ci().func_178786_a(dx * strength, dy * strength, dz * strength));
                }
            }
        }
    }

    private void captureSpirit(EntityVengeanceSpirit targetSpirit) {
        for (ServerPlayerEntity player : targetSpirit.getEntanglingPlayers()) {
            Advancements.BOX_OF_ETERNAL_CLOSURE_CAPTURE.test(player, (Entity)targetSpirit.getInnerEntity());
        }
        targetSpirit.func_70106_y();
        this.playerId = targetSpirit.getPlayerId();
        this.playerName = targetSpirit.getPlayerName();
        this.setSpirit(targetSpirit);
        this.setTargetSpirit(null);
        this.close();
    }

    private boolean findsOrHasTargetEntity() {
        return this.hasTargetSpirit() || this.findsTargetEntity();
    }

    private boolean findsTargetEntity() {
        return WorldHelpers.efficientTick((World)this.func_145831_w(), (int)10, (BlockPos)this.func_174877_v()) && this.findNextEntity();
    }

    private void updateTileEntityClient() {
        if (this.hasTargetSpirit()) {
            this.playBeamSound();
        }
    }

    private boolean hasTargetSpirit() {
        return this.getTargetSpirit() != null;
    }

    private void playBeamSound() {
        float volume = this.randomFloat(0.1f, 0.9f);
        float pitch = this.randomFloat(0.1f, 0.9f);
        this.playSound(EvilCraftSoundEvents.effect_box_beam, SoundCategory.AMBIENT, volume, pitch);
    }

    private boolean findNextEntity() {
        AxisAlignedBB box = new AxisAlignedBB((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), (double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()).func_72314_b(10.0, 10.0, 10.0);
        List entities = this.field_145850_b.func_217357_a(EntityVengeanceSpirit.class, box);
        double minDistanceSquared = Math.pow(11.0, 2.0);
        EntityVengeanceSpirit closest = null;
        for (EntityVengeanceSpirit spirit : entities) {
            double distance;
            if (!spirit.isFrozen() || spirit.isSwarm() || !((distance = spirit.func_70092_e(this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p())) < minDistanceSquared)) continue;
            minDistanceSquared = distance;
            closest = spirit;
        }
        this.setTargetSpirit(closest);
        return this.targetSpirit != null;
    }

    protected void updateLight() {
        BlockState blockState = this.func_145831_w().func_180495_p(this.func_174877_v());
        this.field_145850_b.func_184138_a(this.func_174877_v(), blockState, blockState, 3);
    }

    public float getLidAngle() {
        return this.lidAngle.floatValue();
    }

    private void setLidAngle(float newLidAngle) {
        if (newLidAngle != this.lidAngle.floatValue()) {
            this.lidAngle = Float.valueOf(newLidAngle);
            if (this.lidAngle.floatValue() < 0.0f) {
                this.lidAngle = Float.valueOf(0.0f);
                this.updateLight();
            } else if (this.lidAngle.floatValue() > 65.0f) {
                this.lidAngle = Float.valueOf(65.0f);
                this.updateLight();
            }
        }
    }

    private void incrementLidAngle(float increment) {
        this.setLidAngle(this.lidAngle.floatValue() + increment);
    }

    public float getPreviousLidAngle() {
        return this.previousLidAngle;
    }

    public EntityVengeanceSpirit getTargetSpirit() {
        if (this.func_145831_w().func_201670_d() && this.targetSpiritId == -1) {
            this.targetSpirit = null;
        } else if (this.targetSpirit == null && this.targetSpiritId != -1) {
            this.setTargetSpirit((EntityVengeanceSpirit)this.func_145831_w().func_73045_a(this.targetSpiritId.intValue()));
        }
        return this.targetSpirit;
    }

    private void setTargetSpirit(EntityVengeanceSpirit targetSpirit) {
        EntityVengeanceSpirit old = this.targetSpirit;
        this.targetSpirit = targetSpirit;
        this.targetSpiritId = targetSpirit != null ? Integer.valueOf(targetSpirit.func_145782_y()) : Integer.valueOf(-1);
        if (old != targetSpirit) {
            this.sendUpdate();
        }
    }

    public EntityVengeanceSpiritData getSpiritData() {
        return this.hasSpirit() ? this.loadSpiritDataLazy() : null;
    }

    private EntityVengeanceSpiritData loadSpiritDataLazy() {
        if (this.spiritData == null) {
            this.spiritData = EntityVengeanceSpiritData.fromNBT(this.getSpiritTag());
        }
        return this.spiritData;
    }

    @OnlyIn(value=Dist.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    protected void onSendUpdate() {
        super.onSendUpdate();
        this.field_145850_b.func_195593_d(this.func_174877_v(), this.func_195044_w().func_177230_c());
    }

    public void read(CompoundNBT tag) {
        super.read(tag);
        this.initializeState();
        this.initializeLidAngle();
    }

    public void func_73660_a() {
        this.tickingTileComponent.func_73660_a();
    }

    public static enum State {
        UNKNOWN,
        OPEN,
        OPENING,
        CLOSING,
        CLOSED;

    }
}

