/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.tileentity;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.IChestLid;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.cyclops.cyclopscore.block.multi.AllowedBlock;
import org.cyclops.cyclopscore.block.multi.CubeDetector;
import org.cyclops.cyclopscore.block.multi.ExactBlockCountValidator;
import org.cyclops.cyclopscore.block.multi.ExactSizeValidator;
import org.cyclops.cyclopscore.block.multi.HollowCubeDetector;
import org.cyclops.cyclopscore.block.multi.IBlockCountValidator;
import org.cyclops.cyclopscore.block.multi.ISizeValidator;
import org.cyclops.cyclopscore.capability.item.ItemHandlerSlotMasked;
import org.cyclops.cyclopscore.fluid.SingleUseTank;
import org.cyclops.cyclopscore.helper.DirectionHelpers;
import org.cyclops.cyclopscore.helper.LocationHelpers;
import org.cyclops.cyclopscore.helper.TileHelpers;
import org.cyclops.cyclopscore.helper.WorldHelpers;
import org.cyclops.cyclopscore.inventory.SimpleInventory;
import org.cyclops.cyclopscore.inventory.slot.SlotFluidContainer;
import org.cyclops.cyclopscore.persist.nbt.NBTPersist;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.block.BlockColossalBloodChestConfig;
import org.cyclops.evilcraft.core.fluid.BloodFluidConverter;
import org.cyclops.evilcraft.core.fluid.ImplicitFluidConversionTank;
import org.cyclops.evilcraft.core.tileentity.TileWorking;
import org.cyclops.evilcraft.core.tileentity.tickaction.ITickAction;
import org.cyclops.evilcraft.core.tileentity.tickaction.TickComponent;
import org.cyclops.evilcraft.core.tileentity.upgrade.IUpgradeSensitiveEvent;
import org.cyclops.evilcraft.core.tileentity.upgrade.UpgradeBehaviour;
import org.cyclops.evilcraft.core.tileentity.upgrade.Upgrades;
import org.cyclops.evilcraft.inventory.container.ContainerColossalBloodChest;
import org.cyclops.evilcraft.inventory.slot.SlotRepairable;
import org.cyclops.evilcraft.tileentity.tickaction.EmptyFluidContainerInTankTickAction;
import org.cyclops.evilcraft.tileentity.tickaction.bloodchest.BulkRepairItemTickAction;

@OnlyIn(value=Dist.CLIENT, _interface=IChestLid.class)
public class TileColossalBloodChest
extends TileWorking<TileColossalBloodChest, MutableFloat>
implements INamedContainerProvider,
IChestLid {
    private static final int TICK_MODULUS = 200;
    public static final int SLOTS_CHEST = 45;
    public static final int SLOTS = 46;
    public static final int SLOT_CONTAINER = 45;
    public static final int LIQUID_PER_SLOT = 10000;
    public static final int MAX_EFFICIENCY = 200;
    public static Metadata METADATA = new Metadata();
    @NBTPersist(useDefaultValue=false)
    private Vector3i size = LocationHelpers.copyLocation((Vector3i)Vector3i.field_177959_e);
    @NBTPersist(useDefaultValue=false)
    private Vector3i renderOffset = new Vector3i(0, 0, 0);
    @NBTPersist
    private Integer efficiency = 0;
    @NBTPersist
    private int rotation = 0;
    private int repairTicker;
    public float prevLidAngle;
    public float lidAngle;
    private int playersUsing;
    private final Map<Integer, Boolean> slotTickHistory;
    public static final Upgrades.UpgradeEventType UPGRADEEVENT_SPEED = Upgrades.newUpgradeEventType();
    public static final Upgrades.UpgradeEventType UPGRADEEVENT_BLOODUSAGE = Upgrades.newUpgradeEventType();
    private static final Map<Class<?>, ITickAction<TileColossalBloodChest>> REPAIR_TICK_ACTIONS = new LinkedHashMap();
    private static final Map<Class<?>, ITickAction<TileColossalBloodChest>> EMPTY_IN_TANK_TICK_ACTIONS;
    public static int TICKERS;
    protected static final ExactSizeValidator exactSizeValidator;
    private static CubeDetector detector;

    public TileColossalBloodChest() {
        super(RegistryEntries.TILE_ENTITY_COLOSSAL_BLOOD_CHEST, 46, 64, 10000, (Fluid)RegistryEntries.FLUID_BLOOD);
        for (int i = 0; i < 45; ++i) {
            this.addTicker(new TickComponent<TileColossalBloodChest, ITickAction<TileColossalBloodChest>>(this, REPAIR_TICK_ACTIONS, i));
        }
        this.addTicker(new TickComponent<TileColossalBloodChest, ITickAction<TileColossalBloodChest>>(this, EMPTY_IN_TANK_TICK_ACTIONS, 45, false, true));
        assert (this.getTickers().size() == TICKERS);
        this.upgradeBehaviour.put(Upgrades.UPGRADE_EFFICIENCY, new UpgradeBehaviour<TileColossalBloodChest, MutableFloat>(2.0){

            @Override
            public void applyUpgrade(TileColossalBloodChest upgradable, Upgrades.Upgrade upgrade, int upgradeLevel, IUpgradeSensitiveEvent<MutableFloat> event) {
                if (event.getType() == UPGRADEEVENT_BLOODUSAGE) {
                    float val = event.getObject().getValue().floatValue();
                    val = (float)((double)val / (1.0 + (double)upgradeLevel / this.valueFactor));
                    event.getObject().setValue(val);
                }
            }
        });
        this.upgradeBehaviour.put(Upgrades.UPGRADE_SPEED, new UpgradeBehaviour<TileColossalBloodChest, MutableFloat>(1.0){

            @Override
            public void applyUpgrade(TileColossalBloodChest upgradable, Upgrades.Upgrade upgrade, int upgradeLevel, IUpgradeSensitiveEvent<MutableFloat> event) {
                if (event.getType() == UPGRADEEVENT_SPEED) {
                    float val = event.getObject().getValue().floatValue();
                    val = (float)((double)val / (1.0 + (double)upgradeLevel / this.valueFactor));
                    event.getObject().setValue(val);
                }
            }
        });
        this.slotTickHistory = Maps.newHashMap();
        this.resetSlotHistory();
    }

    public static CubeDetector getCubeDetector() {
        if (detector == null) {
            detector = new HollowCubeDetector(new AllowedBlock[]{new AllowedBlock((Block)RegistryEntries.BLOCK_REINFORCED_UNDEAD_PLANKS), new AllowedBlock((Block)RegistryEntries.BLOCK_COLOSSAL_BLOOD_CHEST).addCountValidator((IBlockCountValidator)new ExactBlockCountValidator(1))}, (List)Lists.newArrayList((Object[])new Block[]{RegistryEntries.BLOCK_COLOSSAL_BLOOD_CHEST, RegistryEntries.BLOCK_REINFORCED_UNDEAD_PLANKS})).addSizeValidator((ISizeValidator)exactSizeValidator);
        }
        return detector;
    }

    @Override
    protected void addItemHandlerCapabilities() {
        LazyOptional itemHandlerChest = LazyOptional.of(() -> new ItemHandlerSlotMasked((IInventory)this.getInventory(), new int[]{45}));
        LazyOptional itemHandlerContainer = LazyOptional.of(() -> new ItemHandlerSlotMasked((IInventory)this.getInventory(), new int[]{45}));
        this.addCapabilitySided(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.UP, itemHandlerChest);
        this.addCapabilitySided(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.DOWN, itemHandlerChest);
        this.addCapabilitySided(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.NORTH, itemHandlerContainer);
        this.addCapabilitySided(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.SOUTH, itemHandlerContainer);
        this.addCapabilitySided(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.WEST, itemHandlerContainer);
        this.addCapabilitySided(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.EAST, itemHandlerContainer);
    }

    protected void resetSlotHistory() {
        for (int i = 0; i < this.getBasicInventorySize(); ++i) {
            this.slotTickHistory.put(i, false);
        }
    }

    @Override
    protected SingleUseTank createTank(int tankSize) {
        return new ImplicitFluidConversionTank(tankSize, BloodFluidConverter.getInstance());
    }

    public boolean isStructureComplete() {
        return !this.getSize().equals((Object)Vector3i.field_177959_e);
    }

    public int getSizeSingular() {
        return this.getSize().func_177958_n() + 1;
    }

    public Vector3i getSize() {
        return this.size;
    }

    public void setSize(Vector3i size) {
        this.size = size;
        this.sendUpdate();
    }

    @Override
    public Metadata getTileWorkingMetadata() {
        return METADATA;
    }

    @Override
    public boolean canWork() {
        Vector3i size = this.getSize();
        return size.compareTo(exactSizeValidator.getExactSize()) == 0;
    }

    public static boolean canWork(World world, BlockPos location) {
        return TileHelpers.getSafeTile((IBlockReader)world, (BlockPos)location, TileColossalBloodChest.class).map(TileColossalBloodChest::canWork).orElse(false);
    }

    @Override
    protected int getWorkTicker() {
        return this.repairTicker;
    }

    @Override
    public int getNewState() {
        return 0;
    }

    @Override
    public void onStateChanged() {
    }

    @Override
    public void updateTileEntity() {
        this.resetSlotHistory();
        super.updateTileEntity();
        if (this.field_145850_b != null && !this.field_145850_b.func_201670_d() && this.field_145850_b.func_82737_E() % (long)BlockColossalBloodChestConfig.ticksPerDamage == 0L) {
            int oldEfficiency = this.efficiency;
            this.efficiency = Math.max(0, this.efficiency - BlockColossalBloodChestConfig.baseConcurrentItems);
            if (oldEfficiency != this.efficiency) {
                this.func_70296_d();
            }
        }
        if (this.field_145850_b != null && !this.field_145850_b.func_201670_d() && this.playersUsing != 0 && WorldHelpers.efficientTick((World)this.field_145850_b, (int)200, (int[])new int[]{this.func_174877_v().hashCode()})) {
            this.playersUsing = 0;
            float range = 5.0f;
            List entities = this.field_145850_b.func_217357_a(PlayerEntity.class, new AxisAlignedBB(this.func_174877_v().func_177973_b(new Vector3i((double)range, (double)range, (double)range)), this.func_174877_v().func_177971_a(new Vector3i((double)(1.0f + range), (double)(1.0f + range), (double)(1.0f + range)))));
            for (PlayerEntity player : entities) {
                if (!(player.field_71070_bA instanceof ContainerColossalBloodChest)) continue;
                ++this.playersUsing;
            }
            this.field_145850_b.func_175641_c(this.func_174877_v(), this.func_195044_w().func_177230_c(), 1, this.playersUsing);
        }
        this.prevLidAngle = this.lidAngle;
        float increaseAngle = 0.05f;
        if (this.playersUsing > 0 && this.lidAngle == 0.0f) {
            this.field_145850_b.func_184134_a((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5, SoundEvents.field_187657_V, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.5f, false);
        }
        if (this.playersUsing == 0 && this.lidAngle > 0.0f || this.playersUsing > 0 && this.lidAngle < 1.0f) {
            float closedAngle;
            float preIncreaseAngle = this.lidAngle;
            this.lidAngle = this.playersUsing > 0 ? (this.lidAngle += increaseAngle) : (this.lidAngle -= increaseAngle);
            if (this.lidAngle > 1.0f) {
                this.lidAngle = 1.0f;
            }
            if (this.lidAngle < (closedAngle = 0.5f) && preIncreaseAngle >= closedAngle) {
                this.field_145850_b.func_184134_a((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5, SoundEvents.field_187651_T, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.5f, false);
            }
            if (this.lidAngle < 0.0f) {
                this.lidAngle = 0.0f;
            }
        }
    }

    public boolean func_145842_c(int i, int j) {
        if (i == 1) {
            this.playersUsing = j;
        }
        return true;
    }

    @Override
    protected SimpleInventory createInventory(int inventorySize, int stackSize) {
        return new TileWorking.Inventory<TileColossalBloodChest>(inventorySize, stackSize, this){

            public void func_174889_b(PlayerEntity entityPlayer) {
                TileColossalBloodChest.this.triggerPlayerUsageChange(1);
            }

            public void func_174886_c(PlayerEntity entityPlayer) {
                TileColossalBloodChest.this.triggerPlayerUsageChange(-1);
            }

            public boolean func_70300_a(PlayerEntity entityPlayer) {
                return super.func_70300_a(entityPlayer) && TileColossalBloodChest.this.field_145850_b != null && TileColossalBloodChest.this.field_145850_b.func_175625_s(TileColossalBloodChest.this.func_174877_v()) == this.tile;
            }

            @Override
            public boolean func_94041_b(int slot, ItemStack itemStack) {
                if (slot == 45) {
                    return SlotFluidContainer.checkIsItemValid((ItemStack)itemStack, (Fluid)RegistryEntries.FLUID_BLOOD);
                }
                if (slot <= 45 && slot >= 0) {
                    return SlotRepairable.checkIsItemValid(itemStack);
                }
                return super.func_94041_b(slot, itemStack);
            }
        };
    }

    private void triggerPlayerUsageChange(int change) {
        if (this.field_145850_b != null) {
            this.playersUsing += change;
            this.field_145850_b.func_175641_c(this.func_174877_v(), this.func_195044_w().func_177230_c(), 1, this.playersUsing);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.func_174877_v().func_177973_b(new Vector3i(3, 3, 3)), this.func_174877_v().func_177982_a(3, 6, 3));
    }

    public void setCenter(BlockPos center) {
        Direction rotation = Direction.NORTH;
        if (center.func_177958_n() != this.func_174877_v().func_177958_n()) {
            rotation = DirectionHelpers.getEnumFacingFromXSign((int)(center.func_177958_n() - this.func_174877_v().func_177958_n()));
        } else if (center.func_177952_p() != this.func_174877_v().func_177952_p()) {
            rotation = DirectionHelpers.getEnumFacingFromZSing((int)(center.func_177952_p() - this.func_174877_v().func_177952_p()));
        }
        this.setRotation(rotation);
        this.renderOffset = this.func_174877_v().func_177973_b((Vector3i)center);
    }

    public void setRotation(Direction rotation) {
        this.rotation = rotation.ordinal();
    }

    public Direction getRotation() {
        return Direction.func_82600_a((int)this.rotation);
    }

    public Vector3i getRenderOffset() {
        return this.renderOffset;
    }

    @Nullable
    public Container createMenu(int id, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerColossalBloodChest(id, playerInventory, (IInventory)this.getInventory(), Optional.of(this));
    }

    public static void detectStructure(World world, BlockPos location, Vector3i size, boolean valid, BlockPos originCorner) {
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("block.evilcraft.colossal_blood_chest");
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_195480_a(float partialTicks) {
        return MathHelper.func_219799_g((float)partialTicks, (float)this.prevLidAngle, (float)this.lidAngle);
    }

    public Integer getEfficiency() {
        return this.efficiency;
    }

    public void setEfficiency(Integer efficiency) {
        this.efficiency = efficiency;
    }

    public Map<Integer, Boolean> getSlotTickHistory() {
        return this.slotTickHistory;
    }

    static {
        REPAIR_TICK_ACTIONS.put(Item.class, new BulkRepairItemTickAction());
        EMPTY_IN_TANK_TICK_ACTIONS = new LinkedHashMap();
        EMPTY_IN_TANK_TICK_ACTIONS.put(Item.class, new EmptyFluidContainerInTankTickAction());
        TICKERS = 46;
        exactSizeValidator = new ExactSizeValidator(new Vector3i(2, 2, 2));
    }

    private static class Metadata
    extends TileWorking.Metadata {
        private Metadata() {
            super(46);
        }

        @Override
        public boolean canConsume(ItemStack itemStack, World world) {
            return SlotRepairable.checkIsItemValid(itemStack);
        }

        @Override
        protected Block getBlock() {
            return RegistryEntries.BLOCK_COLOSSAL_BLOOD_CHEST;
        }
    }
}

