/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.tileentity;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import org.cyclops.cyclopscore.helper.TileHelpers;
import org.cyclops.cyclopscore.inventory.PlayerExtendedInventoryIterator;
import org.cyclops.cyclopscore.persist.nbt.NBTPersist;
import org.cyclops.cyclopscore.tileentity.CyclopsTileEntity;
import org.cyclops.evilcraft.GeneralConfig;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.core.tileentity.TankInventoryTileEntity;

public class TileDarkTank
extends TankInventoryTileEntity
implements CyclopsTileEntity.ITickingTile {
    public static final int BASE_CAPACITY = 16000;
    private final CyclopsTileEntity.ITickingTile tickingTileComponent = new CyclopsTileEntity.TickingTileComponent((CyclopsTileEntity)this);
    @NBTPersist
    private boolean enabled;

    public TileDarkTank() {
        super(RegistryEntries.TILE_ENTITY_DARK_TANK, 0, 0, 16000, null);
    }

    public double getFillRatio() {
        return Math.min(1.0, (double)this.getTank().getFluidAmount() / (double)this.getTank().getCapacity());
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.sendUpdate();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    protected void updateTileEntity() {
        if (!this.func_145831_w().func_201670_d() && !this.getTank().isEmpty() && this.isEnabled()) {
            Direction down = Direction.DOWN;
            IFluidHandler handler = (IFluidHandler)TileHelpers.getCapability((IBlockReader)this.field_145850_b, (BlockPos)this.func_174877_v().func_177972_a(down), (Direction)down.func_176734_d(), (Capability)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).orElse(null);
            if (handler != null) {
                FluidStack fluidStack = new FluidStack(this.getTank().getFluid(), Math.min(GeneralConfig.mbFlowRate, this.getTank().getFluidAmount()));
                if (handler.fill(fluidStack, IFluidHandler.FluidAction.SIMULATE) > 0) {
                    int filled = handler.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
                    this.getTank().drain(filled, IFluidHandler.FluidAction.EXECUTE);
                }
            } else {
                List entities = this.field_145850_b.func_175647_a(Entity.class, new AxisAlignedBB(this.func_174877_v().func_177972_a(down), this.func_174877_v().func_177972_a(down).func_177982_a(1, 1, 1)), EntityPredicates.field_94557_a);
                for (Entity entity : entities) {
                    if (!this.getTank().isEmpty() && entity instanceof ItemEntity) {
                        ItemStack itemStack;
                        ItemStack fillItemStack;
                        ItemEntity item = (ItemEntity)entity;
                        if (item.func_92059_d() == null || !item.func_92059_d().getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).isPresent() || item.func_92059_d().func_190916_E() != 1 || (fillItemStack = this.fill(itemStack = item.func_92059_d().func_77946_l())) == null) continue;
                        item.func_92058_a(fillItemStack);
                        continue;
                    }
                    if (!(entity instanceof PlayerEntity)) continue;
                    PlayerEntity player = (PlayerEntity)entity;
                    PlayerExtendedInventoryIterator it = new PlayerExtendedInventoryIterator(player);
                    while (!this.getTank().isEmpty() && it.hasNext()) {
                        ItemStack fillItemStack;
                        ItemStack itemStack = it.next();
                        if (itemStack.func_190926_b() || !itemStack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).isPresent() || (fillItemStack = this.fill(itemStack)) == null) continue;
                        it.replace(fillItemStack);
                    }
                }
            }
        }
    }

    @Nullable
    protected ItemStack fill(ItemStack itemStack) {
        FluidStack fluidStack;
        IFluidHandlerItem container = (IFluidHandlerItem)itemStack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).orElse(null);
        if (container.fill(fluidStack = new FluidStack(this.getTank().getFluid(), Math.min(GeneralConfig.mbFlowRate, this.getTank().getFluidAmount())), IFluidHandler.FluidAction.SIMULATE) > 0) {
            int filled = container.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
            this.getTank().drain(filled, IFluidHandler.FluidAction.EXECUTE);
            return container.getContainer();
        }
        return null;
    }

    @Override
    public void onTankChanged() {
        super.onTankChanged();
        this.sendUpdate();
    }

    public void func_73660_a() {
        this.tickingTileComponent.func_73660_a();
    }
}

