/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.tileentity;

import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import org.cyclops.cyclopscore.helper.BlockHelpers;
import org.cyclops.cyclopscore.inventory.SimpleInventory;
import org.cyclops.cyclopscore.persist.IDirtyMarkListener;
import org.cyclops.cyclopscore.persist.nbt.NBTPersist;
import org.cyclops.cyclopscore.tileentity.CyclopsTileEntity;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.block.BlockDisplayStand;

public class TileDisplayStand
extends CyclopsTileEntity
implements CyclopsTileEntity.ITickingTile {
    protected final CyclopsTileEntity.ITickingTile tickingTileComponent = new CyclopsTileEntity.TickingTileComponent((CyclopsTileEntity)this);
    @NBTPersist
    private ItemStack displayStandType;
    @NBTPersist
    private boolean directionPositive = false;
    private final SimpleInventory inventory = new SimpleInventory(1, 1);

    public TileDisplayStand() {
        super(RegistryEntries.TILE_ENTITY_DISPLAY_STAND);
        this.addCapabilityInternal(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, LazyOptional.of(() -> ((SimpleInventory)this.inventory).getItemHandler()));
        this.inventory.addDirtyMarkListener((IDirtyMarkListener)this);
    }

    public SimpleInventory getInventory() {
        return this.inventory;
    }

    public void onDirty() {
        super.onDirty();
        this.sendUpdate();
    }

    public Direction.AxisDirection getDirection() {
        return this.directionPositive ? Direction.AxisDirection.POSITIVE : Direction.AxisDirection.NEGATIVE;
    }

    public void setDirection(Direction.AxisDirection direction) {
        this.directionPositive = direction == Direction.AxisDirection.POSITIVE;
        this.sendUpdate();
    }

    public void setDisplayStandType(ItemStack displayStandType) {
        this.displayStandType = displayStandType;
        this.sendUpdate();
    }

    public ItemStack getDisplayStandType() {
        return this.displayStandType;
    }

    protected Direction getFacing() {
        return (Direction)BlockHelpers.getSafeBlockStateProperty((BlockState)this.func_145831_w().func_180495_p(this.func_174877_v()), (Property)BlockDisplayStand.FACING, (Comparable)Direction.NORTH);
    }

    protected ItemStack getContents() {
        return this.inventory.func_70301_a(0);
    }

    public void read(CompoundNBT tag) {
        super.read(tag);
        this.inventory.readFromNBT(tag, "inventory");
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        this.inventory.writeToNBT(tag, "inventory");
        return super.func_189515_b(tag);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            capability = CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY;
        }
        return facing == this.getFacing() || facing == this.getFacing().func_176734_d() || this.getContents().func_190926_b() ? super.getCapability(capability, facing) : this.getContents().getCapability(capability, null);
    }

    public void onUpdateReceived() {
        super.onUpdateReceived();
        BlockHelpers.markForUpdate((World)this.field_145850_b, (BlockPos)this.field_174879_c);
    }

    public void func_73660_a() {
        this.tickingTileComponent.func_73660_a();
    }
}

