/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.tileentity;

import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import org.cyclops.cyclopscore.tileentity.CyclopsTileEntity;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.core.fluid.WorldSharedTank;
import org.cyclops.evilcraft.core.fluid.WorldSharedTankCache;

public class TileEntangledChalice
extends CyclopsTileEntity
implements CyclopsTileEntity.ITickingTile {
    public static final int BASE_CAPACITY = 4000;
    private final CyclopsTileEntity.ITickingTile tickingTileComponent = new CyclopsTileEntity.TickingTileComponent((CyclopsTileEntity)this);
    private final WorldSharedTank tank = new WorldSharedTank(4000);

    public TileEntangledChalice() {
        super(RegistryEntries.TILE_ENTITY_ENTANGLED_CHALICE);
        this.addCapabilityInternal(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, LazyOptional.of(this::getTank));
    }

    public WorldSharedTank getTank() {
        return this.tank;
    }

    public double getFillRatio() {
        int prev = this.getTank().getPreviousAmount();
        float alpha = (float)WorldSharedTankCache.getInstance().getTickOffset() / 10.0f;
        double interpolatedAmount = (float)prev * (1.0f - alpha) + (float)this.getTank().getFluidAmount() * alpha;
        return Math.min(1.0, interpolatedAmount / (double)this.getTank().getCapacity());
    }

    protected void updateTileEntity() {
        super.updateTileEntity();
        this.getTank().resetPreviousFluid();
    }

    public String getWorldTankId() {
        return this.getTank().getTankID();
    }

    public void setWorldTankId(String tankId) {
        this.getTank().setTankID(tankId);
    }

    public void read(CompoundNBT tag) {
        super.read(tag);
        this.tank.readFromNBT(tag, "tank");
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        this.tank.writeToNBT(tag, "tank");
        return super.func_189515_b(tag);
    }

    public void func_73660_a() {
        this.tickingTileComponent.func_73660_a();
    }
}

