/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.tileentity;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.math.vector.Vector4f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.BossInfo;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.server.ServerBossInfo;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.helper.CraftingHelpers;
import org.cyclops.cyclopscore.helper.EntityHelpers;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.helper.LocationHelpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.inventory.SimpleInventory;
import org.cyclops.cyclopscore.persist.IDirtyMarkListener;
import org.cyclops.cyclopscore.tileentity.CyclopsTileEntity;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.api.degradation.IDegradable;
import org.cyclops.evilcraft.block.BlockEnvironmentalAccumulatorConfig;
import org.cyclops.evilcraft.client.particle.ParticleBlurTargettedData;
import org.cyclops.evilcraft.client.particle.ParticleBubbleExtendedData;
import org.cyclops.evilcraft.core.degradation.DegradationExecutor;
import org.cyclops.evilcraft.core.recipe.type.RecipeEnvironmentalAccumulator;
import org.cyclops.evilcraft.core.tileentity.EvilCraftBeaconTileEntity;
import org.cyclops.evilcraft.core.weather.WeatherType;

public class TileEnvironmentalAccumulator
extends EvilCraftBeaconTileEntity
implements IDegradable {
    public static final int MAX_AGE = 50;
    public static final int SPREAD = 25;
    private static final int ITEM_MOVE_COOLDOWN_DURATION = 1;
    private static final double WEATHER_CONTAINER_MIN_DROP_HEIGHT = 0.0;
    private static final double WEATHER_CONTAINER_MAX_DROP_HEIGHT = 2.0;
    private static final double WEATHER_CONTAINER_SPAWN_HEIGHT = (double)BlockEnvironmentalAccumulatorConfig.defaultProcessItemTickCount * BlockEnvironmentalAccumulatorConfig.defaultProcessItemSpeed + 1.0;
    private static final float ITEM_MIN_SPAWN_HEIGHT = 1.0f;
    private static final int DEGRADATION_RADIUS_BASE = 5;
    private static final int DEGRADATION_TICK_INTERVAL = 100;
    private final CyclopsTileEntity.ITickingTile tickingTileComponent = new CyclopsTileEntity.TickingTileComponent((CyclopsTileEntity)this);
    private DegradationExecutor degradationExecutor;
    private int degradation = 0;
    private BlockPos location = null;
    private static final BlockPos[] waterOffsets = new BlockPos[]{new BlockPos(-2, -1, -2), new BlockPos(-2, -1, 2), new BlockPos(2, -1, -2), new BlockPos(2, -1, 2)};
    private ServerBossInfo bossInfo = null;
    private int state = 0;
    private int tick = 0;
    private Inventory inventory;
    @Nullable
    private RecipeEnvironmentalAccumulator recipe;
    private String recipeId;

    public TileEnvironmentalAccumulator() {
        super(RegistryEntries.TILE_ENTITY_ENVIRONMENTAL_ACCUMULATOR);
        this.recreateBossInfo();
        this.degradationExecutor = new DegradationExecutor(this);
        this.inventory = new Inventory(this);
        this.addCapabilityInternal(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, LazyOptional.of(() -> ((Inventory)this.inventory).getItemHandler()));
        this.inventory.addDirtyMarkListener((IDirtyMarkListener)this);
        if (MinecraftHelpers.isClientSide()) {
            this.setBeamColor(this.getOuterColorByState(this.state));
        }
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    protected void recreateBossInfo() {
        this.bossInfo = (ServerBossInfo)new ServerBossInfo((ITextComponent)new TranslationTextComponent("chat.evilcraft.boss_display.charge"), BossInfo.Color.PURPLE, BossInfo.Overlay.PROGRESS).func_186741_a(false);
    }

    protected Triple<Float, Float, Float> getBaseBeamColor() {
        if (this.func_145831_w() == null) {
            return Triple.of((Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f));
        }
        Biome biome = this.func_145831_w().func_226691_t_(this.func_174877_v());
        return Helpers.intToRGB((int)biome.func_225528_a_((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177952_p()));
    }

    @OnlyIn(value=Dist.CLIENT)
    private Vector4f getOuterColorByState(int state) {
        Triple<Float, Float, Float> baseColor = this.getBaseBeamColor();
        float coolFactor = (float)(this.getMaxCooldownTick() - this.tick) / (float)this.getMaxCooldownTick();
        if (state == 1) {
            return new Vector4f(((Float)baseColor.getLeft()).floatValue(), ((Float)baseColor.getMiddle()).floatValue(), ((Float)baseColor.getRight()).floatValue(), 0.05f);
        }
        if (state == 0) {
            return new Vector4f(((Float)baseColor.getLeft()).floatValue(), ((Float)baseColor.getMiddle()).floatValue(), ((Float)baseColor.getRight()).floatValue(), 0.13f);
        }
        return new Vector4f(((Float)baseColor.getLeft()).floatValue() * coolFactor, ((Float)baseColor.getMiddle()).floatValue() * coolFactor, ((Float)baseColor.getRight()).floatValue() * coolFactor, 0.13f);
    }

    public int getMaxCooldownTick() {
        return this.recipe == null ? BlockEnvironmentalAccumulatorConfig.defaultTickCooldown : this.recipe.getCooldownTime();
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getMovingItemY() {
        if (this.state == 1) {
            return 1.0f + (float)(this.getItemMoveDuration() - this.tick) * this.getItemMoveSpeed();
        }
        return -1.0f;
    }

    public RecipeEnvironmentalAccumulator getRecipe() {
        return this.recipe;
    }

    private int getItemMoveDuration() {
        if (this.recipe == null) {
            return BlockEnvironmentalAccumulatorConfig.defaultProcessItemTickCount;
        }
        return this.recipe.getDuration();
    }

    private float getItemMoveSpeed() {
        if (this.recipe == null) {
            return (float)BlockEnvironmentalAccumulatorConfig.defaultProcessItemSpeed;
        }
        return this.recipe.getProcessingSpeed();
    }

    public void updateTileEntity() {
        super.updateTileEntity();
        if (this.recipeId != null && this.func_145831_w() != null) {
            this.recipe = this.field_145850_b.func_199532_z().func_215367_a(new ResourceLocation(this.recipeId)).orElse(null);
            this.recipeId = null;
        }
        if (this.tick > 0) {
            --this.tick;
        }
        if (this.state == 0) {
            this.updateEnvironmentalAccumulatorIdle();
        } else if (this.state == 1) {
            if (this.field_145850_b.func_201670_d()) {
                this.showWaterBeams();
                if (this.tick > 50) {
                    this.showAccumulatingParticles();
                }
            }
            if (this.tick == 0) {
                this.dropItemStack();
                this.activateFinishedProcessingItemState();
                this.getBossInfo().func_201360_b();
                this.recreateBossInfo();
            } else {
                this.sendUpdate();
            }
        } else if (this.state == 3) {
            if (this.tick == 0) {
                this.activateCooldownState();
                this.getInventory().func_70298_a(0, this.getInventory().func_70297_j_());
            } else {
                this.sendUpdate();
            }
        } else if (this.state == 2) {
            this.setBeamColor(this.state);
            this.degradationExecutor.runRandomEffect(this.field_145850_b.func_201670_d());
            if (this.tick == 0) {
                this.activateIdleState();
            } else {
                this.sendUpdate();
            }
        }
        if (!this.func_145831_w().func_201670_d()) {
            this.getBossInfo().func_186735_a(this.getHealth() / this.getMaxHealth());
            HashSet playerIds = Sets.newHashSet();
            if (this.getHealth() != this.getMaxHealth()) {
                for (PlayerEntity player : this.func_145831_w().func_217357_a(PlayerEntity.class, new AxisAlignedBB(this.func_174877_v()).func_186662_g(32.0))) {
                    this.getBossInfo().func_186760_a((ServerPlayerEntity)player);
                    playerIds.add(player.func_145782_y());
                }
            }
            ArrayList players = Lists.newArrayList((Iterable)this.getBossInfo().func_186757_c());
            for (ServerPlayerEntity playerMP : players) {
                if (playerIds.contains(playerMP.func_145782_y()) && this.getHealth() != 0.0f) continue;
                this.getBossInfo().func_186761_b(playerMP);
            }
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.getBossInfo().func_201360_b();
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void showWaterBeams() {
        Random random = this.field_145850_b.field_73012_v;
        BlockPos target = this.func_174877_v();
        for (int j = 0; j < waterOffsets.length; ++j) {
            BlockPos offset = waterOffsets[j];
            BlockPos location = target.func_177971_a((Vector3i)offset);
            double x = (double)location.func_177958_n() + 0.5;
            double y = (double)location.func_177956_o() + 0.5;
            double z = (double)location.func_177952_p() + 0.5;
            float rotationYaw = (float)LocationHelpers.getYaw((BlockPos)location, (BlockPos)target);
            float rotationPitch = (float)LocationHelpers.getPitch((BlockPos)location, (BlockPos)target);
            for (int i = 0; i < random.nextInt(2); ++i) {
                double particleX = x - 0.2 + random.nextDouble() * 0.4;
                double particleY = y - 0.2 + random.nextDouble() * 0.4;
                double particleZ = z - 0.2 + random.nextDouble() * 0.4;
                double speed = 2.0;
                double particleMotionX = (double)(MathHelper.func_76126_a((float)(rotationPitch / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(rotationYaw / 180.0f * (float)Math.PI))) * speed;
                double particleMotionY = (double)MathHelper.func_76134_b((float)(rotationPitch / 180.0f * (float)Math.PI)) * speed * 5.0;
                double particleMotionZ = (double)(MathHelper.func_76126_a((float)(rotationPitch / 180.0f * (float)Math.PI)) * MathHelper.func_76126_a((float)(rotationYaw / 180.0f * (float)Math.PI))) * speed;
                Minecraft.func_71410_x().field_71438_f.func_195461_a((IParticleData)new ParticleBubbleExtendedData(0.02f), false, particleX, particleY, particleZ, particleMotionX, particleMotionY, particleMotionZ);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void showAccumulatingParticles() {
        TileEnvironmentalAccumulator.showAccumulatingParticles(this.field_145850_b, (float)this.func_174877_v().func_177958_n() + 0.5f, (float)this.func_174877_v().func_177956_o() + 0.5f, (float)this.func_174877_v().func_177952_p() + 0.5f, 25.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void showAccumulatingParticles(World world, float centerX, float centerY, float centerZ, float spread) {
        Random rand = world.field_73012_v;
        for (int j = 0; j < rand.nextInt(20); ++j) {
            float scale = 0.6f - rand.nextFloat() * 0.4f;
            float red = rand.nextFloat() * 0.1f + 0.2f;
            float green = rand.nextFloat() * 0.1f + 0.3f;
            float blue = rand.nextFloat() * 0.1f + 0.2f;
            float ageMultiplier = 60.0f;
            float motionX = spread - rand.nextFloat() * 2.0f * spread;
            float motionY = spread - rand.nextFloat() * 2.0f * spread;
            float motionZ = spread - rand.nextFloat() * 2.0f * spread;
            Minecraft.func_71410_x().field_71438_f.func_195461_a((IParticleData)new ParticleBlurTargettedData(red, green, blue, scale, ageMultiplier, centerX, centerY, centerZ), false, (double)centerX, (double)centerY, (double)centerZ, (double)motionX, (double)motionY, (double)motionZ);
        }
    }

    protected IRecipeType<RecipeEnvironmentalAccumulator> getRegistry() {
        return RegistryEntries.RECIPETYPE_ENVIRONMENTAL_ACCUMULATOR;
    }

    private void updateEnvironmentalAccumulatorIdle() {
        List entityItems = this.field_145850_b.func_217357_a(ItemEntity.class, new AxisAlignedBB((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o() + 0.0, (double)this.func_174877_v().func_177952_p(), (double)this.func_174877_v().func_177958_n() + 1.0, (double)this.func_174877_v().func_177956_o() + 2.0, (double)this.func_174877_v().func_177952_p() + 1.0));
        for (RecipeEnvironmentalAccumulator recipe : CraftingHelpers.findRecipes((World)this.field_145850_b, this.getRegistry())) {
            Ingredient recipeIngredient = recipe.getInputIngredient();
            WeatherType weatherType = recipe.getInputWeather();
            for (Object obj : entityItems) {
                ItemEntity entityItem = (ItemEntity)obj;
                ItemStack stack = entityItem.func_92059_d();
                if (!recipeIngredient.test(stack) || weatherType != null && !weatherType.isActive(this.field_145850_b)) continue;
                this.getInventory().func_70299_a(0, stack.func_77946_l());
                this.recipe = recipe;
                if (!this.field_145850_b.func_201670_d()) {
                    this.decreaseStackSize(entityItem, 1);
                }
                this.activateProcessingItemState();
                return;
            }
        }
    }

    private void decreaseStackSize(ItemEntity entityItem, int count) {
        entityItem.func_92059_d().func_190918_g(count);
        if (entityItem.func_92059_d().func_190916_E() == 0) {
            entityItem.func_70106_y();
        }
    }

    private void dropItemStack() {
        if (!this.field_145850_b.func_201670_d()) {
            ItemEntity entity = new ItemEntity(this.field_145850_b, (double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o() + WEATHER_CONTAINER_SPAWN_HEIGHT, (double)this.func_174877_v().func_177952_p());
            if (this.recipe == null) {
                entity.func_92058_a(this.getInventory().func_70301_a(0));
            } else {
                WeatherType weatherResult;
                entity.func_92058_a(this.recipe.getCraftingResult(this.getInventory()));
                WeatherType weatherSource = this.recipe.getInputWeather();
                if (weatherSource != null) {
                    weatherSource.deactivate((ServerWorld)this.field_145850_b);
                }
                if ((weatherResult = this.recipe.getOutputWeather()) != null) {
                    weatherResult.activate((ServerWorld)this.field_145850_b);
                }
            }
            this.field_145850_b.func_217376_c((Entity)entity);
        }
    }

    private void activateIdleState() {
        this.tick = 0;
        this.state = 0;
        if (!this.field_145850_b.func_201670_d()) {
            this.sendUpdate();
            this.func_70296_d();
        }
    }

    private void activateProcessingItemState() {
        this.tick = this.recipe == null ? BlockEnvironmentalAccumulatorConfig.defaultProcessItemTickCount : this.recipe.getDuration();
        this.state = 1;
        if (!this.field_145850_b.func_201670_d()) {
            this.sendUpdate();
            this.func_70296_d();
        }
    }

    private void activateFinishedProcessingItemState() {
        this.tick = 1;
        this.state = 3;
        if (!this.field_145850_b.func_201670_d()) {
            this.sendUpdate();
            this.func_70296_d();
        }
    }

    private void activateCooldownState() {
        ++this.degradation;
        this.degradationExecutor.setTickInterval(100 / this.degradation);
        this.tick = this.getMaxCooldownTick();
        this.state = 2;
        this.recipe = null;
        if (!this.field_145850_b.func_201670_d()) {
            this.sendUpdate();
            this.func_70296_d();
        }
    }

    public void onUpdateReceived() {
        if (this.field_145850_b.func_201670_d() && this.state == 3) {
            this.field_145850_b.func_175669_a(2002, this.func_174877_v().func_177963_a(0.0, WEATHER_CONTAINER_SPAWN_HEIGHT, 0.0), 16428);
        }
        this.setBeamColor(this.state);
    }

    public void setBeamColor(int state) {
        if (this.field_145850_b.func_201670_d()) {
            this.setBeamColor(this.getOuterColorByState(state));
        }
    }

    public int getState() {
        return this.state;
    }

    public void read(CompoundNBT compound) {
        super.read(compound);
        this.inventory.readFromNBT(compound, "inventory");
        this.degradation = compound.func_74762_e("degradation");
        this.tick = compound.func_74762_e("tick");
        this.state = compound.func_74762_e("state");
        this.recipeId = compound.func_74779_i("recipe");
        this.degradationExecutor.read(compound);
        if (this.func_145831_w() != null && this.func_145831_w().func_201670_d()) {
            this.setBeamColor(this.getOuterColorByState(this.state));
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag = super.func_189515_b(tag);
        this.inventory.writeToNBT(tag, "inventory");
        tag.func_74768_a("degradation", this.degradation);
        tag.func_74768_a("tick", this.tick);
        tag.func_74768_a("state", this.state);
        if (this.recipe != null) {
            tag.func_74778_a("recipe", this.recipe.func_199560_c().toString());
        }
        this.degradationExecutor.write(tag);
        return tag;
    }

    public float getMaxHealth() {
        if (this.state == 1) {
            return this.getItemMoveDuration();
        }
        if (this.state == 3) {
            return 0.0f;
        }
        return this.getMaxCooldownTick();
    }

    public float getHealth() {
        if (this.state == 1) {
            return this.tick;
        }
        if (this.state == 2) {
            return this.getMaxCooldownTick() - this.tick;
        }
        return this.getMaxCooldownTick();
    }

    @Override
    public BlockPos getLocation() {
        return this.func_174877_v();
    }

    @Override
    public int getRadius() {
        return 5 + this.degradation / 10;
    }

    @Override
    public List<Entity> getAreaEntities() {
        return EntityHelpers.getEntitiesInArea((World)this.getDegradationWorld(), (BlockPos)this.func_174877_v(), (int)this.getRadius());
    }

    @Override
    public double getDegradation() {
        return this.degradation;
    }

    @Override
    public World getDegradationWorld() {
        return this.func_145831_w();
    }

    public ServerBossInfo getBossInfo() {
        return this.bossInfo;
    }

    public void func_73660_a() {
        this.tickingTileComponent.func_73660_a();
    }

    public static class Inventory
    extends SimpleInventory
    implements RecipeEnvironmentalAccumulator.Inventory {
        private final TileEnvironmentalAccumulator tile;

        public Inventory(TileEnvironmentalAccumulator tile) {
            super(1, 64);
            this.tile = tile;
        }

        @Override
        public World getWorld() {
            return this.tile.func_145831_w();
        }

        @Override
        public BlockPos getPos() {
            return this.tile.func_174877_v();
        }
    }
}

